/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef MIDINOTENODE_H
#define MIDINOTENODE_H

#include <string>
#include "NodeBase.h"
#include "InputPort.h"
#include "MidiInNode.h"
#include "types.h"
#include "Array.h"

using std::string;

namespace Om {


/** MIDI note input node.
 *
 * For pitched instruments like keyboard, etc.
 *
 * Note that this is the only polyphonic MidiInNode, at the moment.
 *
 * \ingroup engine
 */
class MidiNoteNode : public MidiInNode
{
public:
	MidiNoteNode(const string& path, uint poly, Patch* parent, samplerate srate, size_t buffer_size);
	~MidiNoteNode();

	void note_on(int note_num, int velocity, int start_sample);
	void note_off(int note_num, int start_sample);
	void all_notes_off(int start_sample);

	void run(size_t nframes);

private:
	enum VoiceState 
	{	VOICE_FREE, VOICE_ACTIVE };

	float note_to_freq(int num);
	
	Array<int>*        m_voice_notes;
	Array<uint>*       m_voice_ages;
	Array<VoiceState>* m_voice_states;
};


} // namespace Om

#endif // MIDINOTENODE_H
