/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "EnableEvent.h"
#include "Om.h"
#include "OmApp.h"
#include "OSCSender.h"

namespace Om {


EnableEvent::EnableEvent(Request* request)
: SlowEvent(request)
{
}


void
EnableEvent::prepare()
{
	SlowEvent::prepare();
}


void
EnableEvent::execute(uint sample_offset)
{
	SlowEvent::execute(sample_offset);
}


void
EnableEvent::post_process()
{
	m_request->respond_ok();
	om->enable();
	om->osc_sender()->send_engine_enable();
}


} // namespace Om

