/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "ControlOutputNode.h"
#include "InputPort.h"
#include "OutputPort.h"
#include "Plugin.h"
#include "Patch.h"
#include "Om.h"
#include "OSCSender.h"
#include "Connection.h"
#include "JackDriver.h"
#include <cassert>

namespace Om {


ControlOutputNode::ControlOutputNode(const string& path, uint poly, Patch* parent, samplerate srate, size_t buffer_size)
: OutputNode(path, poly, parent, srate, buffer_size)
{
	m_external_port = new OutputPort(parent, m_name, 0, m_poly, new PortInfo(m_name, CONTROL, OUTPUT), 1);
	InputPort* iport = new InputPort(this, "out", 0, m_poly, new PortInfo("out", CONTROL, INPUT), 1);
	iport->join(m_external_port);

	m_num_ports = 1;
	m_ports.alloc(m_num_ports);
	m_ports.at(0) = iport;

	m_plugin.type(Plugin::Internal);
	m_plugin.lib_path("");
	m_plugin.lib_name("");
	m_plugin.plug_label("control_output");
	m_plugin.name("Om patch control output node");

	m_listnode = new ListNode<OutputNode*>(this);
}


ControlOutputNode::~ControlOutputNode()
{
	delete m_external_port;
	delete m_listnode;
}


void
ControlOutputNode::add_to_patch()
{
	parent_patch()->output_nodes().push_back(m_listnode);
	InternalNode::add_to_patch();
}


void
ControlOutputNode::remove_from_patch()
{
	ListNode<OutputNode*>* ln = parent_patch()->output_nodes().remove(this);
	om->maid()->push(ln);
	m_listnode = NULL; // avoid a double delete in destructor
	InternalNode::remove_from_patch();
}


void
ControlOutputNode::send_creation_messages(lo_address addr) const
{
	om->osc_sender()->send_new_port_to(addr, m_external_port);
	InternalNode::send_creation_messages(addr);
}


void
ControlOutputNode::send_deletion_messages(lo_address addr) const
{
	InternalNode::send_deletion_messages(addr);
	om->osc_sender()->send_port_removal_to(addr, m_external_port);
}


} // namespace Om

