/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef OMPORT_H
#define OMPORT_H

#include <cassert>
#include <string>
#include <list>
#include "canvas/Port.h"
#include "OmGtkObject.h"
#include "OmModule.h"
#include "PortModel.h"
#include "OmGtk.h"
#include "StateManager.h"

namespace LibOmClient { class PortModel; class MetadataModel; }
using namespace LibOmClient;
using namespace PatchBay;
using std::string; using std::list;

namespace OmGtk {
	
class PatchBayArea;
class PatchController;
class PatchWindow;
class ControlPanel;


/** A Port on an OmModule.
 *
 * This class can be thought of as the 'master' view class for a Port.  All
 * port related events get sent here (metadata, control changes, etc).
 * Everything done in response must be done here.
 * 
 * \ingroup OmGtk
 */
class OmPort : public PatchBay::Port, public OmGtkObject
{
public:
	OmPort(OmModule* module, PortModel* pm)
	: Port(module, pm->name(), pm->is_input(), state_manager->get_port_color(pm)),
	  m_port_model(pm),
	  m_parent(module)
	{
		assert(module != NULL);
		assert(m_port_model != NULL);
	}

	virtual ~OmPort() {}

	void name(const string& n);

	void metadata_update(const MetadataModel* const mm);
	void control_change(const ControlModel* const cm);
	
	/** "Register" a control panel that is monitoring this port.
	 *
	 * The OmPort will handle notifying the ControlPanel when state
	 * changes occurr, etc.
	 */
	void add_control_panel(ControlPanel* cp)
		{ m_control_panels.push_back(cp); }

	PortModel* port_model() const { return m_port_model; }
	
private:
	PortModel*          m_port_model;
	OmModule*           m_parent;
	list<ControlPanel*> m_control_panels;
};


} // namespace OmGtk

#endif // OMPORT_H
