/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "OmPort.h"
#include <cassert>
#include "MetadataModel.h"
#include "PortModel.h"
#include "OmModule.h"
#include "ControlModel.h"
#include "ControlPanel.h"
#include "OmPath.h"


using namespace LibOmClient;

namespace OmGtk {


void
OmPort::name(const string& n)
{
	string new_path = OmPath::parent(m_port_model->path()) +"/"+ n;

	for (list<ControlPanel*>::iterator i = m_control_panels.begin(); i != m_control_panels.end(); ++i)
		(*i)->rename_port(m_port_model->path(), new_path);
	
	Port::name(n);
	m_port_model->path(new_path);
}


void
OmPort::metadata_update(const LibOmClient::MetadataModel* const mm)
{
	assert(m_port_model->path() == mm->path());

	if (mm->key() == "user-min") {
		m_port_model->user_min(atof(mm->value().c_str()));
		for (list<ControlPanel*>::iterator i = m_control_panels.begin(); i != m_control_panels.end(); ++i)
			(*i)->set_range_min(m_port_model->path(), atof(mm->value().c_str()));
	} else if (mm->key() == "user-max") {
		m_port_model->user_max(atof(mm->value().c_str()));
		for (list<ControlPanel*>::iterator i = m_control_panels.begin(); i != m_control_panels.end(); ++i)
			(*i)->set_range_max(m_port_model->path(), atof(mm->value().c_str()));
	}
}


void
OmPort::control_change(const ControlModel* const cm)
{
	assert(m_port_model->path() == cm->port_path());

	m_port_model->value(cm->value());
	
	for (list<ControlPanel*>::iterator i = m_control_panels.begin(); i != m_control_panels.end(); ++i)
		(*i)->set_control(m_port_model->path(), cm->value());
}


} // namespace OmGtk
