#ifndef MEMFACTORY_H_
#define MEMFACTORY_H_

#include <list>
#include <iostream>

#include "definition.h"

template <class C> class MemFactory {
private:

  static const uint32 maxElements = 20;

  template <class T> class MemElem {
  public:
    bool used;
    T* memRegion;
    uint32 size;
  };

  std::list<MemElem<C> > list;
  typename std::list<MemElem<C> >::iterator it;

public:
  MemFactory();
  virtual ~MemFactory();

  C* getMemElement(uint32 size);
  void returnMemElement(C* elem);

};

template <class C> inline MemFactory<C>::MemFactory()
{
}

template <class C> inline MemFactory<C>::~MemFactory()
{

  it = list.begin();

  for (; it != list.end(); it++)
    delete[] it->memRegion;
}

template <class C> inline C* MemFactory<C>::getMemElement(uint32 size)
{
  /* is there an unused data portion available, then use it */
  it = list.begin();

  for (; it != list.end(); it++)
    if ((!it->used) && (it->size == size))
      break;

  MemElem<C> elem;
  if (it ==list.end()) {
    //		std::cerr << "Create new Element\n";
    elem.used = true;
    elem.size = size;
    elem.memRegion = new C[size];
  } else {
    elem = (*it);
    elem.used = true;
    list.erase(it);
  }

  list.push_back(elem);

  if (list.size() > maxElements)
    for (it = list.begin(); it != list.end(); it++) {
      if (!it->used) {
        //				std::cerr << "Delete an Element\n";
        delete[] it->memRegion;
        list.erase(it);
        break;
      }
    }

  return (elem.memRegion);

}

template <class C> inline void MemFactory<C>::returnMemElement(C* elem)
{
  it = list.begin();

  for (; it != list.end(); it++)
    if (it->memRegion == elem) {
      it->used = false;
      //			std::cerr << "Free new Element\n";
      break;
    }

}

#endif /*MEMFACTORY_H_*/
