#include "colib.h"
#include "ocr-utils.h"

using namespace colib;
using namespace iulib;
using namespace ocropus;

int count_pixels(bytearray &image, bool white) {
    white = !!white;
    int counter = 0;
    for(int i = 0; i < image.length1d(); i++) {
        if(!!image.at1d(i) == white)
            counter++;
    }
    return counter;
}

// proposed for ocr-utils
void random_binary_image(bytearray &b, int w, int h, int sigma = 2) {
    b.resize(w, h);
    for(int i = 0; i < b.length1d(); i++) {
        b.at1d(i) = 255. * rand() / RAND_MAX;
    }
    gauss2d(b, sigma, sigma);
    binarize_by_threshold(b);
}

double histogram_sum(floatarray &hist) {
    double result = 0;
    for(int i = 0; i < hist.length(); i++)
        result += hist[i] * i;
    return result;
}

// Test that the runlength sum up to the total number of pixels.
void test_runlength_checksum(bytearray &image, bool white) {
    int c = count_pixels(image, white);
    floatarray hist(max(image.dim(0), image.dim(1)) + 1);
    rectangle box(0, 0, image.dim(0), image.dim(1));
    runlength_histogram(hist, image, box, white, /* vertical: */ true);
    TEST_ASSERT(histogram_sum(hist) == c);
    runlength_histogram(hist, image, box, white, /* horizontal: */ false);
    TEST_ASSERT(histogram_sum(hist) == c);
}

void test_runlength_checksum_on_random_images() {
    bytearray image;
    for(int i = 0; i < 20; i++) {
        random_binary_image(image, 20, 20);
        test_runlength_checksum(image, true);
        test_runlength_checksum(image, false);
    }
}

void test_runlength_on_Nx1(int n) {
    bytearray image(n, 1);
    floatarray hist(n + 1);
    fill(image, 0);
    for(int i = 0; i < n; i++) {
        runlength_histogram(hist, image, rectangle(0, 0, i, 1));
        TEST_ASSERT(sum(hist) == !!i);
        TEST_ASSERT(hist[i] == !!i);
    }
    runlength_histogram(hist, image, rectangle(0, 0, n, 1), false, true);
    TEST_ASSERT(sum(hist) == n);
    for(int i = 0; i < n; i += 2) image(i,0) = 255;
    runlength_histogram(hist, image, rectangle(0, 0, n, 1));
    TEST_ASSERT(hist[1] == n / 2);
    TEST_ASSERT(sum(hist) == n / 2);
    runlength_histogram(hist, image, rectangle(0, 0, n, 1), false, true);
    TEST_ASSERT(hist[1] == n / 2);
    TEST_ASSERT(sum(hist) == n / 2);
}

void test_runlength_on_1xN(int n) {
    bytearray image(1, n);
    floatarray hist(n + 1);
    fill(image, 0);
    for(int i = 0; i < n; i++) {
        runlength_histogram(hist, image, rectangle(0, 0, 1, i), false, true);
        TEST_ASSERT(sum(hist) == !!i);
        TEST_ASSERT(hist[i] == !!i);
    }
    runlength_histogram(hist, image, rectangle(0, 0, 1, n), false, false);
    TEST_ASSERT(sum(hist)== n);
    for(int i = 0; i < n; i += 2) image(0,i) = 255;
    runlength_histogram(hist, image, rectangle(0, 0, 1, n), false, true);
    TEST_ASSERT(hist[1] == n / 2);
    TEST_ASSERT(sum(hist) == n / 2);
    runlength_histogram(hist, image, rectangle(0, 0, 1, n), false, false);
    TEST_ASSERT(hist[1] == n / 2);
    TEST_ASSERT(sum(hist) == n / 2);
}


int main() {
    test_runlength_checksum_on_random_images();

    // we need also to check that horizontal and vertical are not confused
    // we do it simultaneously with testing on narrow images
    
    test_runlength_on_Nx1(3);
    test_runlength_on_Nx1(10);
    test_runlength_on_Nx1(15);
    test_runlength_on_1xN(3);
    test_runlength_on_1xN(10);
    test_runlength_on_1xN(15);
}
