/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1999 David Baum.
 * All Rights Reserved.
 */

#include "ValueExpr.h"


ValueExpr::ValueExpr(Expr *e) :
	fExpr(e)
{
}


ValueExpr::~ValueExpr()
{
	delete fExpr;
}


ValueExpr* ValueExpr::Clone(Mapping *b) const
{
	return new ValueExpr(fExpr->Clone(b));
}


RCX_Value ValueExpr::EmitAny_(Bytecode &, const LexLocation *) const
{
	int v;
	
	if (!fExpr->Evaluate(v)) return kIllegalEA;
	
	return (RCX_Value)v;
}


bool ValueExpr::PromiseSensor() const
{
	int v;
	
	if (!fExpr->Evaluate(v)) return false;
	if (RCX_VALUE_TYPE(v) != kRCX_InputValueType) return false;
	
	return true;
}
