/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1999 David Baum.
 * All Rights Reserved.
 */

#include "AtomExpr.h"
#include "Variable.h"
#include "Mapping.h"

AtomExpr::AtomExpr(RCX_ValueType type, int value) :
	fType(type),
	fValue(value)
{
}


bool AtomExpr::PromiseConstant() const
{
	if (fType == kRCX_ConstantType) return true;
	if ((fType == kRCX_VariableType) && 
		(fValue & kLocalConstantFlag)) return true;
	return false;
}

bool AtomExpr::PromiseSensor() const
{
	if (fType == kRCX_InputValueType) return true;
	if ((fType == kRCX_VariableType) && 
		(fValue & kLocalSensorFlag)) return true;
	return false;
}


bool AtomExpr::Evaluate(int &value) const
{
	if (fType != kRCX_ConstantType) return false;
	
	value = fValue;
	return true;	
}


bool AtomExpr::Contains(int var) const
{
	return (fType==kRCX_VariableType && fValue==var);
}


int AtomExpr::GetLValue() const
{
	if (fType != kRCX_VariableType) return kIllegalVar;
	if (fValue & kLocalReadOnlyFlag) return kIllegalVar;
	
	return fValue;
}


RCX_Value AtomExpr::EmitAny_(Bytecode &, const LexLocation *) const
{
	return RCX_VALUE(fType, fValue);
}


Expr* AtomExpr::Clone(Mapping *m) const
{
	if (fType == kRCX_VariableType && m && (fValue & kLocalVarBase))
	{
		const Expr *e = m->Get(fValue & kLocalVarMask);
		if (e)
		{
			return e->Clone(0);
		}
	}
	
	return new AtomExpr(fType, fValue);
}
