.\"
.\" %nmhwarning%
.\" $Id: anno.man,v 1.6 2001/01/25 21:15:52 ssen Exp $
.\"
.TH ANNO %manext1% "%nmhdate%" MH.6.8 [%nmhversion%]
.SH NAME
anno \- annotate messages
.SH SYNOPSIS
.HP 5
.na
.B anno
.RI [ +folder ]
.RI [ msgs ]
.RB [ \-component
.IR field ]
.RB [ \-inplace " | " \-noinplace ]
.RB [ \-date " | " \-nodate ]
.RB [ \-version ]
.RB [ \-help ]
.RB [ \-text
.IR body ]
.ad
.SH DESCRIPTION
.B Anno
annotates the specified messages in the named folder using
the field and body.
.PP
Usually, annotation is performed by the commands
.BR dist ,
.BR forw ,
and
.BR repl ,
if they are given the
.B \-anno
switch.  This allows you to keep track of your distribution of,
forwarding of, and replies to a message.
.PP
By using
.BR anno ,
you can perform arbitrary annotations of your own.
Each message selected will be annotated with the lines
.PP
    field:\ date
    field:\ body
.PP
The
.B \-nodate
switch inhibits the date annotation, leaving only the
body annotation.
.PP
If a
.B \-component
.I field
is not specified when
.B anno
is invoked,
.B anno
will prompt the user for the name of field for the annotation.
.PP
The field specified should be a valid 822-style message field name,
which means that it should consist of alphanumerics (or dashes) only.
The body specified is arbitrary text.
.PP
Normally
.B anno
does the annotation inplace in order to preserve
any links to the message.  You may change this by using the
.B \-noinplace
switch.

.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
.fi

.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Current\-Folder:~^To find the default current folder
.fi

.SH "SEE ALSO"
dist(1), forw(1), repl(1)

.SH DEFAULTS
.nf
.RI ` +folder "' defaults to the current folder"
.RI ` msgs "' defaults to cur"
.RB ` \-inplace '
.RB ` \-date '
.fi

.SH CONTEXT
If a folder is given, it will become the current folder.  The first
message annotated will become the current message.
