

#include "grtui/wizard_progress_page.h"

class FetchSchemaNamesProgressPage : public WizardProgressPage
{
public:
  FetchSchemaNamesProgressPage(WizardForm *form, const char *name= "fetchNames")
    : WizardProgressPage(form, name), _dbconn(0)
  {
    set_title(_("Connect to DBMS and Fetch Information"));
    set_short_title(_("Connect to DBMS"));

    add_async_task(_("Connect to DBMS"),
                   boost::bind(&FetchSchemaNamesProgressPage::perform_connect, this),
                   _("Connecting to DBMS..."));

    add_async_task(_("Retrieve Schema List from Database"), 
                   boost::bind(&FetchSchemaNamesProgressPage::perform_fetch, this),
                   _("Retrieving schema list from database..."));

    end_adding_tasks(true,
                     _("Execution Completed Successfully"));
    
    set_status_text("");
  }

  void set_db_connection(DbConnection *dbc)
  {
    _dbconn= dbc;
  }
  
  
  void set_load_schemata_slot(const boost::function<std::vector<std::string> ()> &slot)
  {
    _load_schemata= slot;
  }
  
protected:
  
  bool perform_connect()
  {
    db_mgmt_ConnectionRef conn = _dbconn->get_connection();
//    conn->parameterValues().set(grt::StringRef("USE_SSH"),grt::IntegerRef(1));
//    conn->parameterValues().set(grt::StringRef("ssh_login"),grt::StringRef("amusienko"));
//    conn->parameterValues().set(grt::StringRef("ssh_password"),grt::StringRef(""));
//    conn->parameterValues().set(grt::StringRef("ssh_key"),grt::StringRef("C:\\.ssh\\key.ppk"));
    _dbconn->set_connection(conn);

    execute_grt_task(boost::bind(&FetchSchemaNamesProgressPage::do_connect, this, _1), false);
    
    return true;
  }
  

  grt::ValueRef do_connect(grt::GRT *grt)
  {
    if (!_dbconn)
      throw std::logic_error("must call set_db_connection() 1st");
    _dbconn->test_connection();

    return grt::ValueRef();
  }


  bool perform_fetch()
  {
    execute_grt_task(boost::bind(&FetchSchemaNamesProgressPage::do_fetch, this, _1),
                     false);
    return true;
  }


  static bool collate(const std::string &a, const std::string &b)
  {
    return g_strcasecmp(a.c_str(), b.c_str()) < 0;
  }


  grt::ValueRef do_fetch(grt::GRT *grt)
  {    
    std::vector<std::string> schema_names= _load_schemata();

    // order the schema names alphabetically
    std::sort(schema_names.begin(), schema_names.end(), std::ptr_fun(&FetchSchemaNamesProgressPage::collate));
    
    grt::StringListRef list(grt);
    for (std::vector<std::string>::const_iterator iter= schema_names.begin();
         iter != schema_names.end(); ++iter)
      list.insert(*iter);
    
    values().set("schemata", list);

    _finished= true;
    
    return grt::ValueRef();
  }

  
  virtual void enter(bool advancing)
  {
    if (advancing)
    {
      _finished= false;
      reset_tasks();
    }
    
    WizardProgressPage::enter(advancing);
  }
  

  virtual bool allow_next()
  {
    return _finished;
  }

private:
  DbConnection *_dbconn;
  boost::function<std::vector<std::string> () > _load_schemata;
  
  bool _finished;
};

