

# channel - lets you define your own channels to
# chat with people on a mud.
# When you create a channel a command and alias
# of the channel's name is created.

proc channel {args} {
    global _channel
    
    set syntax {
        create {{+ name} {? members {}}}
        destroy {{+ name}}
        names {{? glob *}}
        dump  {{+ name} {+ file }}
    }
    
    switch -exact [check -opts channel $syntax $args] {
        create {
            set _channel($arg(name)) $arg(members)
            interp alias {} $arg(name) {} _channel_cmd $arg(name)
            alias set $arg(name) "{$arg(name)} msg \$0"
        } destroy {
	    interp alias {} $arg(name) ""
	    unset _channel($arg(name))
	    alias delete -exact -- $arg(name)
        } names {
            return [array names _channel $arg(glob)]
        } dump {
            set fd [open $arg(file) "w+"]
            puts $fd [list channel create $arg(name) \
		    [list $_channel($arg(name))]]
	    close $fd
        }
    }

    return
}

# The command created by channel
proc _channel_cmd {name args} {
    global _channel

    set syntax {
        add {{+ name}}
        remove {{+ name}}
        names {}
        msg {{+ msg}}
    }
    
    switch -exact [check -opts $name $syntax $args] {
        add {
            lappend _channel($name) $arg(name)
        } remove {
            set i [lsearch -exact $_channel($name) $arg(name)]
            if {$i != -1} {
                set _channel($name) [lreplace $_channel($name) $i $i]
            }
        } names {
            return $_channel($name)
        } msg {
            foreach member $_channel($name) {
                write "tell $member \[$name\]: $arg(msg)"
            }
        }
    }
    
    return    
}
