#####################################################################
# readline.tcl - interface using tclreadline
#
# Copyright (C) 2002 Mark Patton
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#####################################################################

package require tclreadline 2.1

proc mmucl::event {ses event args} {
    variable Mmucl

    switch -exact $event {
	attempt {
	} connect {
	} disconnect {
	} timeout {
	} ses_new {
	} ses_switch {
	} ses_close {
	} default {
	    error "event $event not understood"
	}
    }
}

proc mmucl::display {ses str} {
    variable Mmucl

    if {$ses != $Mmucl(cur)} {
	return
    }
    
    clear_line [string length [tclreadline::readline text]]
    
    puts -nonewline $str
    
    if {![string match *\n* $str]} {
	puts ""
    }

    tclreadline::readline update

    flush stdout    
}

proc clear_line {len} {
    set back [string repeat \b $len]

    puts -nonewline $back
    puts -nonewline [string repeat " " $len]
    puts -nonewline $back
}

proc mmucl::console_parse {} {
    variable Mmucl

    while {1} {
	meta_parse [tclreadline::readline read ""]
    }
}

proc mmucl::MCbell {ses args} {
    tclreadline::readline bell
}

proc mmucl::interface_init {} {
    variable Mmucl

    tclreadline::readline initialize ""

    tclreadline::readline eofchar {
	tclreadline::readline reset-terminal
	mmucl::MCexit $Mmucl(cur)
    }

    after idle mmucl::console_parse

    rename interface_init ""
}
