// combfilter.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// CombFilter is an InputOutputFunction which implements a comb filter with a
// transfer function of f(x) = f(x) + f(x-n).  It operates in two modes, either
// as a settable ringtime and looptime (in seconds), or as ringtime and center
// frequency.

#ifndef COMBFILTER_H
#ifdef __GNUG__
#pragma interface
#endif
#define COMBFILTER_H

#include "iofunction.h"

class Delay;

class CombFilter : public SimpleInputOutputFunction {
	typedef SimpleInputOutputFunction Super;
	friend class CombFilterRequester;
public:
	CombFilter(Data* input, Data* output, double delaytime, double ringtime);
	CombFilter(Data* input, Data* output);
	static Modifier* create(class DataEditor *);
	virtual ~CombFilter();
	redefined const char* message() { return "Filtering..."; }
	redefined void restoreState();
protected:
	redefined int newLength(int oldLength);
	redefined boolean areCompatibleLengths(int, int);
	redefined Requester* createRequester();
	redefined void initialize();
	redefined int doProcessing();
	redefined double doSimpleProcess(double);
private:
	void clear();
private:
	Delay *myDelay;
	double delayTime;
	double ringTime;
	double feedBack;
	double gain;
	ChoiceValue filterMode;
	enum Mode { Frequency = 0x01, LoopTime = 0x02 };
};

#endif

