; pair.tac
; 95-10-10

(apc 'qr (c-arrow 'nat 'nat (cons-star 'nat 'nat)))

(define qr
  (lambda (n)
    (lambda (m)
      (cond ((or (undef-nat? n) (undef-nat? m) (zero-nat? m))
	     (cons undef_nat undef_nat))
	    ((and (zero-nat? n) (synt-total? m)) (cons 0 0))
	    ((suc-nat? n)
	     (let* ((prev-qr ((qr (pred-nat n)) m))
		    (prev-quot (quot prev-qr))
		    (prev-quot+1 ((plus-nat prev-quot) 1))
		    (prev-rem (rem prev-qr))
		    (prev-rem+1 ((plus-nat (rem prev-qr)) 1))
		    (test ((<-strict-nat prev-rem+1) m)))
	       (cond ((true? test) (cons prev-quot prev-rem+1))
		     ((false? test) (cons prev-quot+1 0))
		     (else (cons (c-if test prev-quot prev-quot+1)
				 (c-if test prev-rem+1 0))))))
	    (else (normal-app-expr-to-obj (list (list 'qr n) m)
					  (cons-star 'nat 'nat)))))))

(apc 'quot (c-arrow (cons-star 'nat 'nat) 'nat))
(apc 'rem (c-arrow (cons-star 'nat 'nat) 'nat))
(define (quot x) (car x))
(define (rem x) (cdr x))

; Jetzt kommt das eigentliche Ziel:

(set-goal 
  '? 
  (pf "all m,n.0<m -> n=m*(quot(qr n m))+(rem(qr n m)) & (rem(qr n m))<m"))
(ind)
(ng)
(assume 'n)
(prop)
(assume 'm 'ih)
(drop 'ih)
(ind)
(ng)
(prop)
(assume 'n 'u1 'u2)
(split)
(ng)
(cases (pt "(p_2(qr n(m+1)))<m"))
(ng)
(drop 'u1)
(assume 'u)
(drop 'u2)
(use-with 'u '?1)
(drop 'u)
(aga 'lemma3 (pf "all n^,m^.def n^ -> def m^ -> def(n^<m^)"))
(use-with 'lemma3 (pt "p_2(qr n(m+1))") 'm '?2 '?3)
(aga 'lemma4 (pf "all n,m def(p_2(qr n(m+1)))"))
(use-with 'lemma4 'n 'm)
(ng)
(prop)

; Case true:
(drop 'u2)
(assume 'u2)
(ng)
(use-with (list '?4 (pf "n=m*(quot(qr n(m+1)))+(quot(qr n(m+1)))+(p_2(qr n(m+1))) & (p_2(qr n(m+1)))<m+1")) 'left)
(use-with 'u1 truth-axiom)

; Case false:
(ng)
(drop 'u2)
(assume 'u2)
(aga 'lemma-<
     (pf "all p^,m,l^.l^<m+1 -> (l^<m -> p^) -> (l^=m -> p^) -> p^"))
(use-with
 'lemma-<
 (pt "n=m*(quot(qr n(m+1)))+m+(quot(qr n(m+1)))")
 'm
 (pt "p_2(qr n(m+1))")
 '?<m+1 '?< '?=)

; Case ?<m+1
(prop)

; Case ?<
(prop)

; Case ?=
(drop 'u2)
(assume 'u2)
(aga 'trans-= (pf "all n,m^,k^.n=m^ -> m^=k^ -> n=k^"))
(use-with 'trans-=
	  'n
	  (pt "m*(p_1(qr n(m+1)))+(p_1(qr n(m+1)))+(p_2(qr n(m+1)))")
	  (pt "m*(p_1(qr n(m+1)))+m+(p_1(qr n(m+1)))")
	  '?5 '?6)
(prop)
(ng)
(prop)
(ng)
(cases)

;Case undef
(ng)
(drop 'u1)
(drop 'u2)
(assume 'u)
(use-with 'u '?7)
(drop 'u)
(use-with 'lemma3 (pt "p_2(qr n(m+1))") 'm '?8 '?9)
(use-with 'lemma4 'n 'm)
(ng)
(prop)

;Case true
(ng)
(prop)

;Case false
(ng)
(prop)

(out-pproof-as-assertion 
   "Lemma" "(Quotient and remainder with pairs)." 
   "/home/math/schwicht/minlog/examples/arith/quotrem/pair.tex" 'once)



(rpc 'qr 'quot 'p_2)
(rga 'lemma3 'lemma4 'lemma-< 'trans-=)

;Local Variables:
;mode: scheme
;End:
