C-----------------------------------------------------------------------
#include "pdf/pilot.h"
      Subroutine Ctq5F3 (Iset)
#include "pdf/impdp.inc"
      PARAMETER (MXX = 105, MXQ = 25, MXF = 6)
      PARAMETER (MXPQX = (MXF *2 +2) * MXQ * MXX)
      PARAMETER (NxI = 90, NtI = 13, NfMxI = 3)
      COMMON / W5051IC / Al, XV(0:MXX), QL(0:MXQ), UPD(MXPQX)
      COMMON / W5051ID / Nx, Nt, NfMx
      COMMON / W5051IE / Qini, Qmax, Xmin
      DIMENSION Amass(6)
      PARAMETER (NSETS=9)
      DIMENSION 
     >  XVI(0:MXX),QLI(0:MXQ),UPDI(MXPQX),
     >  AmassI(6)
C
C-----------------------------------------------------------------------
C Parton Distribution Table : CTEQ5F3                                          C       PARAMETER (ISET=6) 
        DATA  DrI, FlI, AlI /   2.,   3.,  .3950 /
        DATA  (AmassI(I),I=1,6) /     .000,     .000,     .200,
     +                               1.300,    4.500,  180.000 /
C        DATA  NXI,  NTI, NfMxI /    90,    13,     3 /
        DATA  QINII, QMAXI, (QLI(I), I =0, NTI) /
     +  .100000E+01, .100000E+05,
     +  .100000E+01, .120622E+01, .151109E+01, .198109E+01, .274322E+01,
     +  .405649E+01, .649130E+01, .114216E+02, .225245E+02, .509463E+02,
     +  .135868E+03, .441686E+03, .182160E+04, .100000E+05 /
        DATA  XMINI, (XVI(I), I =0, NXI) /
     +  .100000E-04,
     +  .000000E+00, .999983E-05, .124433E-04, .154836E-04, .192668E-04,
     +  .239740E-04, .298310E-04, .371184E-04, .461852E-04, .574656E-04,
     +  .714994E-04, .889575E-04, .110674E-03, .137686E-03, .171280E-03,
     +  .213055E-03, .264997E-03, .329564E-03, .409809E-03, .509508E-03,
     +  .633332E-03, .787053E-03, .977784E-03, .121428E-02, .150728E-02,
     +  .186993E-02, .231825E-02, .288037E-02, .356397E-02, .440443E-02,
     +  .543508E-02, .669508E-02, .822984E-02, .100851E-01, .123281E-01,
     +  .150167E-01, .182174E-01, .219985E-01, .264278E-01, .315720E-01,
     +  .374800E-01, .442088E-01, .517931E-01, .602576E-01, .696136E-01,
     +  .798586E-01, .909356E-01, .102935E+00, .115681E+00, .129293E+00,
     +  .143599E+00, .158606E+00, .174271E+00, .190550E+00, .207405E+00,
     +  .224796E+00, .242685E+00, .261038E+00, .279820E+00, .299001E+00,
     +  .318550E+00, .338442E+00, .358653E+00, .379067E+00, .399881E+00,
     +  .420953E+00, .442266E+00, .463806E+00, .485559E+00, .507513E+00,
     +  .529656E+00, .551978E+00, .574483E+00, .597187E+00, .619860E+00,
     +  .642828E+00, .665921E+00, .689135E+00, .712467E+00, .735911E+00,
     +  .759464E+00, .783080E+00, .806909E+00, .830741E+00, .854673E+00,
     +  .878696E+00, .902804E+00, .926992E+00, .951257E+00, .975603E+00,
     +  .100000E+01 /
C Parton Distribution Table:                                                   
        DATA (UPDI(I),I=1,52) /
     +  .404361E+05, .140211E+05, .110797E+05, .875538E+04,
     +  .691870E+04, .546736E+04, .432050E+04, .341425E+04,
     +  .269812E+04, .213224E+04, .168507E+04, .133171E+04,
     +  .105249E+04, .831838E+03, .657476E+03, .519691E+03,
     +  .410809E+03, .324766E+03, .256771E+03, .203037E+03,
     +  .160572E+03, .127012E+03, .100489E+03, .795266E+02,
     +  .629581E+02, .498616E+02, .395087E+02, .312210E+02,
     +  .247732E+02, .196736E+02, .156392E+02, .124466E+02,
     +  .991920E+01, .792274E+01, .633614E+01, .507809E+01,
     +  .407937E+01, .328532E+01, .265277E+01, .214746E+01,
     +  .174325E+01, .141831E+01, .115627E+01, .944133E+00,
     +  .771732E+00, .631111E+00, .516419E+00, .421688E+00,
     +  .344232E+00, .280035E+00, .227333E+00, .183908E+00 /
        DATA (UPDI(I),I=53,104) /
     +  .148171E+00, .118821E+00, .947830E-01, .751670E-01,
     +  .592293E-01, .463461E-01, .359923E-01, .277249E-01,
     +  .211701E-01, .160133E-01, .119903E-01, .889277E-02,
     +  .650638E-02, .470011E-02, .334872E-02, .235036E-02,
     +  .162288E-02, .110072E-02, .732054E-03, .476451E-03,
     +  .302664E-03, .187040E-03, .112634E-03, .653595E-04,
     +  .365066E-04, .195156E-04, .991454E-05, .474448E-05,
     +  .211434E-05, .865797E-06, .317201E-06, .101924E-06,
     +  .274365E-07, .580040E-08, .864283E-09, .740883E-10,
     +  .231605E-11, .614267E-14, .000000E+00, .334488E+05,
     +  .265610E+05, .208806E+05, .164075E+05, .128939E+05,
     +  .101279E+05, .795594E+04, .624666E+04, .490498E+04,
     +  .384948E+04, .302130E+04, .237003E+04, .185924E+04 /
        DATA (UPDI(I),I=105,156) /
     +  .145773E+04, .114299E+04, .895688E+03, .701933E+03,
     +  .549772E+03, .430622E+03, .337105E+03, .263925E+03,
     +  .206522E+03, .161630E+03, .126437E+03, .989308E+02,
     +  .773867E+02, .605589E+02, .472236E+02, .369786E+02,
     +  .289591E+02, .227022E+02, .178059E+02, .139859E+02,
     +  .110038E+02, .867041E+01, .684308E+01, .541570E+01,
     +  .429532E+01, .341761E+01, .272572E+01, .218163E+01,
     +  .175017E+01, .140813E+01, .113499E+01, .916817E+00,
     +  .741201E+00, .600331E+00, .485410E+00, .392955E+00,
     +  .317181E+00, .255847E+00, .205805E+00, .165130E+00,
     +  .131998E+00, .105139E+00, .833452E-01, .657671E-01,
     +  .516054E-01, .402816E-01, .312392E-01, .240814E-01,
     +  .184311E-01, .140094E-01, .105804E-01, .791524E-02 /
        DATA (UPDI(I),I=157,208) /
     +  .586714E-02, .431025E-02, .313349E-02, .225435E-02,
     +  .160110E-02, .112217E-02, .772779E-03, .522053E-03,
     +  .342124E-03, .217774E-03, .130849E-03, .720268E-04,
     +  .332580E-04, .866577E-05, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .598496E+05, .471925E+05,
     +  .368062E+05, .286908E+05, .223651E+05, .174244E+05,
     +  .135752E+05, .105702E+05, .823023E+04, .640438E+04,
     +  .498345E+04, .387529E+04, .301343E+04, .234167E+04,
     +  .181958E+04, .141289E+04, .109704E+04, .851181E+03,
     +  .660385E+03, .511981E+03, .396922E+03, .307501E+03,
     +  .238231E+03, .184440E+03, .142807E+03, .110518E+03 /
        DATA (UPDI(I),I=209,260) /
     +  .855549E+02, .659703E+02, .510804E+02, .395445E+02,
     +  .306416E+02, .237485E+02, .184305E+02, .143244E+02,
     +  .111487E+02, .868969E+01, .679183E+01, .531929E+01,
     +  .417989E+01, .329235E+01, .260324E+01, .206339E+01,
     +  .164090E+01, .130766E+01, .104493E+01, .836009E+00,
     +  .670569E+00, .537168E+00, .431191E+00, .345279E+00,
     +  .276528E+00, .220995E+00, .176320E+00, .140251E+00,
     +  .111271E+00, .879251E-01, .692311E-01, .542564E-01,
     +  .423512E-01, .328802E-01, .254124E-01, .195277E-01,
     +  .149298E-01, .113624E-01, .858676E-02, .644542E-02,
     +  .481094E-02, .356672E-02, .262975E-02, .192515E-02,
     +  .140176E-02, .101313E-02, .727866E-03, .517659E-03,
     +  .367346E-03, .257443E-03, .178899E-03, .122693E-03 /
        DATA (UPDI(I),I=261,312) /
     +  .831582E-04, .553416E-04, .362218E-04, .231507E-04,
     +  .143678E-04, .860298E-05, .493717E-05, .265196E-05,
     +  .130660E-05, .556785E-06, .166864E-06, .972084E-08,
     +  .000000E+00, .993661E+05, .778334E+05, .602486E+05,
     +  .466119E+05, .360587E+05, .278789E+05, .215525E+05,
     +  .166518E+05, .128638E+05, .993132E+04, .766628E+04,
     +  .591389E+04, .456138E+04, .351572E+04, .270932E+04,
     +  .208635E+04, .160634E+04, .123581E+04, .950575E+03,
     +  .730598E+03, .561447E+03, .431120E+03, .331005E+03,
     +  .253946E+03, .194812E+03, .149359E+03, .114533E+03,
     +  .874566E+02, .670560E+02, .513985E+02, .394257E+02,
     +  .302446E+02, .232277E+02, .178634E+02, .137547E+02,
     +  .106054E+02, .819898E+01, .635116E+01, .493605E+01 /
        DATA (UPDI(I),I=313,364) /
     +  .384546E+01, .300766E+01, .235846E+01, .185586E+01,
     +  .146382E+01, .115812E+01, .917694E+00, .729376E+00,
     +  .579155E+00, .461085E+00, .366347E+00, .291283E+00,
     +  .231228E+00, .183356E+00, .145038E+00, .114500E+00,
     +  .900819E-01, .706646E-01, .552094E-01, .429927E-01,
     +  .333227E-01, .257321E-01, .197723E-01, .151295E-01,
     +  .115346E-01, .874128E-02, .658706E-02, .494220E-02,
     +  .368830E-02, .274180E-02, .202752E-02, .149442E-02,
     +  .109624E-02, .801564E-03, .582621E-03, .424065E-03,
     +  .306549E-03, .221103E-03, .158577E-03, .113388E-03,
     +  .803862E-04, .566795E-04, .394199E-04, .269447E-04,
     +  .179274E-04, .114925E-04, .691497E-05, .378628E-05,
     +  .176423E-05, .577866E-06, .503562E-07, .000000E+00 /
        DATA (UPDI(I),I=365,416) /
     +  .155728E+06, .121254E+06, .932218E+05, .716312E+05,
     +  .550314E+05, .422536E+05, .324364E+05, .248847E+05,
     +  .190871E+05, .146307E+05, .112121E+05, .858639E+04,
     +  .657391E+04, .502947E+04, .384682E+04, .294001E+04,
     +  .224632E+04, .171492E+04, .130884E+04, .998089E+03,
     +  .760912E+03, .579613E+03, .441395E+03, .335864E+03,
     +  .255506E+03, .194243E+03, .147679E+03, .111778E+03,
     +  .849477E+02, .645318E+02, .490490E+02, .372806E+02,
     +  .283620E+02, .216053E+02, .164750E+02, .125790E+02,
     +  .962850E+01, .738440E+01, .568157E+01, .438206E+01,
     +  .339318E+01, .263456E+01, .205289E+01, .160380E+01,
     +  .125703E+01, .987077E+00, .777690E+00, .612332E+00,
     +  .483604E+00, .381307E+00, .300989E+00, .237314E+00 /
        DATA (UPDI(I),I=417,468) /
     +  .186983E+00, .147034E+00, .115439E+00, .903637E-01,
     +  .705598E-01, .549014E-01, .425962E-01, .329116E-01,
     +  .253466E-01, .194347E-01, .148467E-01, .113065E-01,
     +  .856337E-02, .645326E-02, .484493E-02, .362065E-02,
     +  .269700E-02, .200021E-02, .147978E-02, .109069E-02,
     +  .802120E-03, .587359E-03, .431063E-03, .314791E-03,
     +  .229689E-03, .166972E-03, .121148E-03, .872935E-04,
     +  .625596E-04, .442228E-04, .306765E-04, .206679E-04,
     +  .133564E-04, .806287E-05, .439612E-05, .201600E-05,
     +  .641401E-06, .583109E-07, .000000E+00, .233752E+06,
     +  .181019E+06, .138305E+06, .105610E+06, .806233E+05,
     +  .615107E+05, .469157E+05, .357608E+05, .272498E+05,
     +  .207504E+05, .157960E+05, .120159E+05, .913718E+04 /
        DATA (UPDI(I),I=469,520) /
     +  .694291E+04, .527361E+04, .400247E+04, .303653E+04,
     +  .230177E+04, .174408E+04, .132037E+04, .999199E+03,
     +  .755488E+03, .570995E+03, .431180E+03, .325481E+03,
     +  .245509E+03, .185175E+03, .139017E+03, .104783E+03,
     +  .789412E+02, .594938E+02, .448328E+02, .338093E+02,
     +  .255282E+02, .192910E+02, .145954E+02, .110688E+02,
     +  .841033E+01, .641025E+01, .489783E+01, .375701E+01,
     +  .288998E+01, .223114E+01, .172729E+01, .134178E+01,
     +  .104451E+01, .816027E+00, .637287E+00, .499373E+00,
     +  .390780E+00, .306243E+00, .239809E+00, .187718E+00,
     +  .146707E+00, .114510E+00, .891481E-01, .692531E-01,
     +  .536289E-01, .414238E-01, .318761E-01, .244571E-01,
     +  .186898E-01, .142340E-01, .108106E-01, .816797E-02 /
        DATA (UPDI(I),I=521,572) /
     +  .614301E-02, .460434E-02, .343670E-02, .255776E-02,
     +  .189634E-02, .140304E-02, .103484E-02, .761986E-03,
     +  .559191E-03, .411421E-03, .301514E-03, .220896E-03,
     +  .161377E-03, .117677E-03, .852629E-04, .613832E-04,
     +  .435619E-04, .302748E-04, .203927E-04, .131259E-04,
     +  .786157E-05, .422716E-05, .189294E-05, .580797E-06,
     +  .540716E-07, .000000E+00, .339413E+06, .261522E+06,
     +  .198655E+06, .150812E+06, .114453E+06, .868037E+05,
     +  .658102E+05, .498603E+05, .377615E+05, .285782E+05,
     +  .216192E+05, .163426E+05, .123483E+05, .932292E+04,
     +  .703546E+04, .530480E+04, .399790E+04, .301030E+04,
     +  .226550E+04, .170342E+04, .128014E+04, .961144E+03,
     +  .721265E+03, .540751E+03, .405213E+03, .303393E+03 /
        DATA (UPDI(I),I=573,624) /
     +  .227118E+03, .169191E+03, .126538E+03, .945848E+02,
     +  .707131E+02, .528563E+02, .395301E+02, .295990E+02,
     +  .221763E+02, .166340E+02, .125043E+02, .941750E+01,
     +  .711394E+01, .538713E+01, .409541E+01, .312237E+01,
     +  .238924E+01, .183364E+01, .141216E+01, .109010E+01,
     +  .844686E+00, .654424E+00, .508851E+00, .395234E+00,
     +  .307509E+00, .239149E+00, .185963E+00, .144420E+00,
     +  .112042E+00, .867257E-01, .670007E-01, .516157E-01,
     +  .396706E-01, .303851E-01, .232096E-01, .176634E-01,
     +  .133993E-01, .101392E-01, .763388E-02, .572312E-02,
     +  .427698E-02, .318405E-02, .236413E-02, .174937E-02,
     +  .129216E-02, .951943E-03, .700434E-03, .514021E-03,
     +  .378280E-03, .277505E-03, .203574E-03, .149001E-03 /
        DATA (UPDI(I),I=625,676) /
     +  .108836E-03, .790010E-04, .569131E-04, .403833E-04,
     +  .280031E-04, .187821E-04, .119967E-04, .710487E-05,
     +  .375656E-05, .163921E-05, .484954E-06, .459830E-07,
     +  .000000E+00, .479886E+06, .368011E+06, .278016E+06,
     +  .209899E+06, .158407E+06, .119466E+06, .900588E+05,
     +  .678420E+05, .510822E+05, .384340E+05, .289032E+05,
     +  .217187E+05, .163114E+05, .122402E+05, .917996E+04,
     +  .687877E+04, .515139E+04, .385419E+04, .288187E+04,
     +  .215276E+04, .160712E+04, .119859E+04, .893340E+03,
     +  .665167E+03, .494966E+03, .367973E+03, .273482E+03,
     +  .202226E+03, .150122E+03, .111372E+03, .826249E+02,
     +  .612813E+02, .454675E+02, .337728E+02, .250964E+02,
     +  .186690E+02, .139162E+02, .103923E+02, .778315E+01 /
        DATA (UPDI(I),I=677,728) /
     +  .584350E+01, .440413E+01, .332905E+01, .252564E+01,
     +  .192203E+01, .146791E+01, .112389E+01, .863913E+00,
     +  .664097E+00, .512448E+00, .395092E+00, .305197E+00,
     +  .235718E+00, .182070E+00, .140491E+00, .108315E+00,
     +  .833416E-01, .640156E-01, .490451E-01, .374941E-01,
     +  .285726E-01, .217182E-01, .164516E-01, .124237E-01,
     +  .936053E-02, .701833E-02, .524123E-02, .390243E-02,
     +  .289539E-02, .214302E-02, .158139E-02, .116519E-02,
     +  .856686E-03, .629372E-03, .461465E-03, .339400E-03,
     +  .248996E-03, .182716E-03, .133825E-03, .977909E-04,
     +  .710026E-04, .511013E-04, .361878E-04, .249916E-04,
     +  .166590E-04, .105406E-04, .616242E-05, .319909E-05,
     +  .135899E-05, .388064E-06, .373831E-07, .000000E+00 /
        DATA (UPDI(I),I=729,780) /
     +  .663579E+06, .506591E+06, .380702E+06, .285913E+06,
     +  .214623E+06, .160994E+06, .120704E+06, .904294E+05,
     +  .677117E+05, .506610E+05, .378822E+05, .283031E+05,
     +  .211334E+05, .157660E+05, .117542E+05, .875506E+04,
     +  .651674E+04, .484590E+04, .360087E+04, .267299E+04,
     +  .198277E+04, .146922E+04, .108788E+04, .804658E+03,
     +  .594732E+03, .439122E+03, .324096E+03, .237942E+03,
     +  .175371E+03, .129160E+03, .951122E+02, .700144E+02,
     +  .515493E+02, .379948E+02, .280106E+02, .206708E+02,
     +  .152832E+02, .113201E+02, .840786E+01, .626028E+01,
     +  .467893E+01, .350745E+01, .263893E+01, .199182E+01,
     +  .150884E+01, .114602E+01, .874020E+00, .666704E+00,
     +  .510596E+00, .390783E+00, .299715E+00, .229889E+00 /
        DATA (UPDI(I),I=781,832) /
     +  .176373E+00, .135212E+00, .103584E+00, .792147E-01,
     +  .604841E-01, .460747E-01, .350267E-01, .265495E-01,
     +  .200751E-01, .151310E-01, .113706E-01, .852690E-02,
     +  .636411E-02, .473226E-02, .350905E-02, .259366E-02,
     +  .191291E-02, .140718E-02, .103394E-02, .758459E-03,
     +  .556224E-03, .407378E-03, .299388E-03, .219602E-03,
     +  .161149E-03, .118057E-03, .862575E-04, .625965E-04,
     +  .449682E-04, .317474E-04, .218108E-04, .144314E-04,
     +  .903493E-05, .520825E-05, .265176E-05, .109599E-05,
     +  .302438E-06, .295579E-07, .000000E+00, .900098E+06,
     +  .684185E+06, .511566E+06, .382242E+06, .285457E+06,
     +  .213018E+06, .158871E+06, .118393E+06, .881753E+05,
     +  .656150E+05, .487954E+05, .362553E+05, .269194E+05 /
        DATA (UPDI(I),I=833,884) /
     +  .199690E+05, .148023E+05, .109617E+05, .811126E+04,
     +  .599583E+04, .442854E+04, .326738E+04, .240869E+04,
     +  .177368E+04, .130497E+04, .959032E+03, .704199E+03,
     +  .516497E+03, .378632E+03, .276055E+03, .202046E+03,
     +  .147759E+03, .108026E+03, .789420E+02, .576907E+02,
     +  .422026E+02, .308742E+02, .226076E+02, .165836E+02,
     +  .121859E+02, .897824E+01, .663120E+01, .491600E+01,
     +  .365542E+01, .272804E+01, .204262E+01, .153503E+01,
     +  .115679E+01, .875439E+00, .662726E+00, .503782E+00,
     +  .382767E+00, .291482E+00, .222035E+00, .169197E+00,
     +  .128861E+00, .980854E-01, .745441E-01, .565726E-01,
     +  .428421E-01, .323819E-01, .244086E-01, .183561E-01,
     +  .137631E-01, .102896E-01, .767830E-02, .570329E-02 /
        DATA (UPDI(I),I=885,936) /
     +  .422174E-02, .311706E-02, .229482E-02, .168632E-02,
     +  .123654E-02, .906015E-03, .663144E-03, .485518E-03,
     +  .355236E-03, .260907E-03, .191355E-03, .140425E-03,
     +  .102884E-03, .751397E-04, .544717E-04, .390339E-04,
     +  .274507E-04, .187437E-04, .122982E-04, .761086E-05,
     +  .432170E-05, .215608E-05, .866637E-06, .231375E-06,
     +  .229206E-07, .000000E+00, .120016E+07, .908461E+06,
     +  .675927E+06, .502560E+06, .373437E+06, .277269E+06,
     +  .205735E+06, .152529E+06, .113007E+06, .836517E+05,
     +  .618774E+05, .457284E+05, .337682E+05, .249118E+05,
     +  .183632E+05, .135221E+05, .994870E+04, .731162E+04,
     +  .536873E+04, .393760E+04, .288531E+04, .211171E+04,
     +  .154406E+04, .112764E+04, .822729E+03, .599529E+03 /
        DATA (UPDI(I),I=937,988) /
     +  .436613E+03, .316178E+03, .229845E+03, .166935E+03,
     +  .121192E+03, .879356E+02, .637983E+02, .463299E+02,
     +  .336406E+02, .244477E+02, .177958E+02, .129757E+02,
     +  .948543E+01, .695087E+01, .511228E+01, .377142E+01,
     +  .279240E+01, .207446E+01, .154681E+01, .115671E+01,
     +  .868749E+00, .652745E+00, .492551E+00, .371538E+00,
     +  .280933E+00, .212529E+00, .160860E+00, .121706E+00,
     +  .920403E-01, .695110E-01, .524286E-01, .394668E-01,
     +  .296558E-01, .222270E-01, .166225E-01, .123965E-01,
     +  .921920E-02, .684481E-02, .505931E-02, .372786E-02,
     +  .274049E-02, .200962E-02, .147145E-02, .107566E-02,
     +  .786083E-03, .574225E-03, .419843E-03, .306963E-03,
     +  .225378E-03, .165312E-03, .121328E-03, .888914E-04 /
        DATA (UPDI(I),I=989,1040) /
     +  .648764E-04, .469592E-04, .335459E-04, .234811E-04,
     +  .159216E-04, .103496E-04, .632576E-05, .353508E-05,
     +  .172673E-05, .674797E-06, .174498E-06, .175100E-07,
     +  .000000E+00, .157544E+07, .118769E+07, .879461E+06,
     +  .650746E+06, .481195E+06, .355523E+06, .262490E+06,
     +  .193631E+06, .142730E+06, .105113E+06, .773483E+05,
     +  .568621E+05, .417668E+05, .306473E+05, .224681E+05,
     +  .164539E+05, .120382E+05, .879742E+04, .642276E+04,
     +  .468341E+04, .341164E+04, .248209E+04, .180392E+04,
     +  .130935E+04, .949369E+03, .687440E+03, .497422E+03,
     +  .357839E+03, .258409E+03, .186425E+03, .134416E+03,
     +  .968567E+02, .697750E+02, .503092E+02, .362642E+02,
     +  .261605E+02, .189002E+02, .136773E+02, .992201E+01 /
        DATA (UPDI(I),I=1041,1092) /
     +  .721514E+01, .526572E+01, .385469E+01, .283202E+01,
     +  .208777E+01, .154485E+01, .114651E+01, .854671E+00,
     +  .637429E+00, .477504E+00, .357616E+00, .268510E+00,
     +  .201740E+00, .151665E+00, .113994E+00, .856496E-01,
     +  .642765E-01, .481803E-01, .360502E-01, .269281E-01,
     +  .200666E-01, .149225E-01, .110683E-01, .818777E-02,
     +  .604816E-02, .444860E-02, .326292E-02, .238850E-02,
     +  .174481E-02, .127321E-02, .928115E-03, .676704E-03,
     +  .493528E-03, .360488E-03, .263470E-03, .193443E-03,
     +  .141928E-03, .104183E-03, .763169E-04, .556426E-04,
     +  .401916E-04, .286032E-04, .199120E-04, .133965E-04,
     +  .861979E-05, .519904E-05, .285705E-05, .136538E-05,
     +  .518686E-06, .130058E-06, .132128E-07, .000000E+00 /
        DATA (UPDI(I),I=1093,1144) /
     +  .203830E+07, .153057E+07, .112806E+07, .830770E+06,
     +  .611391E+06, .449550E+06, .330299E+06, .242458E+06,
     +  .177835E+06, .130309E+06, .954027E+05, .697753E+05,
     +  .509857E+05, .372156E+05, .271383E+05, .197671E+05,
     +  .143834E+05, .104534E+05, .758902E+04, .550254E+04,
     +  .398531E+04, .288259E+04, .208262E+04, .150260E+04,
     +  .108286E+04, .779256E+03, .560322E+03, .400489E+03,
     +  .287340E+03, .205940E+03, .147496E+03, .105564E+03,
     +  .755238E+02, .540754E+02, .387022E+02, .277187E+02,
     +  .198798E+02, .142804E+02, .102824E+02, .742128E+01,
     +  .537535E+01, .390527E+01, .284750E+01, .208342E+01,
     +  .153006E+01, .112711E+01, .834040E+00, .617513E+00,
     +  .459268E+00, .341527E+00, .254647E+00, .190023E+00 /
        DATA (UPDI(I),I=1145,1196) /
     +  .141897E+00, .105952E+00, .790921E-01, .589805E-01,
     +  .439363E-01, .326758E-01, .242625E-01, .179761E-01,
     +  .132925E-01, .980580E-02, .721542E-02, .530306E-02,
     +  .388178E-02, .283451E-02, .206643E-02, .150409E-02,
     +  .109414E-02, .795595E-03, .578978E-03, .421749E-03,
     +  .307884E-03, .225020E-03, .165256E-03, .121294E-03,
     +  .890456E-04, .652001E-04, .474683E-04, .341942E-04,
     +  .242260E-04, .167590E-04, .111783E-04, .711363E-05,
     +  .423078E-05, .228454E-05, .106755E-05, .394202E-06,
     +  .959467E-07, .986439E-08, .000000E+00, .260149E+07,
     +  .194596E+07, .142765E+07, .104657E+07, .766617E+06,
     +  .561038E+06, .410253E+06, .299704E+06, .218754E+06,
     +  .159507E+06, .116199E+06, .845588E+05, .614740E+05 /
        DATA (UPDI(I),I=1197,1248) /
     +  .446407E+05, .323834E+05, .234634E+05, .169819E+05,
     +  .122752E+05, .886288E+04, .639057E+04, .460246E+04,
     +  .331003E+04, .237762E+04, .170539E+04, .122170E+04,
     +  .873845E+03, .624481E+03, .443533E+03, .316212E+03,
     +  .225183E+03, .160227E+03, .113918E+03, .809523E+02,
     +  .575683E+02, .409163E+02, .290989E+02, .207210E+02,
     +  .147777E+02, .105631E+02, .756811E+01, .544129E+01,
     +  .392401E+01, .283999E+01, .206261E+01, .150364E+01,
     +  .109955E+01, .807771E+00, .593769E+00, .438484E+00,
     +  .323791E+00, .239760E+00, .177706E+00, .131815E+00,
     +  .977805E-01, .725217E-01, .537403E-01, .397849E-01,
     +  .294098E-01, .217080E-01, .159910E-01, .117583E-01,
     +  .862733E-02, .631511E-02, .461846E-02, .336486E-02 /
        DATA (UPDI(I),I=1249,1300) /
     +  .244657E-02, .177674E-02, .128894E-02, .935034E-03,
     +  .678474E-03, .493016E-03, .358853E-03, .261919E-03,
     +  .191479E-03, .140685E-03, .103298E-03, .758283E-04,
     +  .554763E-04, .403081E-04, .289373E-04, .203943E-04,
     +  .140085E-04, .925602E-05, .582123E-05, .341145E-05,
     +  .180889E-05, .826128E-06, .296539E-06, .701353E-07,
     +  .729449E-08, .000000E+00, .326065E+05, .350864E+05,
     +  .277294E+05, .219154E+05, .173209E+05, .136899E+05,
     +  .108204E+05, .855262E+04, .676040E+04, .534397E+04,
     +  .422452E+04, .333976E+04, .264048E+04, .208777E+04,
     +  .165090E+04, .130558E+04, .103262E+04, .816842E+03,
     +  .646259E+03, .511398E+03, .404771E+03, .320461E+03,
     +  .253792E+03, .201067E+03, .159365E+03, .126377E+03 /
        DATA (UPDI(I),I=1301,1352) /
     +  .100278E+03, .793659E+02, .630806E+02, .501863E+02,
     +  .399738E+02, .318823E+02, .254683E+02, .203950E+02,
     +  .163576E+02, .131519E+02, .106037E+02, .857531E+01,
     +  .695791E+01, .566502E+01, .463052E+01, .379909E+01,
     +  .312910E+01, .258736E+01, .214766E+01, .178931E+01,
     +  .149677E+01, .125403E+01, .105338E+01, .883619E+00,
     +  .739550E+00, .615169E+00, .506727E+00, .411912E+00,
     +  .329546E+00, .259076E+00, .200057E+00, .151800E+00,
     +  .113272E+00, .831806E-01, .601368E-01, .427978E-01,
     +  .299609E-01, .206407E-01, .139094E-01, .916295E-02,
     +  .587715E-02, .364968E-02, .217616E-02, .122958E-02,
     +  .643185E-03, .296552E-03, .104316E-03, .758266E-05,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1353,1404) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .596056E+05, .474266E+05, .373724E+05,
     +  .294429E+05, .231975E+05, .182727E+05, .143943E+05,
     +  .113365E+05, .892885E+04, .703088E+04, .553674E+04,
     +  .435910E+04, .343219E+04, .270176E+04, .212697E+04,
     +  .167410E+04, .131779E+04, .103712E+04, .816337E+03,
     +  .642455E+03, .505713E+03, .398038E+03, .313375E+03,
     +  .246720E+03, .194316E+03, .153069E+03, .120645E+03,
     +  .948067E+02, .748192E+02, .590818E+02, .467080E+02,
     +  .369627E+02, .292963E+02, .232702E+02, .185129E+02,
     +  .147603E+02, .118019E+02, .946285E+01, .761345E+01 /
        DATA (UPDI(I),I=1405,1456) /
     +  .614530E+01, .498059E+01, .405106E+01, .330829E+01,
     +  .271180E+01, .223164E+01, .184277E+01, .152772E+01,
     +  .126784E+01, .105471E+01, .875652E+00, .725235E+00,
     +  .596854E+00, .486617E+00, .391794E+00, .310875E+00,
     +  .242757E+00, .186554E+00, .141150E+00, .105264E+00,
     +  .774288E-01, .562240E-01, .403095E-01, .285326E-01,
     +  .199665E-01, .137509E-01, .932852E-02, .622864E-02,
     +  .408619E-02, .263117E-02, .165840E-02, .102179E-02,
     +  .612106E-03, .355270E-03, .195940E-03, .101766E-03,
     +  .456274E-04, .133654E-04, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1457,1508) /
     +  .857804E+05, .678777E+05, .531555E+05, .416137E+05,
     +  .325798E+05, .254989E+05, .199580E+05, .156161E+05,
     +  .122194E+05, .955836E+04, .747718E+04, .584719E+04,
     +  .457278E+04, .357493E+04, .279501E+04, .218451E+04,
     +  .170750E+04, .133423E+04, .104267E+04, .814590E+03,
     +  .636512E+03, .497251E+03, .388551E+03, .303569E+03,
     +  .237254E+03, .185432E+03, .145009E+03, .113033E+03,
     +  .884871E+02, .693036E+02, .543402E+02, .426441E+02,
     +  .335167E+02, .263972E+02, .208227E+02, .164593E+02,
     +  .130479E+02, .103715E+02, .827295E+01, .661994E+01,
     +  .531946E+01, .428959E+01, .347330E+01, .282271E+01,
     +  .230311E+01, .188527E+01, .154928E+01, .127400E+01,
     +  .105000E+01, .863289E+00, .707963E+00, .576873E+00 /
        DATA (UPDI(I),I=1509,1560) /
     +  .465830E+00, .371708E+00, .292614E+00, .226988E+00,
     +  .173548E+00, .130851E+00, .974132E-01, .716565E-01,
     +  .521404E-01, .375438E-01, .267620E-01, .189207E-01,
     +  .132212E-01, .914757E-02, .627313E-02, .426487E-02,
     +  .288078E-02, .193483E-02, .129762E-02, .870404E-03,
     +  .587091E-03, .397815E-03, .274197E-03, .190186E-03,
     +  .133312E-03, .936107E-04, .657274E-04, .455682E-04,
     +  .311422E-04, .207258E-04, .133306E-04, .821159E-05,
     +  .481250E-05, .262020E-05, .130078E-05, .556139E-06,
     +  .166836E-06, .972070E-08, .000000E+00, .125086E+06,
     +  .983503E+05, .764650E+05, .594299E+05, .461904E+05,
     +  .358879E+05, .278836E+05, .216568E+05, .168206E+05,
     +  .130597E+05, .101397E+05, .786975E+04, .610801E+04 /
        DATA (UPDI(I),I=1561,1612) /
     +  .473890E+04, .367675E+04, .285161E+04, .221174E+04,
     +  .171482E+04, .132964E+04, .103063E+04, .798968E+03,
     +  .619204E+03, .479978E+03, .371982E+03, .288367E+03,
     +  .223542E+03, .173384E+03, .134020E+03, .104046E+03,
     +  .808076E+02, .628278E+02, .488873E+02, .380967E+02,
     +  .297482E+02, .232650E+02, .182316E+02, .143287E+02,
     +  .112914E+02, .892947E+01, .708403E+01, .564401E+01,
     +  .451272E+01, .362318E+01, .291971E+01, .236223E+01,
     +  .191722E+01, .156204E+01, .127313E+01, .103987E+01,
     +  .847031E+00, .688127E+00, .555480E+00, .444517E+00,
     +  .351725E+00, .274814E+00, .211824E+00, .161129E+00,
     +  .121030E+00, .898879E-01, .660554E-01, .480896E-01,
     +  .347009E-01, .248330E-01, .176625E-01, .124475E-01 /
        DATA (UPDI(I),I=1613,1664) /
     +  .871102E-02, .606341E-02, .420105E-02, .290526E-02,
     +  .200775E-02, .139255E-02, .970679E-03, .682759E-03,
     +  .484002E-03, .348831E-03, .253078E-03, .185373E-03,
     +  .136089E-03, .100088E-03, .730277E-04, .529079E-04,
     +  .376449E-04, .261972E-04, .176498E-04, .114057E-04,
     +  .689325E-05, .378238E-05, .176381E-05, .577847E-06,
     +  .503561E-07, .000000E+00, .181246E+06, .141610E+06,
     +  .109311E+06, .843490E+05, .650840E+05, .502001E+05,
     +  .387180E+05, .298507E+05, .230130E+05, .177346E+05,
     +  .136662E+05, .105269E+05, .810839E+04, .624300E+04,
     +  .480659E+04, .369918E+04, .284687E+04, .219006E+04,
     +  .168481E+04, .129564E+04, .996436E+03, .766086E+03,
     +  .589064E+03, .452839E+03, .348194E+03, .267713E+03 /
        DATA (UPDI(I),I=1665,1716) /
     +  .205942E+03, .157853E+03, .121529E+03, .935959E+02,
     +  .721583E+02, .556731E+02, .430158E+02, .333037E+02,
     +  .258228E+02, .200629E+02, .156329E+02, .122138E+02,
     +  .957650E+01, .753280E+01, .595092E+01, .471820E+01,
     +  .375651E+01, .300198E+01, .240858E+01, .193847E+01,
     +  .156603E+01, .126534E+01, .102445E+01, .826968E+00,
     +  .665757E+00, .532610E+00, .422536E+00, .331641E+00,
     +  .257247E+00, .197045E+00, .149113E+00, .111554E+00,
     +  .826098E-01, .605994E-01, .440904E-01, .318341E-01,
     +  .228241E-01, .162869E-01, .115342E-01, .812568E-02,
     +  .570486E-02, .399515E-02, .279838E-02, .196264E-02,
     +  .138355E-02, .981163E-03, .702086E-03, .506180E-03,
     +  .370192E-03, .272163E-03, .201588E-03, .149511E-03 /
        DATA (UPDI(I),I=1717,1768) /
     +  .110952E-03, .817239E-04, .597426E-04, .429150E-04,
     +  .301337E-04, .204695E-04, .132954E-04, .804787E-05,
     +  .439348E-05, .201572E-05, .641389E-06, .583108E-07,
     +  .000000E+00, .259076E+06, .201220E+06, .154271E+06,
     +  .118231E+06, .905991E+05, .693965E+05, .531493E+05,
     +  .406888E+05, .311457E+05, .238306E+05, .182313E+05,
     +  .139415E+05, .106598E+05, .814706E+04, .622592E+04,
     +  .475571E+04, .363235E+04, .277313E+04, .211702E+04,
     +  .161549E+04, .123277E+04, .940378E+03, .717379E+03,
     +  .547107E+03, .417311E+03, .318271E+03, .242852E+03,
     +  .184604E+03, .140955E+03, .107660E+03, .823094E+02,
     +  .629740E+02, .482466E+02, .370390E+02, .284754E+02,
     +  .219362E+02, .169472E+02, .131285E+02, .102065E+02 /
        DATA (UPDI(I),I=1769,1820) /
     +  .796081E+01, .623639E+01, .490343E+01, .387165E+01,
     +  .306850E+01, .244165E+01, .194880E+01, .156124E+01,
     +  .125071E+01, .100388E+01, .803240E+00, .640955E+00,
     +  .508309E+00, .399876E+00, .311395E+00, .239828E+00,
     +  .182561E+00, .137426E+00, .102370E+00, .755557E-01,
     +  .552914E-01, .401685E-01, .289866E-01, .207907E-01,
     +  .148565E-01, .105472E-01, .745758E-02, .526123E-02,
     +  .370686E-02, .261494E-02, .184876E-02, .131432E-02,
     +  .940059E-03, .678068E-03, .492495E-03, .362216E-03,
     +  .267541E-03, .198790E-03, .147812E-03, .109854E-03,
     +  .810422E-04, .592759E-04, .425966E-04, .298799E-04,
     +  .202504E-04, .130828E-04, .785117E-05, .422536E-05,
     +  .189275E-05, .580789E-06, .540715E-07, .000000E+00 /
        DATA (UPDI(I),I=1821,1872) /
     +  .364545E+06, .281570E+06, .214501E+06, .163337E+06,
     +  .124353E+06, .946300E+05, .719968E+05, .547511E+05,
     +  .416279E+05, .316351E+05, .240361E+05, .182535E+05,
     +  .138594E+05, .105178E+05, .798043E+04, .605219E+04,
     +  .458905E+04, .347793E+04, .263545E+04, .199613E+04,
     +  .151176E+04, .114446E+04, .866370E+03, .655633E+03,
     +  .496185E+03, .375447E+03, .284205E+03, .214287E+03,
     +  .162297E+03, .122954E+03, .932309E+02, .707424E+02,
     +  .537475E+02, .409192E+02, .311946E+02, .238295E+02,
     +  .182551E+02, .140230E+02, .108106E+02, .836170E+01,
     +  .649607E+01, .506553E+01, .396676E+01, .311819E+01,
     +  .246088E+01, .194801E+01, .154769E+01, .122941E+01,
     +  .978380E+00, .776061E+00, .613909E+00, .482714E+00 /
        DATA (UPDI(I),I=1873,1924) /
     +  .376622E+00, .291030E+00, .222569E+00, .168368E+00,
     +  .126060E+00, .934786E-01, .687368E-01, .501538E-01,
     +  .363565E-01, .261982E-01, .187772E-01, .134181E-01,
     +  .953377E-02, .675208E-02, .477513E-02, .337524E-02,
     +  .239010E-02, .169712E-02, .121187E-02, .870560E-03,
     +  .630367E-03, .459408E-03, .338611E-03, .250490E-03,
     +  .186218E-03, .138481E-03, .102842E-03, .758070E-04,
     +  .553386E-04, .396715E-04, .277160E-04, .186802E-04,
     +  .119663E-04, .709766E-05, .375533E-05, .163908E-05,
     +  .484948E-06, .459829E-07, .000000E+00, .504829E+06,
     +  .387909E+06, .293743E+06, .222330E+06, .168233E+06,
     +  .127234E+06, .961990E+05, .726961E+05, .549196E+05,
     +  .414678E+05, .313018E+05, .236152E+05, .178110E+05 /
        DATA (UPDI(I),I=1925,1976) /
     +  .134260E+05, .101177E+05, .762035E+04, .573790E+04,
     +  .431811E+04, .324883E+04, .244307E+04, .183680E+04,
     +  .138033E+04, .103716E+04, .778996E+03, .585070E+03,
     +  .439309E+03, .329972E+03, .246823E+03, .185461E+03,
     +  .139384E+03, .104839E+03, .789066E+02, .594601E+02,
     +  .448980E+02, .339450E+02, .257162E+02, .195368E+02,
     +  .148833E+02, .113787E+02, .872860E+01, .672540E+01,
     +  .520154E+01, .404008E+01, .315008E+01, .246584E+01,
     +  .193600E+01, .152553E+01, .120167E+01, .948245E+00,
     +  .745729E+00, .584884E+00, .456038E+00, .352931E+00,
     +  .270651E+00, .205538E+00, .154513E+00, .115050E+00,
     +  .849093E-01, .621828E-01, .452187E-01, .326889E-01,
     +  .235052E-01, .168208E-01, .120083E-01, .852878E-02 /
        DATA (UPDI(I),I=1977,2028) /
     +  .604186E-02, .427645E-02, .302702E-02, .214743E-02,
     +  .152814E-02, .109364E-02, .787345E-03, .571181E-03,
     +  .416938E-03, .307539E-03, .227588E-03, .169134E-03,
     +  .125692E-03, .932127E-04, .685928E-04, .499285E-04,
     +  .356645E-04, .247835E-04, .165862E-04, .105193E-04,
     +  .615744E-05, .319826E-05, .135890E-05, .388060E-06,
     +  .373830E-07, .000000E+00, .688335E+06, .526340E+06,
     +  .396312E+06, .298251E+06, .224376E+06, .168703E+06,
     +  .126798E+06, .952470E+05, .715202E+05, .536720E+05,
     +  .402627E+05, .301852E+05, .226215E+05, .169427E+05,
     +  .126846E+05, .949085E+04, .709861E+04, .530609E+04,
     +  .396484E+04, .296088E+04, .221049E+04, .164937E+04,
     +  .123040E+04, .917421E+03, .683957E+03, .509728E+03 /
        DATA (UPDI(I),I=2029,2080) /
     +  .379976E+03, .282029E+03, .210279E+03, .156807E+03,
     +  .117014E+03, .873720E+02, .653112E+02, .489200E+02,
     +  .366853E+02, .275661E+02, .207709E+02, .156943E+02,
     +  .119006E+02, .905468E+01, .691997E+01, .530879E+01,
     +  .409011E+01, .316345E+01, .245633E+01, .191291E+01,
     +  .149504E+01, .116789E+01, .913888E+00, .712633E+00,
     +  .554217E+00, .428553E+00, .329011E+00, .250409E+00,
     +  .188842E+00, .141069E+00, .104450E+00, .767057E-01,
     +  .559317E-01, .405209E-01, .291989E-01, .209395E-01,
     +  .149515E-01, .106554E-01, .755848E-02, .535069E-02,
     +  .378635E-02, .268077E-02, .190292E-02, .135542E-02,
     +  .971021E-03, .699823E-03, .508170E-03, .371249E-03,
     +  .273912E-03, .202708E-03, .150564E-03, .111795E-03 /
        DATA (UPDI(I),I=2081,2132) /
     +  .827746E-04, .607856E-04, .440979E-04, .313642E-04,
     +  .216605E-04, .143797E-04, .901998E-05, .520481E-05,
     +  .265120E-05, .109593E-05, .302436E-06, .295579E-07,
     +  .000000E+00, .924669E+06, .703786E+06, .527059E+06,
     +  .394487E+06, .295137E+06, .220670E+06, .164919E+06,
     +  .123175E+06, .919550E+05, .686032E+05, .511578E+05,
     +  .381230E+05, .283961E+05, .211366E+05, .157255E+05,
     +  .116916E+05, .868848E+04, .645229E+04, .478950E+04,
     +  .355284E+04, .263444E+04, .195222E+04, .144618E+04,
     +  .107071E+04, .792527E+03, .586357E+03, .433889E+03,
     +  .319620E+03, .236512E+03, .175030E+03, .129607E+03,
     +  .960244E+02, .712151E+02, .529222E+02, .393703E+02,
     +  .293473E+02, .219352E+02, .164410E+02, .123664E+02 /
        DATA (UPDI(I),I=2133,2184) /
     +  .933361E+01, .707596E+01, .538513E+01, .411581E+01,
     +  .315798E+01, .243247E+01, .187910E+01, .145673E+01,
     +  .112860E+01, .875826E+00, .677235E+00, .522300E+00,
     +  .400573E+00, .305100E+00, .230477E+00, .172605E+00,
     +  .128123E+00, .943231E-01, .689151E-01, .500218E-01,
     +  .360931E-01, .259153E-01, .185270E-01, .131931E-01,
     +  .938076E-02, .664195E-02, .469540E-02, .331951E-02,
     +  .234911E-02, .166729E-02, .118787E-02, .851338E-03,
     +  .613926E-03, .446066E-03, .326073E-03, .240633E-03,
     +  .178085E-03, .132213E-03, .980840E-04, .725021E-04,
     +  .531170E-04, .383912E-04, .271714E-04, .186356E-04,
     +  .122615E-04, .760044E-05, .431935E-05, .215570E-05,
     +  .866599E-06, .231374E-06, .229206E-07, .000000E+00 /
        DATA (UPDI(I),I=2185,2236) /
     +  .122455E+07, .927914E+06, .691303E+06, .514714E+06,
     +  .383043E+06, .284862E+06, .211738E+06, .157275E+06,
     +  .116758E+06, .866171E+05, .642217E+05, .475818E+05,
     +  .352335E+05, .260702E+05, .192791E+05, .142462E+05,
     +  .105213E+05, .776432E+04, .572666E+04, .422060E+04,
     +  .310906E+04, .228862E+04, .168393E+04, .123821E+04,
     +  .910142E+03, .668626E+03, .491232E+03, .359207E+03,
     +  .263857E+03, .193821E+03, .142443E+03, .104734E+03,
     +  .770784E+02, .568380E+02, .419533E+02, .310277E+02,
     +  .230083E+02, .171093E+02, .127673E+02, .956008E+01,
     +  .719040E+01, .542914E+01, .411672E+01, .313379E+01,
     +  .239472E+01, .183519E+01, .141127E+01, .108446E+01,
     +  .834661E+00, .640054E+00, .489557E+00, .372426E+00 /
        DATA (UPDI(I),I=2237,2288) /
     +  .281444E+00, .211032E+00, .156949E+00, .115762E+00,
     +  .847294E-01, .615813E-01, .444863E-01, .319617E-01,
     +  .228604E-01, .162868E-01, .115622E-01, .819915E-02,
     +  .579209E-02, .408719E-02, .288555E-02, .204016E-02,
     +  .144727E-02, .103103E-02, .739068E-03, .533208E-03,
     +  .387643E-03, .283546E-03, .209326E-03, .154940E-03,
     +  .114987E-03, .852298E-04, .628885E-04, .459508E-04,
     +  .330735E-04, .232785E-04, .158444E-04, .103237E-04,
     +  .631853E-05, .353347E-05, .172648E-05, .674772E-06,
     +  .174497E-06, .175100E-07, .000000E+00, .159964E+07,
     +  .120700E+07, .894720E+06, .662807E+06, .490729E+06,
     +  .363059E+06, .268447E+06, .198340E+06, .146453E+06,
     +  .108055E+06, .796746E+05, .587011E+05, .432206E+05 /
        DATA (UPDI(I),I=2289,2340) /
     +  .317966E+05, .233767E+05, .171722E+05, .126061E+05,
     +  .924631E+04, .677761E+04, .496392E+04, .363336E+04,
     +  .265733E+04, .194241E+04, .141879E+04, .103584E+04,
     +  .755754E+03, .551384E+03, .400315E+03, .291954E+03,
     +  .212912E+03, .155327E+03, .113363E+03, .828035E+02,
     +  .605999E+02, .443886E+02, .325772E+02, .239706E+02,
     +  .176870E+02, .130959E+02, .973007E+01, .726139E+01,
     +  .544019E+01, .409301E+01, .309150E+01, .234388E+01,
     +  .178205E+01, .135951E+01, .103623E+01, .791054E+00,
     +  .601636E+00, .456422E+00, .344444E+00, .258284E+00,
     +  .192243E+00, .141990E+00, .104061E+00, .757202E-01,
     +  .547394E-01, .393501E-01, .281455E-01, .200490E-01,
     +  .142313E-01, .100693E-01, .711947E-02, .501658E-02 /
        DATA (UPDI(I),I=2341,2392) /
     +  .353262E-02, .249001E-02, .175856E-02, .124670E-02,
     +  .888015E-03, .636668E-03, .459580E-03, .334358E-03,
     +  .244767E-03, .180797E-03, .133859E-03, .993105E-04,
     +  .735372E-04, .541517E-04, .394447E-04, .282578E-04,
     +  .197658E-04, .133415E-04, .860168E-05, .519405E-05,
     +  .285596E-05, .136521E-05, .518670E-06, .130057E-06,
     +  .132128E-07, .000000E+00, .206231E+07, .154973E+07,
     +  .114320E+07, .842740E+06, .620852E+06, .457028E+06,
     +  .336210E+06, .247131E+06, .181528E+06, .133229E+06,
     +  .977108E+05, .715999E+05, .524280E+05, .383557E+05,
     +  .280396E+05, .204795E+05, .149465E+05, .108984E+05,
     +  .794077E+04, .578052E+04, .420496E+04, .305614E+04,
     +  .221972E+04, .161089E+04, .116838E+04, .846766E+03 /
        DATA (UPDI(I),I=2393,2444) /
     +  .613609E+03, .442397E+03, .320403E+03, .232016E+03,
     +  .168056E+03, .121770E+03, .882935E+02, .641428E+02,
     +  .466335E+02, .339682E+02, .248053E+02, .181643E+02,
     +  .133470E+02, .984107E+01, .728816E+01, .541855E+01,
     +  .404547E+01, .303212E+01, .228106E+01, .172073E+01,
     +  .130239E+01, .984741E+00, .745695E+00, .562533E+00,
     +  .423318E+00, .316938E+00, .235839E+00, .174258E+00,
     +  .127824E+00, .930835E-01, .673337E-01, .484130E-01,
     +  .346284E-01, .246546E-01, .174881E-01, .123659E-01,
     +  .871876E-02, .614552E-02, .431868E-02, .303453E-02,
     +  .213533E-02, .150637E-02, .106726E-02, .760157E-03,
     +  .545189E-03, .393838E-03, .286799E-03, .210158E-03,
     +  .155342E-03, .115048E-03, .853200E-04, .631001E-04 /
        DATA (UPDI(I),I=2445,2496) /
     +  .463556E-04, .336436E-04, .239746E-04, .166541E-04,
     +  .111394E-04, .710101E-05, .422735E-05, .228380E-05,
     +  .106744E-05, .394191E-06, .959462E-07, .986439E-08,
     +  .000000E+00, .262533E+07, .196497E+07, .144268E+07,
     +  .105845E+07, .776006E+06, .568459E+06, .416118E+06,
     +  .304340E+06, .222419E+06, .162404E+06, .118489E+06,
     +  .863689E+05, .629048E+05, .457716E+05, .332772E+05,
     +  .241698E+05, .175402E+05, .127164E+05, .921147E+04,
     +  .666598E+04, .482001E+04, .348185E+04, .251329E+04,
     +  .181250E+04, .130623E+04, .940530E+03, .677074E+03,
     +  .484855E+03, .348779E+03, .250837E+03, .180425E+03,
     +  .129814E+03, .934560E+02, .674066E+02, .486499E+02,
     +  .351777E+02, .254989E+02, .185339E+02, .135171E+02 /
        DATA (UPDI(I),I=2497,2548) /
     +  .989212E+01, .727108E+01, .536527E+01, .397547E+01,
     +  .295707E+01, .220759E+01, .165244E+01, .124097E+01,
     +  .930853E+00, .699272E+00, .523278E+00, .390642E+00,
     +  .290190E+00, .214302E+00, .157202E+00, .114528E+00,
     +  .828716E-01, .595932E-01, .426137E-01, .303259E-01,
     +  .214905E-01, .151780E-01, .106901E-01, .751024E-02,
     +  .527696E-02, .369822E-02, .259289E-02, .182158E-02,
     +  .128371E-02, .909102E-03, .647598E-03, .464733E-03,
     +  .336048E-03, .244999E-03, .179729E-03, .132950E-03,
     +  .984871E-04, .729928E-04, .538972E-04, .394816E-04,
     +  .285334E-04, .202123E-04, .139335E-04, .922862E-05,
     +  .581247E-05, .340911E-05, .180840E-05, .826053E-06,
     +  .296532E-06, .701350E-07, .729449E-08, .000000E+00 /
        DATA (UPDI(I),I=2549,2600) /
     +  .325795E+05, .350068E+05, .276593E+05, .218537E+05,
     +  .172666E+05, .136421E+05, .107783E+05, .851561E+04,
     +  .672784E+04, .531534E+04, .419934E+04, .331763E+04,
     +  .262103E+04, .207068E+04, .163590E+04, .129241E+04,
     +  .102106E+04, .806702E+03, .637369E+03, .503607E+03,
     +  .397947E+03, .314488E+03, .248565E+03, .196496E+03,
     +  .155370E+03, .122887E+03, .972309E+02, .767114E+02,
     +  .607638E+02, .481642E+02, .382083E+02, .303397E+02,
     +  .241189E+02, .192117E+02, .153175E+02, .122341E+02,
     +  .978955E+01, .784837E+01, .630358E+01, .507039E+01,
     +  .408419E+01, .329120E+01, .265122E+01, .213247E+01,
     +  .171031E+01, .136569E+01, .108487E+01, .854034E+00,
     +  .667473E+00, .516308E+00, .396912E+00, .304206E+00 /
        DATA (UPDI(I),I=2601,2652) /
     +  .233999E+00, .182087E+00, .144285E+00, .116693E+00,
     +  .960374E-01, .798897E-01, .666579E-01, .554192E-01,
     +  .456951E-01, .372547E-01, .299800E-01, .238153E-01,
     +  .186167E-01, .143334E-01, .108635E-01, .810003E-02,
     +  .593683E-02, .427304E-02, .301644E-02, .208528E-02,
     +  .140874E-02, .927453E-03, .595970E-03, .370174E-03,
     +  .222034E-03, .127960E-03, .704122E-04, .367020E-04,
     +  .179369E-04, .812015E-05, .332428E-05, .120838E-05,
     +  .374066E-06, .929434E-07, .167746E-07, .182099E-08,
     +  .774896E-10, .321242E-12, .000000E+00, .595073E+05,
     +  .473399E+05, .372961E+05, .293758E+05, .231384E+05,
     +  .182207E+05, .143486E+05, .112963E+05, .889350E+04,
     +  .699981E+04, .550944E+04, .433511E+04, .341113E+04 /
        DATA (UPDI(I),I=2653,2704) /
     +  .268328E+04, .211075E+04, .165987E+04, .130532E+04,
     +  .102618E+04, .806761E+03, .634073E+03, .498378E+03,
     +  .391624E+03, .307769E+03, .241823E+03, .190041E+03,
     +  .149338E+03, .117391E+03, .919750E+02, .723502E+02,
     +  .569290E+02, .448302E+02, .353234E+02, .278633E+02,
     +  .220145E+02, .174098E+02, .137875E+02, .109396E+02,
     +  .869364E+01, .692197E+01, .551818E+01, .440606E+01,
     +  .351919E+01, .281067E+01, .224169E+01, .178391E+01,
     +  .141406E+01, .111645E+01, .874533E+00, .681577E+00,
     +  .526883E+00, .405958E+00, .312594E+00, .242023E+00,
     +  .189501E+00, .150765E+00, .121903E+00, .998840E-01,
     +  .824277E-01, .681166E-01, .560459E-01, .457648E-01,
     +  .369825E-01, .295411E-01, .233270E-01, .181548E-01 /
        DATA (UPDI(I),I=2705,2756) /
     +  .139338E-01, .105442E-01, .786008E-02, .576905E-02,
     +  .416298E-02, .295068E-02, .204920E-02, .139181E-02,
     +  .919075E-03, .590948E-03, .363980E-03, .212529E-03,
     +  .114563E-03, .535410E-04, .176783E-04, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .856743E+05, .677842E+05,
     +  .530732E+05, .415413E+05, .325161E+05, .254429E+05,
     +  .199088E+05, .155729E+05, .121814E+05, .952497E+04,
     +  .744785E+04, .582145E+04, .455019E+04, .355512E+04,
     +  .277763E+04, .216928E+04, .169416E+04, .132255E+04,
     +  .103245E+04, .805652E+03, .628698E+03, .490425E+03,
     +  .382591E+03, .298369E+03, .232719E+03, .181478E+03 /
        DATA (UPDI(I),I=2757,2808) /
     +  .141565E+03, .110038E+03, .858786E+02, .670315E+02,
     +  .523600E+02, .409170E+02, .320082E+02, .250764E+02,
     +  .196633E+02, .154377E+02, .121432E+02, .956545E+01,
     +  .754951E+01, .596532E+01, .472159E+01, .373845E+01,
     +  .296051E+01, .234171E+01, .184903E+01, .145505E+01,
     +  .114157E+01, .889463E+00, .690669E+00, .532860E+00,
     +  .410582E+00, .316690E+00, .245847E+00, .192911E+00,
     +  .153525E+00, .123807E+00, .100889E+00, .826145E-01,
     +  .676723E-01, .551736E-01, .446670E-01, .358148E-01,
     +  .284199E-01, .223224E-01, .173061E-01, .132509E-01,
     +  .100228E-01, .748348E-02, .551677E-02, .401123E-02,
     +  .287758E-02, .203423E-02, .141743E-02, .970855E-03,
     +  .657712E-03, .437075E-03, .286046E-03, .184040E-03 /
        DATA (UPDI(I),I=2809,2860) /
     +  .116633E-03, .726282E-04, .445693E-04, .268819E-04,
     +  .158705E-04, .913987E-05, .509977E-05, .269149E-05,
     +  .131355E-05, .557524E-06, .166896E-06, .972098E-08,
     +  .000000E+00, .124972E+06, .982500E+05, .763767E+05,
     +  .593523E+05, .461222E+05, .358280E+05, .278309E+05,
     +  .216105E+05, .167800E+05, .130240E+05, .101084E+05,
     +  .784228E+04, .608393E+04, .471779E+04, .365826E+04,
     +  .283541E+04, .219756E+04, .170242E+04, .131879E+04,
     +  .102116E+04, .790692E+03, .611982E+03, .473679E+03,
     +  .366491E+03, .283583E+03, .219376E+03, .169758E+03,
     +  .130871E+03, .101306E+03, .784226E+02, .607512E+02,
     +  .470779E+02, .365177E+02, .283670E+02, .220536E+02,
     +  .171654E+02, .133855E+02, .104524E+02, .817783E+01 /
        DATA (UPDI(I),I=2861,2912) /
     +  .640561E+01, .502647E+01, .394595E+01, .309879E+01,
     +  .243130E+01, .190507E+01, .148845E+01, .116037E+01,
     +  .899201E+00, .695368E+00, .535032E+00, .411760E+00,
     +  .317585E+00, .246651E+00, .193512E+00, .153733E+00,
     +  .123483E+00, .100015E+00, .812768E-01, .660201E-01,
     +  .533688E-01, .428549E-01, .341043E-01, .268822E-01,
     +  .209934E-01, .161983E-01, .123566E-01, .932319E-02,
     +  .695327E-02, .512849E-02, .373787E-02, .269437E-02,
     +  .191951E-02, .135282E-02, .941746E-03, .652107E-03,
     +  .446319E-03, .303664E-03, .205372E-03, .138649E-03,
     +  .932855E-04, .628324E-04, .421353E-04, .280227E-04,
     +  .183068E-04, .116055E-04, .694195E-05, .379093E-05,
     +  .176472E-05, .577886E-06, .503563E-07, .000000E+00 /
        DATA (UPDI(I),I=2913,2964) /
     +  .181125E+06, .141503E+06, .109217E+06, .842662E+05,
     +  .650112E+05, .501362E+05, .386618E+05, .298014E+05,
     +  .229697E+05, .176966E+05, .136329E+05, .104977E+05,
     +  .808281E+04, .622060E+04, .478698E+04, .368202E+04,
     +  .283186E+04, .217695E+04, .167335E+04, .128563E+04,
     +  .987706E+03, .758474E+03, .582431E+03, .447063E+03,
     +  .343167E+03, .263340E+03, .202138E+03, .154553E+03,
     +  .118660E+03, .911023E+02, .699893E+02, .537850E+02,
     +  .413697E+02, .318653E+02, .245627E+02, .189550E+02,
     +  .146543E+02, .113447E+02, .879965E+01, .683359E+01,
     +  .531674E+01, .413882E+01, .322354E+01, .250907E+01,
     +  .195111E+01, .151362E+01, .117247E+01, .903528E+00,
     +  .695614E+00, .533466E+00, .409687E+00, .315586E+00 /
        DATA (UPDI(I),I=2965,3016) /
     +  .244841E+00, .191773E+00, .151889E+00, .121420E+00,
     +  .977163E-01, .788137E-01, .635028E-01, .509169E-01,
     +  .405656E-01, .320463E-01, .250907E-01, .194771E-01,
     +  .149490E-01, .113525E-01, .853465E-02, .634834E-02,
     +  .467502E-02, .340640E-02, .245840E-02, .175667E-02,
     +  .124439E-02, .873045E-03, .610906E-03, .424030E-03,
     +  .293612E-03, .202849E-03, .140317E-03, .969761E-04,
     +  .671242E-04, .462126E-04, .314556E-04, .209382E-04,
     +  .134356E-04, .808147E-05, .439926E-05, .201632E-05,
     +  .641415E-06, .583109E-07, .000000E+00, .258946E+06,
     +  .201105E+06, .154171E+06, .118143E+06, .905217E+05,
     +  .693285E+05, .530897E+05, .406364E+05, .310998E+05,
     +  .237903E+05, .181960E+05, .139106E+05, .106328E+05 /
        DATA (UPDI(I),I=3017,3068) /
     +  .812335E+04, .620518E+04, .473757E+04, .361650E+04,
     +  .275929E+04, .210494E+04, .160495E+04, .122358E+04,
     +  .932379E+03, .710415E+03, .541049E+03, .412043E+03,
     +  .313693E+03, .238874E+03, .181157E+03, .137961E+03,
     +  .105060E+03, .800505E+02, .610098E+02, .465360E+02,
     +  .355459E+02, .271689E+02, .207892E+02, .159357E+02,
     +  .122319E+02, .940706E+01, .724345E+01, .558827E+01,
     +  .431417E+01, .333280E+01, .257371E+01, .198631E+01,
     +  .153006E+01, .117760E+01, .902326E+00, .691408E+00,
     +  .528259E+00, .404547E+00, .310948E+00, .240730E+00,
     +  .188040E+00, .148350E+00, .117962E+00, .943091E-01,
     +  .755008E-01, .603547E-01, .480118E-01, .379585E-01,
     +  .297708E-01, .231521E-01, .178617E-01, .136322E-01 /
        DATA (UPDI(I),I=3069,3120) /
     +  .103011E-01, .771081E-02, .571510E-02, .419704E-02,
     +  .305258E-02, .220136E-02, .157378E-02, .111700E-02,
     +  .786604E-03, .553365E-03, .386971E-03, .270442E-03,
     +  .188919E-03, .132244E-03, .925430E-04, .647760E-04,
     +  .450231E-04, .308394E-04, .205858E-04, .131816E-04,
     +  .787445E-05, .422930E-05, .189315E-05, .580806E-06,
     +  .540716E-07, .000000E+00, .364407E+06, .281449E+06,
     +  .214395E+06, .163244E+06, .124271E+06, .945578E+05,
     +  .719335E+05, .546956E+05, .415793E+05, .315924E+05,
     +  .239987E+05, .182208E+05, .138307E+05, .104928E+05,
     +  .795855E+04, .603307E+04, .457235E+04, .346337E+04,
     +  .262275E+04, .198506E+04, .150212E+04, .113607E+04,
     +  .859073E+03, .649291E+03, .490676E+03, .370664E+03 /
        DATA (UPDI(I),I=3121,3172) /
     +  .280055E+03, .210694E+03, .159180E+03, .120250E+03,
     +  .908840E+02, .687038E+02, .519743E+02, .393734E+02,
     +  .298439E+02, .226455E+02, .172129E+02, .131013E+02,
     +  .999095E+01, .762869E+01, .583656E+01, .446894E+01,
     +  .342458E+01, .262398E+01, .200995E+01, .153736E+01,
     +  .117557E+01, .895556E+00, .682818E+00, .519548E+00,
     +  .396537E+00, .303910E+00, .234591E+00, .182604E+00,
     +  .143407E+00, .113385E+00, .900405E-01, .715519E-01,
     +  .567560E-01, .448013E-01, .351541E-01, .273747E-01,
     +  .211450E-01, .162110E-01, .123002E-01, .924536E-02,
     +  .688764E-02, .508386E-02, .372040E-02, .269856E-02,
     +  .194238E-02, .138743E-02, .984995E-03, .694792E-03,
     +  .490158E-03, .344269E-03, .241929E-03, .170118E-03 /
        DATA (UPDI(I),I=3173,3224) /
     +  .119893E-03, .844688E-04, .594325E-04, .414554E-04,
     +  .284121E-04, .189201E-04, .120359E-04, .711379E-05,
     +  .375801E-05, .163936E-05, .484960E-06, .459830E-07,
     +  .000000E+00, .504683E+06, .387780E+06, .293630E+06,
     +  .222231E+06, .168146E+06, .127157E+06, .961319E+05,
     +  .726373E+05, .548681E+05, .414228E+05, .312623E+05,
     +  .235807E+05, .177808E+05, .133996E+05, .100946E+05,
     +  .760022E+04, .572034E+04, .430280E+04, .323550E+04,
     +  .243145E+04, .182670E+04, .137154E+04, .102953E+04,
     +  .772370E+03, .579320E+03, .434321E+03, .325649E+03,
     +  .243084E+03, .182221E+03, .136577E+03, .102405E+03,
     +  .767953E+02, .576261E+02, .433015E+02, .325522E+02,
     +  .244974E+02, .184662E+02, .139388E+02, .105413E+02 /
        DATA (UPDI(I),I=3225,3276) /
     +  .798241E+01, .605699E+01, .460014E+01, .349701E+01,
     +  .265876E+01, .202144E+01, .153528E+01, .116634E+01,
     +  .883293E+00, .669995E+00, .507532E+00, .385887E+00,
     +  .294726E+00, .226691E+00, .175732E+00, .137320E+00,
     +  .107925E+00, .851216E-01, .671468E-01, .528561E-01,
     +  .414069E-01, .322498E-01, .249354E-01, .191306E-01,
     +  .145737E-01, .109918E-01, .821651E-02, .609035E-02,
     +  .447520E-02, .326211E-02, .235850E-02, .169336E-02,
     +  .120762E-02, .856845E-03, .604771E-03, .427341E-03,
     +  .301014E-03, .212326E-03, .149972E-03, .106161E-03,
     +  .750978E-04, .529671E-04, .369723E-04, .252869E-04,
     +  .167573E-04, .105681E-04, .616858E-05, .320008E-05,
     +  .135908E-05, .388068E-06, .373831E-07, .000000E+00 /
        DATA (UPDI(I),I=3277,3328) /
     +  .688180E+06, .526203E+06, .396192E+06, .298146E+06,
     +  .224283E+06, .168622E+06, .126727E+06, .951849E+05,
     +  .714658E+05, .536244E+05, .402210E+05, .301488E+05,
     +  .225897E+05, .169149E+05, .126604E+05, .946969E+04,
     +  .708017E+04, .529002E+04, .395086E+04, .294871E+04,
     +  .219992E+04, .164019E+04, .122243E+04, .910507E+03,
     +  .677964E+03, .504535E+03, .375480E+03, .278145E+03,
     +  .206918E+03, .153898E+03, .114495E+03, .851897E+02,
     +  .634181E+02, .472746E+02, .352523E+02, .263146E+02,
     +  .196741E+02, .147293E+02, .110479E+02, .829779E+01,
     +  .624517E+01, .470505E+01, .354854E+01, .267726E+01,
     +  .202044E+01, .152375E+01, .115003E+01, .865740E+00,
     +  .653187E+00, .492478E+00, .372875E+00, .283674E+00 /
        DATA (UPDI(I),I=3329,3380) /
     +  .217304E+00, .167688E+00, .130333E+00, .101803E+00,
     +  .797409E-01, .624433E-01, .487838E-01, .379313E-01,
     +  .293265E-01, .225159E-01, .171578E-01, .129875E-01,
     +  .973623E-02, .723709E-02, .533655E-02, .390297E-02,
     +  .283319E-02, .204126E-02, .146151E-02, .104030E-02,
     +  .737432E-03, .520586E-03, .368269E-03, .259984E-03,
     +  .183925E-03, .130358E-03, .925696E-04, .656520E-04,
     +  .463445E-04, .323192E-04, .220233E-04, .145012E-04,
     +  .905415E-05, .521249E-05, .265243E-05, .109605E-05,
     +  .302441E-06, .295579E-07, .000000E+00, .924504E+06,
     +  .703641E+06, .526932E+06, .394376E+06, .295039E+06,
     +  .220584E+06, .164844E+06, .123109E+06, .918976E+05,
     +  .685530E+05, .511138E+05, .380847E+05, .283626E+05 /
        DATA (UPDI(I),I=3381,3432) /
     +  .211073E+05, .157000E+05, .116694E+05, .866913E+04,
     +  .643545E+04, .477485E+04, .354011E+04, .262339E+04,
     +  .194263E+04, .143786E+04, .106351E+04, .786288E+03,
     +  .580957E+03, .429219E+03, .315591E+03, .233030E+03,
     +  .172020E+03, .127005E+03, .937727E+02, .692649E+02,
     +  .512300E+02, .378994E+02, .280655E+02, .208147E+02,
     +  .154580E+02, .115009E+02, .856859E+01, .639731E+01,
     +  .478152E+01, .357806E+01, .267904E+01, .200693E+01,
     +  .150298E+01, .112695E+01, .843240E+00, .632744E+00,
     +  .474725E+00, .357823E+00, .271058E+00, .206715E+00,
     +  .158733E+00, .122678E+00, .952192E-01, .740689E-01,
     +  .575808E-01, .446504E-01, .344615E-01, .264510E-01,
     +  .201668E-01, .152645E-01, .114808E-01, .855449E-02 /
        DATA (UPDI(I),I=3433,3484) /
     +  .632275E-02, .463791E-02, .337593E-02, .244030E-02,
     +  .175197E-02, .125084E-02, .888615E-03, .629308E-03,
     +  .444313E-03, .314641E-03, .222576E-03, .157871E-03,
     +  .112215E-03, .798794E-04, .567414E-04, .400447E-04,
     +  .278656E-04, .188958E-04, .123474E-04, .762423E-05,
     +  .432460E-05, .215653E-05, .866680E-06, .231377E-06,
     +  .229206E-07, .000000E+00, .122437E+07, .927761E+06,
     +  .691168E+06, .514596E+06, .382940E+06, .284772E+06,
     +  .211659E+06, .157205E+06, .116698E+06, .865642E+05,
     +  .641755E+05, .475414E+05, .351982E+05, .260395E+05,
     +  .192524E+05, .142229E+05, .105010E+05, .774668E+04,
     +  .571133E+04, .420729E+04, .309751E+04, .227861E+04,
     +  .167526E+04, .123071E+04, .903656E+03, .663019E+03 /
        DATA (UPDI(I),I=3485,3536) /
     +  .486388E+03, .355033E+03, .260254E+03, .190711E+03,
     +  .139758E+03, .102415E+03, .750732E+02, .551013E+02,
     +  .404468E+02, .297181E+02, .218666E+02, .161110E+02,
     +  .118916E+02, .878953E+01, .651046E+01, .482807E+01,
     +  .358505E+01, .266410E+01, .198120E+01, .147340E+01,
     +  .109755E+01, .816258E+00, .609099E+00, .454666E+00,
     +  .341085E+00, .257196E+00, .195208E+00, .149118E+00,
     +  .114576E+00, .883605E-01, .682579E-01, .526809E-01,
     +  .405506E-01, .310694E-01, .236770E-01, .179275E-01,
     +  .134791E-01, .100738E-01, .746083E-02, .548340E-02,
     +  .400127E-02, .289884E-02, .208675E-02, .149298E-02,
     +  .106306E-02, .753871E-03, .533471E-03, .376760E-03,
     +  .267119E-03, .189346E-03, .134632E-03, .959379E-04 /
        DATA (UPDI(I),I=3537,3588) /
     +  .684190E-04, .486374E-04, .342847E-04, .237806E-04,
     +  .160300E-04, .103842E-04, .633501E-05, .353706E-05,
     +  .172704E-05, .674825E-06, .174499E-06, .175100E-07,
     +  .000000E+00, .159945E+07, .120684E+07, .894578E+06,
     +  .662683E+06, .490619E+06, .362964E+06, .268363E+06,
     +  .198267E+06, .146389E+06, .107999E+06, .796259E+05,
     +  .586586E+05, .431836E+05, .317643E+05, .233486E+05,
     +  .171477E+05, .125848E+05, .922786E+04, .676159E+04,
     +  .495003E+04, .362132E+04, .264691E+04, .193340E+04,
     +  .141100E+04, .102911E+04, .749939E+03, .546367E+03,
     +  .395998E+03, .288232E+03, .209704E+03, .152562E+03,
     +  .110979E+03, .807456E+02, .588212E+02, .428492E+02,
     +  .312424E+02, .228105E+02, .166762E+02, .122128E+02 /
        DATA (UPDI(I),I=3589,3640) /
     +  .895667E+01, .658270E+01, .484407E+01, .356957E+01,
     +  .263290E+01, .194389E+01, .143567E+01, .106249E+01,
     +  .785365E+00, .582753E+00, .432734E+00, .323037E+00,
     +  .242414E+00, .183066E+00, .139087E+00, .106230E+00,
     +  .813927E-01, .624406E-01, .478466E-01, .365620E-01,
     +  .278122E-01, .210454E-01, .158266E-01, .118211E-01,
     +  .877949E-02, .646350E-02, .472408E-02, .342959E-02,
     +  .247332E-02, .177335E-02, .126465E-02, .898274E-03,
     +  .636071E-03, .449904E-03, .317926E-03, .225726E-03,
     +  .160346E-03, .114283E-03, .816136E-04, .582781E-04,
     +  .414265E-04, .291406E-04, .201272E-04, .134733E-04,
     +  .864396E-05, .520541E-05, .285839E-05, .136558E-05,
     +  .518705E-06, .130058E-06, .132128E-07, .000000E+00 /
        DATA (UPDI(I),I=3641,3692) /
     +  .206212E+07, .154956E+07, .114305E+07, .842608E+06,
     +  .620737E+06, .456928E+06, .336122E+06, .247054E+06,
     +  .181461E+06, .133170E+06, .976597E+05, .715553E+05,
     +  .523892E+05, .383219E+05, .280101E+05, .204539E+05,
     +  .149243E+05, .108791E+05, .792404E+04, .576602E+04,
     +  .419242E+04, .304529E+04, .221034E+04, .160279E+04,
     +  .116139E+04, .840742E+03, .608419E+03, .437938E+03,
     +  .316564E+03, .228713E+03, .165213E+03, .119322E+03,
     +  .861856E+02, .623248E+02, .450641E+02, .326112E+02,
     +  .236296E+02, .171437E+02, .124592E+02, .906750E+01,
     +  .661325E+01, .482968E+01, .353231E+01, .258633E+01,
     +  .189589E+01, .139064E+01, .102251E+01, .751204E+00,
     +  .554247E+00, .409380E+00, .304057E+00, .227029E+00 /
        DATA (UPDI(I),I=3693,3744) /
     +  .170555E+00, .128859E+00, .978200E-01, .744602E-01,
     +  .567287E-01, .431618E-01, .327459E-01, .247331E-01,
     +  .185856E-01, .138831E-01, .103023E-01, .760447E-02,
     +  .556576E-02, .404595E-02, .292277E-02, .209860E-02,
     +  .149906E-02, .106589E-02, .755507E-03, .534387E-03,
     +  .377953E-03, .267325E-03, .190115E-03, .135347E-03,
     +  .966788E-04, .691634E-04, .494198E-04, .350985E-04,
     +  .246149E-04, .169128E-04, .112325E-04, .713045E-05,
     +  .423514E-05, .228544E-05, .106768E-05, .394214E-06,
     +  .959472E-07, .986439E-08, .000000E+00, .262512E+07,
     +  .196479E+07, .144252E+07, .105831E+07, .775884E+06,
     +  .568353E+06, .416026E+06, .304259E+06, .222348E+06,
     +  .162342E+06, .118435E+06, .863220E+05, .628640E+05 /
        DATA (UPDI(I),I=3745,3796) /
     +  .457361E+05, .332464E+05, .241430E+05, .175169E+05,
     +  .126962E+05, .919402E+04, .665088E+04, .480695E+04,
     +  .347057E+04, .250355E+04, .180410E+04, .129899E+04,
     +  .934298E+03, .671712E+03, .480255E+03, .344825E+03,
     +  .247440E+03, .177507E+03, .127307E+03, .913012E+02,
     +  .655525E+02, .470536E+02, .338015E+02, .243108E+02,
     +  .175066E+02, .126275E+02, .912110E+01, .660244E+01,
     +  .478587E+01, .347446E+01, .252560E+01, .183836E+01,
     +  .133932E+01, .978453E+00, .714460E+00, .524137E+00,
     +  .385056E+00, .284510E+00, .211340E+00, .157919E+00,
     +  .118631E+00, .895026E-01, .676838E-01, .512127E-01,
     +  .386920E-01, .291475E-01, .218619E-01, .163160E-01,
     +  .121076E-01, .892767E-02, .655022E-02, .476691E-02 /
        DATA (UPDI(I),I=3797,3848) /
     +  .344713E-02, .247842E-02, .177223E-02, .126159E-02,
     +  .894715E-03, .633100E-03, .447501E-03, .316603E-03,
     +  .224209E-03, .159747E-03, .113975E-03, .815718E-04,
     +  .584285E-04, .417466E-04, .295965E-04, .206744E-04,
     +  .141179E-04, .929408E-05, .583286E-05, .341442E-05,
     +  .180950E-05, .826216E-06, .296547E-06, .701356E-07,
     +  .729450E-08, .000000E+00, .273075E+05, .229418E+05,
     +  .191899E+05, .160516E+05, .134266E+05, .112309E+05,
     +  .939440E+04, .785825E+04, .657335E+04, .549860E+04,
     +  .459965E+04, .384772E+04, .321878E+04, .269272E+04,
     +  .225270E+04, .188465E+04, .157680E+04, .131932E+04,
     +  .110395E+04, .923811E+03, .773144E+03, .647128E+03,
     +  .541729E+03, .453578E+03, .379852E+03, .318192E+03 /
        DATA (UPDI(I),I=3849,3900) /
     +  .266625E+03, .222942E+03, .186983E+03, .156910E+03,
     +  .131759E+03, .110726E+03, .931363E+02, .784662E+02,
     +  .661651E+02, .558806E+02, .472800E+02, .400848E+02,
     +  .340615E+02, .290126E+02, .247814E+02, .212239E+02,
     +  .182283E+02, .156997E+02, .135594E+02, .117423E+02,
     +  .102000E+02, .887339E+01, .774217E+01, .676224E+01,
     +  .591883E+01, .518756E+01, .455149E+01, .399648E+01,
     +  .351083E+01, .308475E+01, .271008E+01, .237997E+01,
     +  .208864E+01, .183117E+01, .160339E+01, .140170E+01,
     +  .122304E+01, .106541E+01, .924894E+00, .800496E+00,
     +  .690451E+00, .593213E+00, .507424E+00, .431883E+00,
     +  .365527E+00, .307410E+00, .256657E+00, .212478E+00,
     +  .174557E+00, .141713E+00, .113669E+00, .899053E-01 /
        DATA (UPDI(I),I=3901,3952) /
     +  .699518E-01, .533800E-01, .397971E-01, .288586E-01,
     +  .201697E-01, .134989E-01, .851829E-02, .495983E-02,
     +  .256973E-02, .110682E-02, .340186E-03, .457810E-04,
     +  .000000E+00, .374815E+06, .298034E+06, .234685E+06,
     +  .184767E+06, .145516E+06, .114584E+06, .902607E+05,
     +  .710895E+05, .560121E+05, .441267E+05, .347780E+05,
     +  .274069E+05, .216080E+05, .170346E+05, .134359E+05,
     +  .105970E+05, .836249E+04, .659913E+04, .521082E+04,
     +  .411475E+04, .325145E+04, .256955E+04, .203225E+04,
     +  .160765E+04, .127290E+04, .100823E+04, .799395E+03,
     +  .632176E+03, .502238E+03, .399320E+03, .318014E+03,
     +  .253549E+03, .202575E+03, .162213E+03, .130171E+03,
     +  .104706E+03, .845105E+02, .684212E+02, .556219E+02 /
        DATA (UPDI(I),I=3953,4004) /
     +  .453828E+02, .372072E+02, .306301E+02, .253386E+02,
     +  .210522E+02, .175742E+02, .147320E+02, .124113E+02,
     +  .104843E+02, .889814E+01, .756793E+01, .645944E+01,
     +  .552640E+01, .473833E+01, .406919E+01, .349925E+01,
     +  .301173E+01, .259360E+01, .223383E+01, .192357E+01,
     +  .165547E+01, .142339E+01, .122231E+01, .104777E+01,
     +  .896929E+00, .765133E+00, .650798E+00, .551622E+00,
     +  .465723E+00, .391403E+00, .327255E+00, .271998E+00,
     +  .224580E+00, .184014E+00, .149421E+00, .120343E+00,
     +  .957079E-01, .751322E-01, .581054E-01, .441464E-01,
     +  .328530E-01, .238367E-01, .167907E-01, .113632E-01,
     +  .734050E-02, .444877E-02, .247272E-02, .121118E-02,
     +  .486604E-03, .138010E-03, .186980E-04, .000000E+00 /
        DATA (UPDI(I),I=4005,4056) /
     +  .102145E+07, .803883E+06, .625617E+06, .486648E+06,
     +  .378587E+06, .294378E+06, .228924E+06, .177935E+06,
     +  .138318E+06, .107468E+06, .835079E+05, .648572E+05,
     +  .503779E+05, .391115E+05, .303687E+05, .235686E+05,
     +  .182939E+05, .141929E+05, .110134E+05, .854222E+04,
     +  .662706E+04, .513916E+04, .398655E+04, .309147E+04,
     +  .239832E+04, .186019E+04, .144360E+04, .111645E+04,
     +  .867261E+03, .673873E+03, .524227E+03, .408093E+03,
     +  .318222E+03, .248630E+03, .194607E+03, .152652E+03,
     +  .120138E+03, .948391E+02, .751819E+02, .598273E+02,
     +  .478538E+02, .384482E+02, .310564E+02, .252079E+02,
     +  .205703E+02, .168658E+02, .139081E+02, .115053E+02,
     +  .956957E+01, .798026E+01, .668277E+01, .561253E+01 /
        DATA (UPDI(I),I=4057,4108) /
     +  .472615E+01, .398797E+01, .337094E+01, .285289E+01,
     +  .241655E+01, .204779E+01, .173532E+01, .146998E+01,
     +  .124422E+01, .105194E+01, .887787E+00, .748304E+00,
     +  .628457E+00, .526236E+00, .439047E+00, .364810E+00,
     +  .301668E+00, .248110E+00, .202775E+00, .164572E+00,
     +  .132488E+00, .105632E+00, .834908E-01, .651058E-01,
     +  .500656E-01, .378895E-01, .281323E-01, .204289E-01,
     +  .144340E-01, .988017E-02, .647643E-02, .403794E-02,
     +  .234960E-02, .124540E-02, .575653E-03, .215190E-03,
     +  .562211E-04, .766834E-05, .000000E+00, .207728E+07,
     +  .162221E+07, .125133E+07, .964647E+06, .743595E+06,
     +  .572832E+06, .441251E+06, .339670E+06, .261451E+06,
     +  .201108E+06, .154676E+06, .118881E+06, .913594E+05 /
        DATA (UPDI(I),I=4109,4160) /
     +  .701588E+05, .538714E+05, .413349E+05, .317119E+05,
     +  .243112E+05, .186356E+05, .142745E+05, .109329E+05,
     +  .836758E+04, .640396E+04, .489795E+04, .374623E+04,
     +  .286365E+04, .218941E+04, .166719E+04, .127491E+04,
     +  .974849E+03, .745982E+03, .571052E+03, .437700E+03,
     +  .336067E+03, .258396E+03, .199062E+03, .153821E+03,
     +  .119213E+03, .927657E+02, .724623E+02, .568950E+02,
     +  .448782E+02, .355930E+02, .283734E+02, .227445E+02,
     +  .183246E+02, .148539E+02, .120814E+02, .988411E+01,
     +  .810951E+01, .668366E+01, .552630E+01, .458255E+01,
     +  .380884E+01, .317188E+01, .264525E+01, .220827E+01,
     +  .184451E+01, .154082E+01, .128676E+01, .107375E+01,
     +  .895022E+00, .744658E+00, .618781E+00, .512223E+00 /
        DATA (UPDI(I),I=4161,4212) /
     +  .422703E+00, .347500E+00, .284452E+00, .231659E+00,
     +  .187589E+00, .150889E+00, .120475E+00, .953696E-01,
     +  .747203E-01, .580036E-01, .443837E-01, .334602E-01,
     +  .247989E-01, .180089E-01, .127715E-01, .879560E-02,
     +  .585603E-02, .372232E-02, .224275E-02, .125502E-02,
     +  .635698E-03, .278232E-03, .974391E-04, .238331E-04,
     +  .326550E-05, .000000E+00, .367911E+07, .285386E+07,
     +  .218444E+07, .167085E+07, .127776E+07, .976429E+06,
     +  .745993E+06, .569503E+06, .434660E+06, .331479E+06,
     +  .252722E+06, .192518E+06, .146611E+06, .111555E+06,
     +  .848537E+05, .644860E+05, .489904E+05, .371843E+05,
     +  .282135E+05, .213870E+05, .162065E+05, .122695E+05,
     +  .928596E+04, .702173E+04, .530817E+04, .400931E+04 /
        DATA (UPDI(I),I=4213,4264) /
     +  .302800E+04, .227664E+04, .171872E+04, .129708E+04,
     +  .979290E+03, .739441E+03, .558852E+03, .423014E+03,
     +  .320533E+03, .243306E+03, .185202E+03, .141372E+03,
     +  .108335E+03, .833318E+02, .644263E+02, .500422E+02,
     +  .390822E+02, .306831E+02, .242257E+02, .192276E+02,
     +  .153571E+02, .123086E+02, .992583E+01, .802815E+01,
     +  .652403E+01, .531987E+01, .435106E+01, .356757E+01,
     +  .293109E+01, .241192E+01, .198681E+01, .163764E+01,
     +  .134998E+01, .111254E+01, .916127E+00, .753532E+00,
     +  .618567E+00, .507121E+00, .414072E+00, .336991E+00,
     +  .273154E+00, .220406E+00, .176886E+00, .141101E+00,
     +  .111759E+00, .878282E-01, .683967E-01, .526817E-01,
     +  .401819E-01, .301825E-01, .223159E-01, .162033E-01 /
        DATA (UPDI(I),I=4265,4316) /
     +  .115130E-01, .797648E-02, .535660E-02, .347023E-02,
     +  .214001E-02, .124670E-02, .671426E-03, .325362E-03,
     +  .135136E-03, .445569E-04, .103041E-04, .141503E-05,
     +  .000000E+00, .599042E+07, .461837E+07, .351016E+07,
     +  .266579E+07, .202388E+07, .153530E+07, .116424E+07,
     +  .882123E+06, .668103E+06, .505561E+06, .382400E+06,
     +  .288974E+06, .218272E+06, .164708E+06, .124227E+06,
     +  .936001E+05, .704864E+05, .530248E+05, .398668E+05,
     +  .299416E+05, .224745E+05, .168512E+05, .126279E+05,
     +  .945300E+04, .707263E+04, .528587E+04, .394923E+04,
     +  .293626E+04, .219178E+04, .163516E+04, .122005E+04,
     +  .910231E+03, .679507E+03, .507964E+03, .380012E+03,
     +  .284742E+03, .213903E+03, .161124E+03, .121817E+03 /
        DATA (UPDI(I),I=4317,4368) /
     +  .924427E+02, .705029E+02, .540213E+02, .416175E+02,
     +  .322329E+02, .251070E+02, .196609E+02, .154956E+02,
     +  .122557E+02, .975460E+01, .778745E+01, .624726E+01,
     +  .502946E+01, .406155E+01, .328841E+01, .266794E+01,
     +  .216804E+01, .176367E+01, .143563E+01, .116869E+01,
     +  .951103E+00, .773341E+00, .628039E+00, .508948E+00,
     +  .411876E+00, .331881E+00, .266494E+00, .213073E+00,
     +  .169541E+00, .134132E+00, .105437E+00, .822587E-01,
     +  .636455E-01, .487718E-01, .369393E-01, .276886E-01,
     +  .204202E-01, .148094E-01, .105359E-01, .732537E-02,
     +  .495863E-02, .324735E-02, .204717E-02, .122488E-02,
     +  .690023E-03, .357744E-03, .165934E-03, .654960E-04,
     +  .204037E-04, .448803E-05, .616002E-06, .000000E+00 /
        DATA (UPDI(I),I=4369,4420) /
     +  .920088E+07, .705322E+07, .532544E+07, .401754E+07,
     +  .302951E+07, .228249E+07, .171885E+07, .129321E+07,
     +  .972465E+06, .730570E+06, .548535E+06, .411442E+06,
     +  .308422E+06, .230952E+06, .172827E+06, .129187E+06,
     +  .964980E+05, .719970E+05, .536771E+05, .399705E+05,
     +  .297412E+05, .221025E+05, .164132E+05, .121735E+05,
     +  .902214E+04, .667795E+04, .494026E+04, .363576E+04,
     +  .268608E+04, .198300E+04, .146375E+04, .108017E+04,
     +  .797377E+03, .589349E+03, .435798E+03, .322717E+03,
     +  .239540E+03, .178262E+03, .133131E+03, .997879E+02,
     +  .751637E+02, .568793E+02, .432744E+02, .331006E+02,
     +  .254633E+02, .196939E+02, .153315E+02, .119773E+02,
     +  .941753E+01, .742732E+01, .588673E+01, .468259E+01 /
        DATA (UPDI(I),I=4421,4472) /
     +  .373637E+01, .298923E+01, .239644E+01, .192434E+01,
     +  .154682E+01, .124413E+01, .100069E+01, .804582E+00,
     +  .646273E+00, .518426E+00, .414907E+00, .331569E+00,
     +  .263752E+00, .209028E+00, .164905E+00, .129429E+00,
     +  .100969E+00, .782303E-01, .601307E-01, .458137E-01,
     +  .345513E-01, .257358E-01, .189600E-01, .137298E-01,
     +  .976756E-02, .680877E-02, .463233E-02, .306352E-02,
     +  .195635E-02, .120000E-02, .696551E-03, .379401E-03,
     +  .189350E-03, .840845E-04, .315724E-04, .931613E-05,
     +  .195609E-05, .267277E-06, .000000E+00, .135232E+08,
     +  .103111E+08, .773663E+07, .579979E+07, .434546E+07,
     +  .325281E+07, .243346E+07, .181873E+07, .135841E+07,
     +  .101356E+07, .755733E+06, .562879E+06, .418926E+06 /
        DATA (UPDI(I),I=4473,4524) /
     +  .311431E+06, .231333E+06, .171628E+06, .127224E+06,
     +  .941886E+05, .696684E+05, .514635E+05, .379799E+05,
     +  .279909E+05, .206096E+05, .151539E+05, .111319E+05,
     +  .816527E+04, .598507E+04, .436284E+04, .319237E+04,
     +  .233380E+04, .170550E+04, .124580E+04, .910094E+03,
     +  .665584E+03, .486870E+03, .356602E+03, .261751E+03,
     +  .192606E+03, .142207E+03, .105370E+03, .784519E+02,
     +  .586802E+02, .441248E+02, .333587E+02, .253633E+02,
     +  .193888E+02, .149197E+02, .115207E+02, .895458E+01,
     +  .698108E+01, .546984E+01, .430144E+01, .339320E+01,
     +  .268385E+01, .212716E+01, .168866E+01, .134186E+01,
     +  .106689E+01, .848208E+00, .674045E+00, .535054E+00,
     +  .424107E+00, .335322E+00, .264698E+00, .207926E+00 /
        DATA (UPDI(I),I=4525,4576) /
     +  .162684E+00, .126670E+00, .980922E-01, .754725E-01,
     +  .576496E-01, .436650E-01, .327657E-01, .243233E-01,
     +  .178199E-01, .129044E-01, .917628E-02, .640401E-02,
     +  .437414E-02, .291199E-02, .188139E-02, .117146E-02,
     +  .699074E-03, .393610E-03, .207264E-03, .995678E-04,
     +  .423373E-04, .151349E-04, .423737E-05, .850715E-06,
     +  .115027E-06, .000000E+00, .191874E+08, .145554E+08,
     +  .108559E+08, .808917E+07, .602367E+07, .448120E+07,
     +  .333139E+07, .247405E+07, .183598E+07, .136098E+07,
     +  .100805E+07, .745783E+06, .551270E+06, .406990E+06,
     +  .300191E+06, .221131E+06, .162730E+06, .119590E+06,
     +  .877933E+05, .643589E+05, .471278E+05, .344590E+05,
     +  .251675E+05, .183537E+05, .133695E+05, .972273E+04 /
        DATA (UPDI(I),I=4577,4628) /
     +  .706462E+04, .510344E+04, .370041E+04, .268026E+04,
     +  .194020E+04, .140364E+04, .101533E+04, .735159E+03,
     +  .532289E+03, .385846E+03, .280243E+03, .204024E+03,
     +  .149016E+03, .109219E+03, .804281E+02, .594979E+02,
     +  .442456E+02, .330807E+02, .248736E+02, .188042E+02,
     +  .143107E+02, .109283E+02, .840100E+01, .647746E+01,
     +  .501967E+01, .390429E+01, .304623E+01, .238307E+01,
     +  .186806E+01, .146667E+01, .115259E+01, .906219E+00,
     +  .712402E+00, .559728E+00, .439234E+00, .344129E+00,
     +  .268887E+00, .209728E+00, .162735E+00, .125739E+00,
     +  .966546E-01, .738683E-01, .560692E-01, .422337E-01,
     +  .315294E-01, .233068E-01, .170338E-01, .122769E-01,
     +  .874037E-02, .610423E-02, .417968E-02, .279766E-02 /
        DATA (UPDI(I),I=4629,4680) /
     +  .182264E-02, .115051E-02, .698535E-03, .405558E-03,
     +  .221503E-03, .112762E-03, .521478E-04, .212393E-04,
     +  .723493E-05, .192429E-05, .369346E-06, .489637E-07,
     +  .000000E+00, .264329E+08, .199539E+08, .147968E+08,
     +  .109618E+08, .811473E+07, .600096E+07, .443429E+07,
     +  .327306E+07, .241387E+07, .177817E+07, .130868E+07,
     +  .961973E+06, .706419E+06, .518081E+06, .379554E+06,
     +  .277684E+06, .202925E+06, .148078E+06, .107926E+06,
     +  .785405E+05, .570846E+05, .414239E+05, .300211E+05,
     +  .217216E+05, .156959E+05, .113212E+05, .815762E+04,
     +  .584231E+04, .419945E+04, .301491E+04, .216277E+04,
     +  .155032E+04, .111091E+04, .796733E+03, .571266E+03,
     +  .410020E+03, .294816E+03, .212458E+03, .153582E+03 /
        DATA (UPDI(I),I=4681,4732) /
     +  .111399E+03, .811764E+02, .594209E+02, .437214E+02,
     +  .323431E+02, .240613E+02, .179972E+02, .135519E+02,
     +  .102389E+02, .778809E+01, .594133E+01, .455564E+01,
     +  .350604E+01, .270666E+01, .209507E+01, .162491E+01,
     +  .126221E+01, .981306E+00, .763247E+00, .593499E+00,
     +  .461198E+00, .357904E+00, .277260E+00, .214163E+00,
     +  .165110E+00, .126593E+00, .966262E-01, .733527E-01,
     +  .553442E-01, .414567E-01, .308034E-01, .226735E-01,
     +  .165162E-01, .118879E-01, .843170E-02, .590347E-02,
     +  .405060E-02, .272207E-02, .178609E-02, .113909E-02,
     +  .702732E-03, .416179E-03, .235161E-03, .124635E-03,
     +  .613684E-04, .273372E-04, .106738E-04, .346877E-05,
     +  .877307E-06, .160658E-06, .205839E-07, .000000E+00 /
        DATA (UPDI(I),I=4733,4784) /
     +  .354986E+08, .266718E+08, .196688E+08, .144894E+08,
     +  .106652E+08, .784182E+07, .576079E+07, .422718E+07,
     +  .309890E+07, .226901E+07, .165967E+07, .121241E+07,
     +  .884702E+06, .644689E+06, .469237E+06, .341037E+06,
     +  .247551E+06, .179414E+06, .129859E+06, .938382E+05,
     +  .677144E+05, .487800E+05, .350897E+05, .251973E+05,
     +  .180670E+05, .129289E+05, .924142E+04, .656374E+04,
     +  .467872E+04, .333052E+04, .236848E+04, .168282E+04,
     +  .119500E+04, .849217E+03, .603215E+03, .428853E+03,
     +  .305388E+03, .217933E+03, .155985E+03, .112015E+03,
     +  .808053E+02, .585518E+02, .426442E+02, .312251E+02,
     +  .229925E+02, .170221E+02, .126873E+02, .948748E+01,
     +  .714323E+01, .539374E+01, .409369E+01, .311849E+01 /
        DATA (UPDI(I),I=4785,4836) /
     +  .238296E+01, .182571E+01, .140152E+01, .107750E+01,
     +  .829058E+00, .638127E+00, .491004E+00, .377511E+00,
     +  .289822E+00, .222081E+00, .169647E+00, .129326E+00,
     +  .980183E-01, .739373E-01, .554540E-01, .413231E-01,
     +  .305605E-01, .224093E-01, .162708E-01, .116850E-01,
     +  .828707E-02, .578718E-02, .398691E-02, .268906E-02,
     +  .177460E-02, .114214E-02, .713522E-03, .430510E-03,
     +  .248887E-03, .136985E-03, .705210E-04, .336223E-04,
     +  .144467E-04, .541657E-05, .168266E-05, .405130E-06,
     +  .705039E-07, .854066E-08, .000000E+00, .466123E+08,
     +  .348638E+08, .255715E+08, .187356E+08, .137147E+08,
     +  .100280E+08, .732528E+07, .534456E+07, .389536E+07,
     +  .283551E+07, .206171E+07, .149705E+07, .108573E+07 /
        DATA (UPDI(I),I=4837,4888) /
     +  .786289E+06, .568700E+06, .410692E+06, .296178E+06,
     +  .213246E+06, .153312E+06, .110033E+06, .788506E+05,
     +  .564027E+05, .402818E+05, .287145E+05, .204355E+05,
     +  .145125E+05, .102932E+05, .725235E+04, .512799E+04,
     +  .362047E+04, .255314E+04, .179861E+04, .126612E+04,
     +  .891834E+03, .627783E+03, .442242E+03, .311998E+03,
     +  .220558E+03, .156360E+03, .111206E+03, .794440E+02,
     +  .570044E+02, .411101E+02, .298061E+02, .217316E+02,
     +  .159300E+02, .117567E+02, .870475E+01, .648967E+01,
     +  .485197E+01, .364637E+01, .275049E+01, .208113E+01,
     +  .157880E+01, .120003E+01, .913471E+00, .695861E+00,
     +  .530247E+00, .403881E+00, .307364E+00, .233539E+00,
     +  .177088E+00, .133842E+00, .100935E+00, .756579E-01 /
        DATA (UPDI(I),I=4889,4940) /
     +  .564283E-01, .418347E-01, .308057E-01, .225054E-01,
     +  .162956E-01, .116782E-01, .827379E-02, .578557E-02,
     +  .398089E-02, .270060E-02, .179198E-02, .116235E-02,
     +  .734495E-03, .449956E-03, .265825E-03, .150215E-03,
     +  .806510E-04, .403993E-04, .186881E-04, .776414E-05,
     +  .280338E-05, .835071E-06, .191747E-06, .315417E-07,
     +  .349730E-08, .000000E+00, .599792E+08, .446656E+08,
     +  .325898E+08, .237520E+08, .172938E+08, .125768E+08,
     +  .913678E+07, .662938E+07, .480466E+07, .347755E+07,
     +  .251396E+07, .181479E+07, .130837E+07, .941839E+06,
     +  .677047E+06, .485914E+06, .348221E+06, .249118E+06,
     +  .177939E+06, .126866E+06, .903027E+05, .641539E+05,
     +  .454990E+05, .322041E+05, .227534E+05, .160395E+05 /
        DATA (UPDI(I),I=4941,4992) /
     +  .112910E+05, .789383E+04, .553811E+04, .387904E+04,
     +  .271335E+04, .189574E+04, .132327E+04, .924148E+03,
     +  .644864E+03, .450261E+03, .314802E+03, .220517E+03,
     +  .154892E+03, .109138E+03, .772368E+02, .548985E+02,
     +  .392164E+02, .281633E+02, .203386E+02, .147669E+02,
     +  .107952E+02, .791663E+01, .584632E+01, .432948E+01,
     +  .322297E+01, .240817E+01, .180493E+01, .135633E+01,
     +  .102119E+01, .769958E+00, .580949E+00, .438443E+00,
     +  .330735E+00, .249248E+00, .187521E+00, .140779E+00,
     +  .105325E+00, .786184E-01, .583136E-01, .430280E-01,
     +  .315520E-01, .229740E-01, .165910E-01, .118709E-01,
     +  .840327E-02, .587808E-02, .405625E-02, .275255E-02,
     +  .184061E-02, .120287E-02, .767807E-03, .476993E-03 /
        DATA (UPDI(I),I=4993,5044) /
     +  .286961E-03, .166271E-03, .920124E-04, .482949E-04,
     +  .235983E-04, .106228E-04, .428249E-05, .149527E-05,
     +  .429017E-06, .942374E-07, .145754E-07, .141372E-08,
     +  .000000E+00, .757706E+08, .561867E+08, .407880E+08,
     +  .295746E+08, .214213E+08, .154968E+08, .111981E+08,
     +  .808134E+07, .582499E+07, .419278E+07, .301402E+07,
     +  .216344E+07, .155074E+07, .110980E+07, .793056E+06,
     +  .565753E+06, .402958E+06, .286490E+06, .203342E+06,
     +  .144049E+06, .101865E+06, .718887E+05, .506403E+05,
     +  .355969E+05, .249742E+05, .174791E+05, .122150E+05,
     +  .847562E+04, .590137E+04, .410171E+04, .284659E+04,
     +  .197296E+04, .136595E+04, .946069E+03, .654589E+03,
     +  .453138E+03, .314058E+03, .218059E+03, .151802E+03 /
        DATA (UPDI(I),I=5045,5096) /
     +  .105998E+03, .743353E+02, .523549E+02, .370572E+02,
     +  .263687E+02, .188679E+02, .135733E+02, .983202E+01,
     +  .714410E+01, .522786E+01, .383615E+01, .282982E+01,
     +  .209527E+01, .155621E+01, .115887E+01, .864626E+00,
     +  .646011E+00, .483004E+00, .361200E+00, .269971E+00,
     +  .201577E+00, .150244E+00, .111733E+00, .827975E-01,
     +  .612078E-01, .449531E-01, .328372E-01, .238332E-01,
     +  .171723E-01, .122684E-01, .868136E-02, .607571E-02,
     +  .420009E-02, .286314E-02, .191828E-02, .126594E-02,
     +  .815887E-03, .513245E-03, .313974E-03, .185832E-03,
     +  .105819E-03, .574805E-04, .295729E-04, .141400E-04,
     +  .621687E-05, .244262E-05, .828919E-06, .230343E-06,
     +  .486247E-07, .705140E-08, .564370E-09, .000000E+00 /
        DATA (UPDI(I),I=5097,5148) /
     +  .325795E+05, .352651E+05, .278909E+05, .220615E+05,
     +  .174529E+05, .138092E+05, .109282E+05, .865009E+04,
     +  .684851E+04, .542363E+04, .429654E+04, .340490E+04,
     +  .269940E+04, .214109E+04, .169916E+04, .134929E+04,
     +  .107222E+04, .852751E+03, .678843E+03, .540991E+03,
     +  .431676E+03, .344951E+03, .276115E+03, .221447E+03,
     +  .178004E+03, .143459E+03, .115968E+03, .937976E+02,
     +  .764077E+02, .625305E+02, .514447E+02, .425783E+02,
     +  .354777E+02, .297979E+02, .252220E+02, .215389E+02,
     +  .185663E+02, .161586E+02, .141997E+02, .125960E+02,
     +  .112753E+02, .101761E+02, .925196E+01, .846537E+01,
     +  .778697E+01, .719391E+01, .667039E+01, .619798E+01,
     +  .577246E+01, .538117E+01, .502247E+01, .469049E+01 /
        DATA (UPDI(I),I=5149,5200) /
     +  .438138E+01, .409155E+01, .381753E+01, .355625E+01,
     +  .330533E+01, .306325E+01, .282928E+01, .260335E+01,
     +  .238575E+01, .217695E+01, .197743E+01, .178848E+01,
     +  .160848E+01, .143888E+01, .127983E+01, .113142E+01,
     +  .993629E+00, .866397E+00, .749585E+00, .642999E+00,
     +  .546335E+00, .459228E+00, .382084E+00, .313372E+00,
     +  .253234E+00, .201188E+00, .156722E+00, .119298E+00,
     +  .883536E-01, .633394E-01, .435093E-01, .284193E-01,
     +  .173450E-01, .965051E-02, .469652E-02, .184992E-02,
     +  .495456E-03, .516744E-04, .000000E+00, .598338E+05,
     +  .476332E+05, .375592E+05, .296118E+05, .233503E+05,
     +  .184107E+05, .145192E+05, .114494E+05, .903094E+04,
     +  .712321E+04, .562026E+04, .443466E+04, .350058E+04 /
        DATA (UPDI(I),I=5201,5252) /
     +  .276367E+04, .218304E+04, .172489E+04, .136384E+04,
     +  .107889E+04, .854253E+03, .676899E+03, .537036E+03,
     +  .426550E+03, .339364E+03, .270440E+03, .216002E+03,
     +  .172929E+03, .138869E+03, .111545E+03, .902496E+02,
     +  .733408E+02, .599222E+02, .492418E+02, .407423E+02,
     +  .339725E+02, .285501E+02, .242006E+02, .207070E+02,
     +  .178837E+02, .155951E+02, .137235E+02, .121866E+02,
     +  .109081E+02, .983610E+01, .892471E+01, .814175E+01,
     +  .745951E+01, .686077E+01, .632357E+01, .584341E+01,
     +  .540493E+01, .500626E+01, .463981E+01, .430123E+01,
     +  .398601E+01, .369051E+01, .341134E+01, .314616E+01,
     +  .289327E+01, .265189E+01, .242167E+01, .220264E+01,
     +  .199496E+01, .179874E+01, .161496E+01, .144171E+01 /
        DATA (UPDI(I),I=5253,5304) /
     +  .128016E+01, .113018E+01, .991618E+00, .864231E+00,
     +  .747751E+00, .641835E+00, .546139E+00, .460222E+00,
     +  .383549E+00, .316337E+00, .257087E+00, .205777E+00,
     +  .161861E+00, .124764E+00, .939209E-01, .687309E-01,
     +  .486555E-01, .329605E-01, .212036E-01, .127206E-01,
     +  .694062E-02, .330056E-02, .126451E-02, .328918E-03,
     +  .345977E-04, .000000E+00, .860397E+05, .681125E+05,
     +  .533678E+05, .418057E+05, .327534E+05, .256559E+05,
     +  .201000E+05, .157445E+05, .123355E+05, .966342E+04,
     +  .757224E+04, .593321E+04, .465065E+04, .364543E+04,
     +  .285887E+04, .224238E+04, .175997E+04, .138182E+04,
     +  .108587E+04, .853834E+03, .672196E+03, .529724E+03,
     +  .418140E+03, .330560E+03, .261912E+03, .207994E+03 /
        DATA (UPDI(I),I=5305,5356) /
     +  .165689E+03, .131996E+03, .105937E+03, .853925E+02,
     +  .692111E+02, .564192E+02, .463117E+02, .383119E+02,
     +  .319461E+02, .268677E+02, .228119E+02, .195488E+02,
     +  .169161E+02, .147706E+02, .130156E+02, .115601E+02,
     +  .103442E+02, .931381E+01, .843252E+01, .766806E+01,
     +  .700091E+01, .640586E+01, .587756E+01, .539826E+01,
     +  .496549E+01, .457025E+01, .420750E+01, .387202E+01,
     +  .355987E+01, .326739E+01, .299213E+01, .273225E+01,
     +  .248678E+01, .225510E+01, .203697E+01, .183226E+01,
     +  .164071E+01, .146303E+01, .129708E+01, .114376E+01,
     +  .100269E+01, .873529E+00, .755833E+00, .649171E+00,
     +  .553036E+00, .466962E+00, .390397E+00, .322688E+00,
     +  .263897E+00, .212573E+00, .168568E+00, .131300E+00 /
        DATA (UPDI(I),I=5357,5408) /
     +  .100159E+00, .745680E-01, .539143E-01, .376679E-01,
     +  .251465E-01, .159168E-01, .937337E-02, .500523E-02,
     +  .231873E-02, .859795E-03, .215569E-03, .229169E-04,
     +  .000000E+00, .125378E+06, .986143E+05, .767037E+05,
     +  .596457E+05, .463857E+05, .360645E+05, .280432E+05,
     +  .218012E+05, .169513E+05, .131779E+05, .102467E+05,
     +  .796650E+04, .619560E+04, .481820E+04, .374859E+04,
     +  .291670E+04, .227075E+04, .176835E+04, .137822E+04,
     +  .107475E+04, .839070E+03, .655682E+03, .513197E+03,
     +  .402262E+03, .316006E+03, .248805E+03, .196507E+03,
     +  .155191E+03, .123490E+03, .986947E+02, .793182E+02,
     +  .641171E+02, .521953E+02, .428271E+02, .354237E+02,
     +  .295559E+02, .248981E+02, .211717E+02, .181808E+02 /
        DATA (UPDI(I),I=5409,5460) /
     +  .157550E+02, .137797E+02, .121484E+02, .107914E+02,
     +  .964639E+01, .867158E+01, .783022E+01, .709996E+01,
     +  .645240E+01, .588101E+01, .536583E+01, .490355E+01,
     +  .448394E+01, .410117E+01, .374943E+01, .342443E+01,
     +  .312222E+01, .284020E+01, .257632E+01, .232938E+01,
     +  .209851E+01, .188317E+01, .168291E+01, .149718E+01,
     +  .132640E+01, .116825E+01, .102337E+01, .891170E+00,
     +  .771137E+00, .662661E+00, .565169E+00, .478028E+00,
     +  .400668E+00, .332452E+00, .272643E+00, .221175E+00,
     +  .176655E+00, .138846E+00, .107143E+00, .809249E-01,
     +  .596149E-01, .426123E-01, .294063E-01, .193637E-01,
     +  .120714E-01, .698640E-02, .365615E-02, .165304E-02,
     +  .594890E-03, .144358E-03, .154998E-04, .000000E+00 /
        DATA (UPDI(I),I=5461,5512) /
     +  .181572E+06, .141905E+06, .109578E+06, .845899E+05,
     +  .653018E+05, .503971E+05, .388962E+05, .300118E+05,
     +  .231588E+05, .178665E+05, .137855E+05, .106349E+05,
     +  .820612E+04, .633148E+04, .488673E+04, .377178E+04,
     +  .291268E+04, .224973E+04, .173895E+04, .134479E+04,
     +  .104109E+04, .806679E+03, .626004E+03, .486481E+03,
     +  .378870E+03, .295720E+03, .231539E+03, .181249E+03,
     +  .142975E+03, .113281E+03, .902596E+02, .723421E+02,
     +  .583962E+02, .475200E+02, .389860E+02, .322688E+02,
     +  .269710E+02, .227586E+02, .193966E+02, .166847E+02,
     +  .144871E+02, .126811E+02, .111855E+02, .992976E+01,
     +  .886572E+01, .795212E+01, .716334E+01, .646789E+01,
     +  .585776E+01, .531092E+01, .482305E+01, .438282E+01 /
        DATA (UPDI(I),I=5513,5564) /
     +  .398358E+01, .361897E+01, .328428E+01, .297534E+01,
     +  .268929E+01, .242387E+01, .217762E+01, .194939E+01,
     +  .173833E+01, .154372E+01, .136471E+01, .120146E+01,
     +  .105148E+01, .915181E+00, .791800E+00, .680655E+00,
     +  .581004E+00, .492154E+00, .413370E+00, .343999E+00,
     +  .283338E+00, .230593E+00, .185596E+00, .147018E+00,
     +  .114556E+00, .875980E-01, .655266E-01, .477772E-01,
     +  .337730E-01, .230281E-01, .149633E-01, .919148E-02,
     +  .523103E-02, .268482E-02, .118594E-02, .414974E-03,
     +  .977878E-04, .105973E-04, .000000E+00, .259437E+06,
     +  .201547E+06, .154567E+06, .118498E+06, .908411E+05,
     +  .696153E+05, .533472E+05, .408677E+05, .313075E+05,
     +  .239769E+05, .183637E+05, .140613E+05, .107683E+05 /
        DATA (UPDI(I),I=5565,5616) /
     +  .824521E+04, .631480E+04, .483620E+04, .370529E+04,
     +  .283924E+04, .217698E+04, .166989E+04, .128216E+04,
     +  .985250E+03, .758178E+03, .584228E+03, .451120E+03,
     +  .349097E+03, .270983E+03, .210271E+03, .164434E+03,
     +  .129162E+03, .102031E+03, .810825E+02, .649015E+02,
     +  .523789E+02, .426234E+02, .349998E+02, .290266E+02,
     +  .243079E+02, .205637E+02, .175608E+02, .151401E+02,
     +  .131610E+02, .115300E+02, .101673E+02, .901829E+01,
     +  .803689E+01, .719399E+01, .645493E+01, .581010E+01,
     +  .523545E+01, .472561E+01, .426816E+01, .385565E+01,
     +  .348119E+01, .313966E+01, .282662E+01, .253893E+01,
     +  .227411E+01, .203039E+01, .180634E+01, .160082E+01,
     +  .141286E+01, .124131E+01, .108607E+01, .944558E+00 /
        DATA (UPDI(I),I=5617,5668) /
     +  .816935E+00, .702289E+00, .599803E+00, .508618E+00,
     +  .427943E+00, .356966E+00, .294965E+00, .241189E+00,
     +  .194812E+00, .155581E+00, .122240E+00, .944378E-01,
     +  .715664E-01, .530261E-01, .382713E-01, .267579E-01,
     +  .180296E-01, .115626E-01, .699993E-02, .391853E-02,
     +  .197317E-02, .852056E-03, .290227E-03, .665682E-04,
     +  .727804E-05, .000000E+00, .364945E+06, .281933E+06,
     +  .214829E+06, .163634E+06, .124621E+06, .948721E+05,
     +  .722157E+05, .549491E+05, .418069E+05, .317969E+05,
     +  .241825E+05, .183860E+05, .139792E+05, .106263E+05,
     +  .807858E+04, .614105E+04, .466953E+04, .355085E+04,
     +  .270154E+04, .205606E+04, .156614E+04, .119381E+04,
     +  .911198E+03, .696375E+03, .533245E+03, .409190E+03 /
        DATA (UPDI(I),I=5669,5720) /
     +  .314949E+03, .242284E+03, .187855E+03, .146305E+03,
     +  .114592E+03, .902998E+02, .716773E+02, .573755E+02,
     +  .463140E+02, .377322E+02, .310528E+02, .258110E+02,
     +  .216766E+02, .183804E+02, .157373E+02, .135880E+02,
     +  .118252E+02, .103601E+02, .913075E+01, .808616E+01,
     +  .719355E+01, .641513E+01, .573954E+01, .514083E+01,
     +  .461247E+01, .414104E+01, .371828E+01, .333681E+01,
     +  .299105E+01, .267632E+01, .238915E+01, .212681E+01,
     +  .188724E+01, .166872E+01, .146984E+01, .128935E+01,
     +  .112586E+01, .979025E+00, .846174E+00, .727257E+00,
     +  .621230E+00, .527157E+00, .444086E+00, .371146E+00,
     +  .307468E+00, .252278E+00, .204793E+00, .164172E+00,
     +  .130097E+00, .101387E+00, .776618E-01, .583268E-01 /
        DATA (UPDI(I),I=5721,5772) /
     +  .428070E-01, .305835E-01, .211498E-01, .140831E-01,
     +  .891429E-02, .531898E-02, .292904E-02, .144726E-02,
     +  .611147E-03, .202800E-03, .453495E-04, .500079E-05,
     +  .000000E+00, .505272E+06, .388310E+06, .294105E+06,
     +  .222657E+06, .168529E+06, .127501E+06, .964405E+05,
     +  .729144E+05, .551170E+05, .416463E+05, .314632E+05,
     +  .237611E+05, .179430E+05, .135454E+05, .102257E+05,
     +  .771811E+04, .582640E+04, .439824E+04, .332142E+04,
     +  .250883E+04, .189642E+04, .143439E+04, .108621E+04,
     +  .823524E+03, .625520E+03, .476082E+03, .363418E+03,
     +  .277221E+03, .213151E+03, .164623E+03, .127865E+03,
     +  .999269E+02, .786688E+02, .624666E+02, .500245E+02,
     +  .404411E+02, .330315E+02, .272552E+02, .227266E+02 /
        DATA (UPDI(I),I=5773,5824) /
     +  .191375E+02, .162750E+02, .139599E+02, .120705E+02,
     +  .105083E+02, .920364E+01, .810080E+01, .716313E+01,
     +  .634970E+01, .564738E+01, .502830E+01, .448485E+01,
     +  .400260E+01, .357251E+01, .318672E+01, .283921E+01,
     +  .252500E+01, .224032E+01, .198217E+01, .174819E+01,
     +  .153638E+01, .134506E+01, .117272E+01, .101776E+01,
     +  .879615E+00, .755539E+00, .645292E+00, .547716E+00,
     +  .461779E+00, .386457E+00, .320818E+00, .263949E+00,
     +  .215045E+00, .173303E+00, .137880E+00, .108414E+00,
     +  .838006E-01, .636433E-01, .473691E-01, .344343E-01,
     +  .243519E-01, .166563E-01, .109599E-01, .684694E-02,
     +  .402646E-02, .218112E-02, .105752E-02, .436775E-03,
     +  .141276E-03, .308384E-04, .342922E-05, .000000E+00 /
        DATA (UPDI(I),I=5825,5876) /
     +  .688823E+06, .526781E+06, .396710E+06, .298611E+06,
     +  .224701E+06, .168997E+06, .127064E+06, .954873E+05,
     +  .717374E+05, .538683E+05, .404401E+05, .303456E+05,
     +  .227665E+05, .170738E+05, .128032E+05, .959811E+04,
     +  .719565E+04, .539389E+04, .404432E+04, .303282E+04,
     +  .227565E+04, .170839E+04, .128389E+04, .965914E+03,
     +  .727944E+03, .549652E+03, .416222E+03, .314905E+03,
     +  .240159E+03, .183975E+03, .141732E+03, .109870E+03,
     +  .858029E+02, .675962E+02, .537132E+02, .430956E+02,
     +  .349406E+02, .286248E+02, .237028E+02, .198251E+02,
     +  .167489E+02, .142743E+02, .122646E+02, .106113E+02,
     +  .923726E+01, .808155E+01, .710376E+01, .625984E+01,
     +  .553488E+01, .489920E+01, .434406E+01, .385410E+01 /
        DATA (UPDI(I),I=5877,5928) /
     +  .341952E+01, .303199E+01, .268506E+01, .237345E+01,
     +  .209307E+01, .184065E+01, .161351E+01, .140942E+01,
     +  .122642E+01, .106279E+01, .916718E+00, .787432E+00,
     +  .672155E+00, .570466E+00, .481121E+00, .403007E+00,
     +  .335047E+00, .276265E+00, .225725E+00, .182599E+00,
     +  .146081E+00, .115341E+00, .899828E-01, .689832E-01,
     +  .519399E-01, .383086E-01, .275810E-01, .193058E-01,
     +  .130594E-01, .849082E-02, .523480E-02, .303369E-02,
     +  .161640E-02, .768987E-03, .310668E-03, .979882E-04,
     +  .209007E-04, .234340E-05, .000000E+00, .925205E+06,
     +  .704271E+06, .527497E+06, .394883E+06, .295495E+06,
     +  .220993E+06, .165211E+06, .123439E+06, .921935E+05,
     +  .688187E+05, .513525E+05, .382990E+05, .285551E+05 /
        DATA (UPDI(I),I=5929,5980) /
     +  .212803E+05, .158554E+05, .118090E+05, .879462E+04,
     +  .654825E+04, .487628E+04, .363133E+04, .270545E+04,
     +  .201647E+04, .150433E+04, .112336E+04, .840206E+03,
     +  .629558E+03, .473035E+03, .355050E+03, .268639E+03,
     +  .204167E+03, .156043E+03, .120012E+03, .929920E+02,
     +  .726994E+02, .573325E+02, .456618E+02, .367559E+02,
     +  .299031E+02, .245939E+02, .204356E+02, .171541E+02,
     +  .145283E+02, .124061E+02, .106689E+02, .923200E+01,
     +  .802927E+01, .701657E+01, .614688E+01, .540348E+01,
     +  .475500E+01, .419156E+01, .369695E+01, .326064E+01,
     +  .287384E+01, .252969E+01, .222259E+01, .194815E+01,
     +  .170281E+01, .148363E+01, .128810E+01, .111405E+01,
     +  .959527E+00, .822570E+00, .702217E+00, .595671E+00 /
        DATA (UPDI(I),I=5981,6032) /
     +  .502359E+00, .420966E+00, .350322E+00, .289313E+00,
     +  .236936E+00, .192245E+00, .154404E+00, .122617E+00,
     +  .960733E-01, .743602E-01, .565346E-01, .421979E-01,
     +  .308390E-01, .219884E-01, .152323E-01, .101892E-01,
     +  .654511E-02, .398178E-02, .227371E-02, .119147E-02,
     +  .556131E-03, .219775E-03, .676196E-04, .141063E-04,
     +  .159452E-05, .000000E+00, .122514E+07, .928448E+06,
     +  .691785E+06, .515149E+06, .383436E+06, .285217E+06,
     +  .212058E+06, .157564E+06, .117020E+06, .868533E+05,
     +  .644350E+05, .477744E+05, .354075E+05, .262274E+05,
     +  .194211E+05, .143744E+05, .106371E+05, .786895E+04,
     +  .582119E+04, .430601E+04, .318624E+04, .235837E+04,
     +  .174697E+04, .129520E+04, .961669E+03, .715231E+03 /
        DATA (UPDI(I),I=6033,6084) /
     +  .533376E+03, .397267E+03, .298285E+03, .224963E+03,
     +  .170617E+03, .130221E+03, .100139E+03, .777057E+02,
     +  .608325E+02, .481045E+02, .384533E+02, .310736E+02,
     +  .253892E+02, .209622E+02, .174867E+02, .147199E+02,
     +  .124944E+02, .106814E+02, .918862E+01, .794510E+01,
     +  .690299E+01, .601238E+01, .525480E+01, .459732E+01,
     +  .402895E+01, .353268E+01, .309730E+01, .271358E+01,
     +  .237424E+01, .207341E+01, .180637E+01, .156931E+01,
     +  .135900E+01, .117273E+01, .100808E+01, .862950E+00,
     +  .735220E+00, .623766E+00, .525800E+00, .440614E+00,
     +  .366844E+00, .303279E+00, .248788E+00, .202354E+00,
     +  .163034E+00, .129999E+00, .102470E+00, .796683E-01,
     +  .611720E-01, .461191E-01, .341222E-01, .247072E-01 /
        DATA (UPDI(I),I=6085,6136) /
     +  .174442E-01, .119582E-01, .790930E-02, .501887E-02,
     +  .301243E-02, .169474E-02, .873303E-03, .399884E-03,
     +  .154586E-03, .464104E-04, .947679E-05, .107986E-05,
     +  .000000E+00, .160029E+07, .120758E+07, .895249E+06,
     +  .663285E+06, .491160E+06, .363449E+06, .268798E+06,
     +  .198657E+06, .146739E+06, .108314E+06, .799079E+05,
     +  .589117E+05, .434107E+05, .319682E+05, .235316E+05,
     +  .173119E+05, .127322E+05, .936016E+04, .688036E+04,
     +  .505665E+04, .371706E+04, .273287E+04, .201059E+04,
     +  .148032E+04, .109138E+04, .805885E+03, .596623E+03,
     +  .441075E+03, .328732E+03, .246091E+03, .185257E+03,
     +  .140353E+03, .107141E+03, .825430E+02, .641631E+02,
     +  .503895E+02, .400099E+02, .321214E+02, .260791E+02 /
        DATA (UPDI(I),I=6137,6188) /
     +  .213992E+02, .177436E+02, .148478E+02, .125292E+02,
     +  .106493E+02, .910833E+01, .783058E+01, .676472E+01,
     +  .585814E+01, .509068E+01, .442795E+01, .385796E+01,
     +  .336291E+01, .293098E+01, .255252E+01, .221988E+01,
     +  .192689E+01, .166853E+01, .144075E+01, .124008E+01,
     +  .106358E+01, .908663E+00, .773073E+00, .654567E+00,
     +  .551887E+00, .462271E+00, .384898E+00, .318375E+00,
     +  .261469E+00, .213044E+00, .172086E+00, .137668E+00,
     +  .108975E+00, .852545E-01, .657668E-01, .500921E-01,
     +  .374469E-01, .274609E-01, .196985E-01, .137706E-01,
     +  .934038E-02, .610769E-02, .382809E-02, .226666E-02,
     +  .125613E-02, .636432E-03, .285859E-03, .108103E-03,
     +  .316785E-04, .633657E-05, .727795E-06, .000000E+00 /
        DATA (UPDI(I),I=6189,6240) /
     +  .206302E+07, .155037E+07, .114378E+07, .843263E+06,
     +  .621324E+06, .457455E+06, .336595E+06, .247478E+06,
     +  .181841E+06, .133511E+06, .979656E+05, .718297E+05,
     +  .526353E+05, .385427E+05, .282082E+05, .206316E+05,
     +  .150836E+05, .110220E+05, .805222E+04, .588098E+04,
     +  .429551E+04, .313775E+04, .229326E+04, .167714E+04,
     +  .122807E+04, .900544E+03, .662032E+03, .485922E+03,
     +  .359576E+03, .267258E+03, .199752E+03, .150260E+03,
     +  .113895E+03, .871407E+02, .672768E+02, .524853E+02,
     +  .414052E+02, .330336E+02, .266561E+02, .217425E+02,
     +  .179230E+02, .149116E+02, .125114E+02, .105739E+02,
     +  .899280E+01, .768761E+01, .660376E+01, .568617E+01,
     +  .491308E+01, .424880E+01, .368035E+01, .318928E+01 /
        DATA (UPDI(I),I=6241,6292) /
     +  .276317E+01, .239199E+01, .206774E+01, .178396E+01,
     +  .153538E+01, .131770E+01, .112725E+01, .960894E+00,
     +  .815897E+00, .689870E+00, .580483E+00, .486364E+00,
     +  .404797E+00, .334873E+00, .275184E+00, .224494E+00,
     +  .181674E+00, .145727E+00, .115750E+00, .909529E-01,
     +  .706179E-01, .540473E-01, .408319E-01, .302642E-01,
     +  .219954E-01, .156294E-01, .108170E-01, .725887E-02,
     +  .469215E-02, .290442E-02, .169628E-02, .925873E-03,
     +  .461176E-03, .203169E-03, .751637E-04, .215058E-04,
     +  .421712E-05, .488173E-06, .000000E+00, .262610E+07,
     +  .196567E+07, .144331E+07, .105902E+07, .776522E+06,
     +  .568925E+06, .416539E+06, .304719E+06, .222761E+06,
     +  .162712E+06, .118767E+06, .866193E+05, .631305E+05 /
        DATA (UPDI(I),I=6293,6344) /
     +  .459750E+05, .334605E+05, .243350E+05, .176889E+05,
     +  .128504E+05, .933210E+04, .677458E+04, .491776E+04,
     +  .356981E+04, .259242E+04, .188367E+04, .137022E+04,
     +  .998065E+03, .728764E+03, .531202E+03, .390381E+03,
     +  .288158E+03, .213889E+03, .159796E+03, .120302E+03,
     +  .914330E+02, .701304E+02, .543644E+02, .426223E+02,
     +  .338003E+02, .271147E+02, .219896E+02, .180242E+02,
     +  .149122E+02, .124423E+02, .104573E+02, .884418E+01,
     +  .751841E+01, .642235E+01, .549865E+01, .472409E+01,
     +  .406182E+01, .349795E+01, .301342E+01, .259532E+01,
     +  .223324E+01, .191886E+01, .164547E+01, .140758E+01,
     +  .120065E+01, .102083E+01, .864838E+00, .729812E+00,
     +  .613260E+00, .512794E+00, .426949E+00, .353074E+00 /
        DATA (UPDI(I),I=6345,6396) /
     +  .290191E+00, .236896E+00, .191963E+00, .154285E+00,
     +  .122891E+00, .969096E-01, .755860E-01, .582395E-01,
     +  .442199E-01, .331340E-01, .243474E-01, .175356E-01,
     +  .123420E-01, .845579E-02, .561332E-02, .358645E-02,
     +  .219221E-02, .126270E-02, .678739E-03, .332327E-03,
     +  .143588E-03, .519712E-04, .145234E-04, .279398E-05,
     +  .325940E-06, .000000E+00, .326065E+05, .351154E+05,
     +  .277561E+05, .219401E+05, .173436E+05, .137110E+05,
     +  .108400E+05, .857088E+04, .677744E+04, .535991E+04,
     +  .423946E+04, .335380E+04, .265370E+04, .210025E+04,
     +  .166272E+04, .131679E+04, .104327E+04, .826993E+03,
     +  .655952E+03, .520673E+03, .413664E+03, .329004E+03,
     +  .262013E+03, .208992E+03, .167017E+03, .133775E+03 /
        DATA (UPDI(I),I=6397,6448) /
     +  .107440E+03, .863043E+02, .698115E+02, .567209E+02,
     +  .463213E+02, .380499E+02, .314616E+02, .262181E+02,
     +  .220123E+02, .186387E+02, .159217E+02, .137221E+02,
     +  .119301E+02, .104582E+02, .923998E+01, .821956E+01,
     +  .735549E+01, .661499E+01, .597261E+01, .540863E+01,
     +  .490947E+01, .445839E+01, .405152E+01, .367650E+01,
     +  .333145E+01, .301079E+01, .271186E+01, .243325E+01,
     +  .217458E+01, .193590E+01, .171728E+01, .151839E+01,
     +  .133843E+01, .117624E+01, .103044E+01, .899614E+00,
     +  .782400E+00, .678002E+00, .584214E+00, .500707E+00,
     +  .426576E+00, .361010E+00, .303275E+00, .252694E+00,
     +  .208644E+00, .170540E+00, .137815E+00, .109928E+00,
     +  .866470E-01, .670974E-01, .510162E-01, .379831E-01 /
        DATA (UPDI(I),I=6449,6500) /
     +  .275995E-01, .194902E-01, .133040E-01, .872262E-02,
     +  .542395E-02, .316866E-02, .170168E-02, .814717E-03,
     +  .330325E-03, .102992E-03, .198868E-04, .118970E-05,
     +  .000000E+00, .596479E+05, .474657E+05, .374085E+05,
     +  .294764E+05, .232286E+05, .183015E+05, .144211E+05,
     +  .113615E+05, .895215E+04, .705266E+04, .555714E+04,
     +  .437823E+04, .345018E+04, .271869E+04, .214293E+04,
     +  .168917E+04, .133205E+04, .105063E+04, .829159E+03,
     +  .654642E+03, .517314E+03, .409095E+03, .323930E+03,
     +  .256806E+03, .203967E+03, .162314E+03, .129509E+03,
     +  .103307E+03, .829819E+02, .669235E+02, .542453E+02,
     +  .442073E+02, .362606E+02, .299628E+02, .249415E+02,
     +  .209295E+02, .177167E+02, .151250E+02, .130254E+02 /
        DATA (UPDI(I),I=6501,6552) /
     +  .113071E+02, .989326E+01, .871412E+01, .772241E+01,
     +  .687724E+01, .614994E+01, .551602E+01, .496019E+01,
     +  .446232E+01, .401811E+01, .361300E+01, .324489E+01,
     +  .290711E+01, .259655E+01, .231103E+01, .204950E+01,
     +  .181114E+01, .159525E+01, .140078E+01, .122641E+01,
     +  .107056E+01, .931554E+00, .807810E+00, .697759E+00,
     +  .600511E+00, .513815E+00, .437243E+00, .369812E+00,
     +  .310671E+00, .259027E+00, .214173E+00, .175446E+00,
     +  .142249E+00, .114003E+00, .901523E-01, .704052E-01,
     +  .540014E-01, .406549E-01, .299645E-01, .215489E-01,
     +  .150528E-01, .101549E-01, .657546E-02, .403281E-02,
     +  .232101E-02, .122564E-02, .575844E-03, .228357E-03,
     +  .694308E-04, .130984E-04, .797294E-06, .000000E+00 /
        DATA (UPDI(I),I=6553,6604) /
     +  .858342E+05, .679275E+05, .532016E+05, .416565E+05,
     +  .326194E+05, .255358E+05, .199923E+05, .156481E+05,
     +  .122492E+05, .958620E+04, .750322E+04, .587158E+04,
     +  .459564E+04, .359640E+04, .281519E+04, .220351E+04,
     +  .172541E+04, .135112E+04, .105863E+04, .829684E+03,
     +  .650804E+03, .510796E+03, .401403E+03, .315773E+03,
     +  .248855E+03, .196468E+03, .155515E+03, .123030E+03,
     +  .980142E+02, .783832E+02, .629966E+02, .508946E+02,
     +  .413811E+02, .338895E+02, .279569E+02, .232451E+02,
     +  .194963E+02, .164895E+02, .140688E+02, .120988E+02,
     +  .104883E+02, .915310E+01, .803782E+01, .709365E+01,
     +  .628735E+01, .558992E+01, .498355E+01, .444508E+01,
     +  .396921E+01, .353945E+01, .315313E+01, .280256E+01 /
        DATA (UPDI(I),I=6605,6656) /
     +  .248403E+01, .219460E+01, .193250E+01, .169616E+01,
     +  .148417E+01, .129490E+01, .112654E+01, .977189E+00,
     +  .844947E+00, .728073E+00, .624845E+00, .534288E+00,
     +  .454134E+00, .383867E+00, .322452E+00, .269005E+00,
     +  .222697E+00, .182802E+00, .148635E+00, .119593E+00,
     +  .950976E-01, .745915E-01, .577682E-01, .439233E-01,
     +  .327671E-01, .239180E-01, .170198E-01, .117571E-01,
     +  .783620E-02, .500895E-02, .302816E-02, .171551E-02,
     +  .889782E-03, .409635E-03, .158596E-03, .469333E-04,
     +  .865622E-05, .538268E-06, .000000E+00, .125152E+06,
     +  .984117E+05, .765218E+05, .594826E+05, .462394E+05,
     +  .359334E+05, .279259E+05, .216962E+05, .168573E+05,
     +  .130939E+05, .101717E+05, .789964E+04, .613599E+04 /
        DATA (UPDI(I),I=6657,6708) /
     +  .476510E+04, .370133E+04, .287468E+04, .223341E+04,
     +  .173520E+04, .134882E+04, .104870E+04, .816002E+03,
     +  .635274E+03, .495152E+03, .386317E+03, .301920E+03,
     +  .236363E+03, .185516E+03, .145494E+03, .114911E+03,
     +  .910932E+02, .725674E+02, .581051E+02, .468200E+02,
     +  .379978E+02, .310614E+02, .255907E+02, .212680E+02,
     +  .178239E+02, .150695E+02, .128427E+02, .110342E+02,
     +  .954494E+01, .830945E+01, .727091E+01, .639056E+01,
     +  .563485E+01, .498304E+01, .440899E+01, .390613E+01,
     +  .345614E+01, .305556E+01, .269574E+01, .237223E+01,
     +  .208134E+01, .182060E+01, .158771E+01, .138062E+01,
     +  .119721E+01, .103528E+01, .892631E+00, .767182E+00,
     +  .657062E+00, .560440E+00, .476256E+00, .402252E+00 /
        DATA (UPDI(I),I=6709,6760) /
     +  .337835E+00, .281934E+00, .233642E+00, .192112E+00,
     +  .156604E+00, .126429E+00, .100985E+00, .797017E-01,
     +  .620303E-01, .476574E-01, .359339E-01, .265737E-01,
     +  .192208E-01, .135462E-01, .926308E-02, .610710E-02,
     +  .385902E-02, .230396E-02, .128790E-02, .658381E-03,
     +  .298507E-03, .113782E-03, .332805E-04, .618816E-05,
     +  .407257E-06, .000000E+00, .181326E+06, .141684E+06,
     +  .109380E+06, .844125E+05, .651429E+05, .502548E+05,
     +  .387689E+05, .298980E+05, .230571E+05, .177757E+05,
     +  .137045E+05, .105627E+05, .814180E+04, .627423E+04,
     +  .483581E+04, .372653E+04, .287250E+04, .221409E+04,
     +  .170735E+04, .131679E+04, .101631E+04, .784758E+03,
     +  .606621E+03, .469352E+03, .363733E+03, .282342E+03 /
        DATA (UPDI(I),I=6761,6812) /
     +  .219714E+03, .170807E+03, .133727E+03, .105077E+03,
     +  .829649E+02, .658374E+02, .525733E+02, .422832E+02,
     +  .342520E+02, .279647E+02, .230318E+02, .191296E+02,
     +  .160302E+02, .135419E+02, .115349E+02, .989349E+01,
     +  .854119E+01, .741260E+01, .646279E+01, .565357E+01,
     +  .496092E+01, .435576E+01, .383000E+01, .336363E+01,
     +  .295221E+01, .258614E+01, .226018E+01, .196992E+01,
     +  .171212E+01, .148389E+01, .128258E+01, .110562E+01,
     +  .950467E+00, .814712E+00, .696104E+00, .592667E+00,
     +  .502489E+00, .424436E+00, .356277E+00, .297353E+00,
     +  .246573E+00, .203016E+00, .165827E+00, .134265E+00,
     +  .107644E+00, .853698E-01, .668868E-01, .516627E-01,
     +  .393835E-01, .294538E-01, .215966E-01, .154821E-01 /
        DATA (UPDI(I),I=6813,6864) /
     +  .108092E-01, .731841E-02, .477397E-02, .298278E-02,
     +  .175913E-02, .970499E-03, .489084E-03, .218394E-03,
     +  .819389E-04, .236498E-04, .439642E-05, .302053E-06,
     +  .000000E+00, .259170E+06, .201307E+06, .154353E+06,
     +  .118306E+06, .906690E+05, .694613E+05, .532096E+05,
     +  .407448E+05, .311978E+05, .238790E+05, .182764E+05,
     +  .139836E+05, .106991E+05, .818365E+04, .626008E+04,
     +  .478761E+04, .366216E+04, .280100E+04, .214309E+04,
     +  .163988E+04, .125560E+04, .961762E+03, .737410E+03,
     +  .565872E+03, .434895E+03, .334752E+03, .258295E+03,
     +  .199060E+03, .154497E+03, .120340E+03, .941787E+02,
     +  .740747E+02, .586234E+02, .467296E+02, .375156E+02,
     +  .303568E+02, .247807E+02, .204019E+02, .169483E+02 /
        DATA (UPDI(I),I=6865,6916) /
     +  .141955E+02, .119902E+02, .101995E+02, .873423E+01,
     +  .752014E+01, .650554E+01, .564748E+01, .491843E+01,
     +  .428638E+01, .374159E+01, .326236E+01, .284321E+01,
     +  .247361E+01, .214745E+01, .185963E+01, .160621E+01,
     +  .138369E+01, .118892E+01, .101892E+01, .870877E+00,
     +  .742182E+00, .630459E+00, .533646E+00, .449773E+00,
     +  .377645E+00, .315073E+00, .261340E+00, .215350E+00,
     +  .176174E+00, .142963E+00, .114981E+00, .915525E-01,
     +  .720987E-01, .560821E-01, .429931E-01, .325224E-01,
     +  .241269E-01, .175422E-01, .124650E-01, .862217E-02,
     +  .578056E-02, .373136E-02, .230544E-02, .134327E-02,
     +  .731470E-03, .363441E-03, .159845E-03, .590300E-04,
     +  .167995E-04, .310825E-05, .221330E-06, .000000E+00 /
        DATA (UPDI(I),I=6917,6968) /
     +  .364656E+06, .281673E+06, .214597E+06, .163426E+06,
     +  .124435E+06, .947059E+05, .720672E+05, .548165E+05,
     +  .416887E+05, .316915E+05, .240886E+05, .183024E+05,
     +  .139049E+05, .105602E+05, .801990E+04, .608897E+04,
     +  .462333E+04, .350990E+04, .266527E+04, .202395E+04,
     +  .153773E+04, .116869E+04, .888984E+03, .676739E+03,
     +  .515885E+03, .393836E+03, .301364E+03, .230274E+03,
     +  .177204E+03, .136843E+03, .106165E+03, .827752E+02,
     +  .649338E+02, .513066E+02, .408280E+02, .327487E+02,
     +  .265010E+02, .216312E+02, .178173E+02, .147991E+02,
     +  .123978E+02, .104618E+02, .888829E+01, .759378E+01,
     +  .651943E+01, .561736E+01, .485641E+01, .420164E+01,
     +  .364158E+01, .315286E+01, .272892E+01, .235828E+01 /
        DATA (UPDI(I),I=6969,7020) /
     +  .203400E+01, .175028E+01, .150251E+01, .128665E+01,
     +  .109907E+01, .936493E+00, .795834E+00, .674336E+00,
     +  .569523E+00, .479267E+00, .401562E+00, .335163E+00,
     +  .277936E+00, .229118E+00, .187617E+00, .152509E+00,
     +  .122954E+00, .982303E-01, .776818E-01, .607474E-01,
     +  .469132E-01, .356956E-01, .267951E-01, .197185E-01,
     +  .142169E-01, .100135E-01, .686249E-02, .455589E-02,
     +  .291017E-02, .177812E-02, .102359E-02, .550194E-03,
     +  .269548E-03, .116773E-03, .424507E-04, .119087E-04,
     +  .218800E-05, .160827E-06, .000000E+00, .504959E+06,
     +  .388029E+06, .293854E+06, .222433E+06, .168328E+06,
     +  .127322E+06, .962806E+05, .727718E+05, .549899E+05,
     +  .415331E+05, .313624E+05, .236714E+05, .178632E+05 /
        DATA (UPDI(I),I=7021,7072) /
     +  .134745E+05, .101628E+05, .766235E+04, .577696E+04,
     +  .435444E+04, .328264E+04, .247451E+04, .186606E+04,
     +  .140755E+04, .106248E+04, .802546E+03, .606971E+03,
     +  .459673E+03, .348895E+03, .264378E+03, .201756E+03,
     +  .154497E+03, .118844E+03, .918699E+02, .714481E+02,
     +  .559698E+02, .441552E+02, .351148E+02, .281742E+02,
     +  .228043E+02, .186280E+02, .153468E+02, .127541E+02,
     +  .106782E+02, .900240E+01, .763332E+01, .650476E+01,
     +  .556383E+01, .477564E+01, .410239E+01, .353076E+01,
     +  .303584E+01, .260991E+01, .224059E+01, .192011E+01,
     +  .164199E+01, .140101E+01, .119264E+01, .101285E+01,
     +  .858064E+00, .725005E+00, .610795E+00, .512881E+00,
     +  .429091E+00, .357401E+00, .296530E+00, .244407E+00 /
        DATA (UPDI(I),I=7073,7124) /
     +  .200237E+00, .162940E+00, .131604E+00, .105409E+00,
     +  .836519E-01, .657012E-01, .510183E-01, .391160E-01,
     +  .295402E-01, .220039E-01, .160624E-01, .114836E-01,
     +  .801721E-02, .544354E-02, .357849E-02, .226197E-02,
     +  .136672E-02, .777321E-03, .412435E-03, .199244E-03,
     +  .850300E-04, .304340E-04, .841543E-05, .153367E-05,
     +  .116084E-06, .000000E+00, .688485E+06, .526478E+06,
     +  .396439E+06, .298369E+06, .224485E+06, .168804E+06,
     +  .126892E+06, .953340E+05, .716008E+05, .537467E+05,
     +  .403320E+05, .302495E+05, .226811E+05, .169980E+05,
     +  .127359E+05, .953847E+04, .714280E+04, .534709E+04,
     +  .400289E+04, .299618E+04, .224324E+04, .167974E+04,
     +  .125856E+04, .943524E+03, .708146E+03, .532137E+03 /
        DATA (UPDI(I),I=7125,7176) /
     +  .400717E+03, .301191E+03, .227989E+03, .173158E+03,
     +  .132096E+03, .101264E+03, .780929E+02, .606631E+02,
     +  .474556E+02, .374248E+02, .297786E+02, .239059E+02,
     +  .193702E+02, .158319E+02, .130547E+02, .108465E+02,
     +  .907551E+01, .763858E+01, .646192E+01, .548762E+01,
     +  .467705E+01, .398959E+01, .341012E+01, .291220E+01,
     +  .248697E+01, .212118E+01, .180626E+01, .153510E+01,
     +  .130194E+01, .110177E+01, .930254E+00, .783554E+00,
     +  .658247E+00, .551360E+00, .460293E+00, .382845E+00,
     +  .316992E+00, .261432E+00, .214165E+00, .174374E+00,
     +  .141001E+00, .113153E+00, .900378E-01, .709747E-01,
     +  .553616E-01, .426865E-01, .324909E-01, .243524E-01,
     +  .179993E-01, .130327E-01, .923896E-02, .639308E-02 /
        DATA (UPDI(I),I=7177,7228) /
     +  .430042E-02, .279921E-02, .175085E-02, .104611E-02,
     +  .587824E-03, .307871E-03, .146667E-03, .616665E-04,
     +  .217360E-04, .592487E-05, .107048E-05, .833026E-07,
     +  .000000E+00, .924840E+06, .703945E+06, .527206E+06,
     +  .394623E+06, .295262E+06, .220786E+06, .165026E+06,
     +  .123274E+06, .920470E+05, .686883E+05, .512366E+05,
     +  .381960E+05, .284637E+05, .211991E+05, .157834E+05,
     +  .117453E+05, .873816E+04, .649827E+04, .483206E+04,
     +  .359222E+04, .267088E+04, .198591E+04, .147732E+04,
     +  .109948E+04, .819096E+03, .610881E+03, .456502E+03,
     +  .340427E+03, .255663E+03, .192634E+03, .145771E+03,
     +  .110842E+03, .847811E+02, .653222E+02, .506825E+02,
     +  .396453E+02, .312910E+02, .249203E+02, .200335E+02 /
        DATA (UPDI(I),I=7229,7280) /
     +  .162478E+02, .132958E+02, .109645E+02, .910691E+01,
     +  .760969E+01, .639160E+01, .538971E+01, .456178E+01,
     +  .386445E+01, .328080E+01, .278298E+01, .236101E+01,
     +  .200081E+01, .169306E+01, .143009E+01, .120561E+01,
     +  .101426E+01, .851392E+00, .712992E+00, .595516E+00,
     +  .495931E+00, .411608E+00, .340340E+00, .280119E+00,
     +  .229633E+00, .186962E+00, .151276E+00, .121549E+00,
     +  .969131E-01, .766068E-01, .599801E-01, .464622E-01,
     +  .355704E-01, .268770E-01, .199921E-01, .146614E-01,
     +  .105293E-01, .740085E-02, .507558E-02, .338224E-02,
     +  .217977E-02, .134905E-02, .797026E-03, .442472E-03,
     +  .228758E-03, .107474E-03, .445257E-04, .154596E-04,
     +  .415491E-05, .744094E-06, .594631E-07, .000000E+00 /
        DATA (UPDI(I),I=7281,7332) /
     +  .122474E+07, .928096E+06, .691470E+06, .514868E+06,
     +  .383186E+06, .284995E+06, .211860E+06, .157388E+06,
     +  .116862E+06, .867136E+05, .643109E+05, .476642E+05,
     +  .353097E+05, .261406E+05, .193442E+05, .143064E+05,
     +  .105768E+05, .781562E+04, .577402E+04, .426431E+04,
     +  .314938E+04, .232580E+04, .171819E+04, .126976E+04,
     +  .939181E+03, .695337E+03, .515768E+03, .381694E+03,
     +  .284470E+03, .212688E+03, .159689E+03, .120472E+03,
     +  .914163E+02, .698781E+02, .537873E+02, .417427E+02,
     +  .326885E+02, .258324E+02, .206083E+02, .165886E+02,
     +  .134744E+02, .110310E+02, .909644E+01, .754725E+01,
     +  .629484E+01, .527143E+01, .443123E+01, .372836E+01,
     +  .314411E+01, .264936E+01, .223305E+01, .188033E+01 /
        DATA (UPDI(I),I=7333,7384) /
     +  .158120E+01, .132747E+01, .111242E+01, .930361E+00,
     +  .776425E+00, .646448E+00, .536809E+00, .444440E+00,
     +  .366711E+00, .301424E+00, .246601E+00, .200932E+00,
     +  .162584E+00, .130726E+00, .104367E+00, .826721E-01,
     +  .649158E-01, .504811E-01, .388318E-01, .295161E-01,
     +  .221385E-01, .163417E-01, .118903E-01, .846905E-02,
     +  .590177E-02, .401122E-02, .264781E-02, .168946E-02,
     +  .103455E-02, .604357E-03, .331469E-03, .169165E-03,
     +  .783856E-04, .320044E-04, .109491E-04, .290206E-05,
     +  .515147E-06, .422374E-07, .000000E+00, .159986E+07,
     +  .120720E+07, .894911E+06, .662983E+06, .490891E+06,
     +  .363209E+06, .268585E+06, .198468E+06, .146570E+06,
     +  .108164E+06, .797750E+05, .587938E+05, .433062E+05 /
        DATA (UPDI(I),I=7385,7436) /
     +  .318755E+05, .234495E+05, .172392E+05, .126679E+05,
     +  .930328E+04, .683007E+04, .501221E+04, .367779E+04,
     +  .269818E+04, .197994E+04, .145324E+04, .106744E+04,
     +  .784717E+03, .577893E+03, .424515E+03, .314047E+03,
     +  .233050E+03, .173654E+03, .130010E+03, .978979E+02,
     +  .742602E+02, .567215E+02, .436844E+02, .339499E+02,
     +  .266287E+02, .210865E+02, .168499E+02, .135884E+02,
     +  .110456E+02, .904469E+01, .745243E+01, .617314E+01,
     +  .513439E+01, .428704E+01, .358287E+01, .300148E+01,
     +  .251261E+01, .210417E+01, .176063E+01, .147138E+01,
     +  .122778E+01, .102275E+01, .850343E+00, .705511E+00,
     +  .583992E+00, .482124E+00, .396829E+00, .325497E+00,
     +  .265954E+00, .216268E+00, .175142E+00, .140835E+00 /
        DATA (UPDI(I),I=7437,7488) /
     +  .112523E+00, .892566E-01, .702397E-01, .547847E-01,
     +  .423112E-01, .323189E-01, .243886E-01, .181572E-01,
     +  .132997E-01, .960039E-02, .678147E-02, .468503E-02,
     +  .315552E-02, .206322E-02, .130329E-02, .789601E-03,
     +  .456075E-03, .247127E-03, .124504E-03, .569051E-04,
     +  .229018E-04, .772227E-05, .201904E-05, .355277E-06,
     +  .298627E-07, .000000E+00, .206257E+07, .154996E+07,
     +  .114342E+07, .842939E+06, .621036E+06, .457198E+06,
     +  .336366E+06, .247275E+06, .181661E+06, .133351E+06,
     +  .978235E+05, .717036E+05, .525236E+05, .384437E+05,
     +  .281206E+05, .205540E+05, .150151E+05, .109614E+05,
     +  .799864E+04, .583364E+04, .425370E+04, .310082E+04,
     +  .226065E+04, .164834E+04, .120262E+04, .878045E+03 /
        DATA (UPDI(I),I=7489,7540) /
     +  .642133E+03, .468337E+03, .343990E+03, .253427E+03,
     +  .187457E+03, .139313E+03, .104125E+03, .784002E+02,
     +  .594398E+02, .454409E+02, .350566E+02, .272981E+02,
     +  .214619E+02, .170290E+02, .136370E+02, .110088E+02,
     +  .895293E+01, .732694E+01, .602840E+01, .498050E+01,
     +  .413104E+01, .342966E+01, .285440E+01, .237401E+01,
     +  .197543E+01, .164256E+01, .136427E+01, .113153E+01,
     +  .936964E+00, .774438E+00, .638781E+00, .525672E+00,
     +  .431438E+00, .353021E+00, .287846E+00, .233781E+00,
     +  .188950E+00, .152080E+00, .121524E+00, .964764E-01,
     +  .760328E-01, .594385E-01, .460478E-01, .353183E-01,
     +  .267869E-01, .200674E-01, .148286E-01, .107774E-01,
     +  .771770E-02, .540618E-02, .370249E-02, .247111E-02 /
        DATA (UPDI(I),I=7541,7592) /
     +  .160033E-02, .100073E-02, .599840E-03, .342564E-03,
     +  .183386E-03, .912103E-04, .411255E-04, .163179E-04,
     +  .542466E-05, .139942E-05, .244128E-06, .210205E-07,
     +  .000000E+00, .262561E+07, .196524E+07, .144292E+07,
     +  .105867E+07, .776212E+06, .568650E+06, .416294E+06,
     +  .304502E+06, .222568E+06, .162541E+06, .118615E+06,
     +  .864846E+05, .630112E+05, .458694E+05, .333670E+05,
     +  .242523E+05, .176158E+05, .127858E+05, .927504E+04,
     +  .672420E+04, .487327E+04, .353054E+04, .255776E+04,
     +  .185306E+04, .134319E+04, .974180E+03, .707650E+03,
     +  .512555E+03, .373867E+03, .273516E+03, .200888E+03,
     +  .148234E+03, .110001E+03, .822345E+02, .619013E+02,
     +  .469870E+02, .359936E+02, .278323E+02, .217307E+02 /
        DATA (UPDI(I),I=7593,7644) /
     +  .171245E+02, .136207E+02, .109220E+02, .882317E+01,
     +  .717299E+01, .586282E+01, .481189E+01, .396518E+01,
     +  .327047E+01, .270438E+01, .223481E+01, .184786E+01,
     +  .152694E+01, .126048E+01, .103916E+01, .855364E+00,
     +  .702833E+00, .576323E+00, .471497E+00, .384700E+00,
     +  .312916E+00, .253623E+00, .204744E+00, .164469E+00,
     +  .131558E+00, .104463E+00, .824008E-01, .645169E-01,
     +  .501009E-01, .385507E-01, .293629E-01, .221117E-01,
     +  .164439E-01, .120598E-01, .869668E-02, .617778E-02,
     +  .429121E-02, .291325E-02, .192661E-02, .123577E-02,
     +  .764964E-03, .453627E-03, .256142E-03, .135475E-03,
     +  .665246E-04, .295942E-04, .115795E-04, .379624E-05,
     +  .966490E-06, .167175E-06, .147341E-07, .000000E+00 /
C-----------------------------------------------------------------------
C
      Dr = DrI
      Fl = FlI
      Al = AlI
      DO I=1,6
         Amass(I) = AmassI(I)
      ENDDO
      Iorder = Nint(Dr)
      Nfl = Nint(Fl)
      Alambda = Al
C
      NX = NxI
      NT = NTI
      NfMx = NfMxI
C
      QINI = QINII
      QMAX = QMAXI
      DO I=0,NT
         QL(I) = QLI(I)
      ENDDO
C
      XMIN = XMINI
      DO I=0,NX
         XV(I) = XVI(I)
      ENDDO
C
      Do 11 Iq = 0, NT
         QL(Iq) = Log (QL(Iq) /Al)
   11 Continue
C
C                  Since quark = anti-quark for nfl>2 at this stage, 
C                  we Read  out only the non-redundent data points
C     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 

      Nblk = (NX+1) * (NT+1)
      Npts =  Nblk  * (NfMx+3)
      DO I=1,Npts
         UPD(I) = UPDI(I)
      ENDDO
C
      Return
C                        ****************************
      End
