/* This file is part of the KDE project
   Copyright (C) 2006 KovoKs <info@kovoks.nl>
   Copyright (C) 2006 Frode M. Døving <frode@lnix.net>

   Original copied from showfoto:
    Copyright 2005 by Gilles Caulier <caulier.gilles@free.fr>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

// QT includes.

#include <qlayout.h>
#include <qvbox.h>
#include <qvgroupbox.h>
#include <qhgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qwhatsthis.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>

// KDE includes.

#include <klocale.h>
#include <kdialog.h>
#include <kdebug.h>
#include <kconfig.h>
#include <kuser.h>
#include <kapplication.h>
#include <klineedit.h>
#include <kmessagebox.h>
#include <kpassdlg.h>
#include <ktabwidget.h>
#include <kemailsettings.h>
#include <kwallet.h>
#include <knuminput.h>
using KWallet::Wallet;

// Local includes.
#include "global.h"
#include "setupaccount.h"

namespace Mailody {

class SetupAccountPriv
{
public:
    QButtonGroup*   safeImap;
    KLineEdit*      imapServer;
    KLineEdit*      userName;
    KLineEdit*      homePage;
    KPasswordEdit*  password;
    KIntNumInput*   checkInt;
};

SetupAccount::SetupAccount(QWidget* parent )
           : QWidget(parent)
{
    d = new SetupAccountPriv;

    QVBoxLayout *mainLayout = new QVBoxLayout(parent);
    QGridLayout* mainGrid = new QGridLayout(this,1,1,2,2);
    KTabWidget* tabWidget = new KTabWidget(this);
    mainGrid->addWidget( tabWidget, 0, 0 );
    mainGrid->setRowStretch( 0, 0 );


    // ------------- page 1 -------------------------- //

    QWidget* page1 = new QWidget(this);
    QGridLayout* m2 = new QGridLayout(page1,4,2,5,5);

    QLabel *l4 = new QLabel(i18n("IMAP-server:") + ' ', page1 );
    m2->addWidget(l4,0,0);
    l4->setAlignment( Qt::AlignRight | Qt::AlignVCenter );
    QWhatsThis::add( l4, i18n("Indicate the IMAP-server, if you want to "
                              "connect to a non-standard port for a chosen "
                              "Safety, you can add \":port\" to indicate "
                              "that. For example: \"imap.provider.nl:144\"") );
    d->imapServer = new KLineEdit(page1);
    m2->addWidget(d->imapServer,0,1);
    l4->setBuddy(d->imapServer);

    QLabel *l5 = new QLabel(i18n("Safety:") + ' ', page1);
    m2->addWidget(l5,1,0);
    l5->setAlignment( Qt::AlignRight | Qt::AlignVCenter );
    QWhatsThis::add( l5, i18n("SSL is safe IMAP over port 993, TLS "
                              "will operate on 143 and switch to a secure "
                              "connection, directly after connecting, None "
                              "will connect to 143 but will not switch to a "
                              "secure connection. This setting is not "
                              "recommended.") );
    d->safeImap = new QButtonGroup(3, Qt::Horizontal, page1);
    d->safeImap->setExclusive(true);
    d->safeImap->setInsideMargin(3);
    new QRadioButton(i18n("None"), d->safeImap);
    QRadioButton* sslRadioI = new QRadioButton(i18n("SSL"), d->safeImap);
    QRadioButton* tlsRadioI = new QRadioButton(i18n("TLS"), d->safeImap);
    m2->addWidget(d->safeImap,1,1);
    l5->setBuddy(d->safeImap);

    QLabel *l6 = new QLabel(i18n("Username:") + ' ', page1 );
    m2->addWidget(l6,2,0);
    l6->setAlignment( Qt::AlignRight | Qt::AlignVCenter );
    QWhatsThis::add( l6, i18n("The username") );
    d->userName = new KLineEdit(page1);
    m2->addWidget(d->userName,2,1);
    l6->setBuddy(d->userName);

    QLabel *l7 = new QLabel(i18n("Password:") + ' ', page1 );
    m2->addWidget(l7,3,0);
    l7->setAlignment( Qt::AlignRight | Qt::AlignVCenter );
    QWhatsThis::add( l7, i18n("The password") );
    d->password = new KPasswordEdit(page1);
    m2->addWidget(d->password,3,1);
    l7->setBuddy(d->password);

    QSpacerItem* spacer2 = new QSpacerItem( 20, 20, QSizePolicy::Minimum,
                                           QSizePolicy::Expanding );
    m2->addItem( spacer2, 4, 1 );

    tabWidget->addTab(page1,i18n("IMAP server"));

    // -------------- page 2 ---------------------- //

    QWidget* page2 = new QWidget(this);
    QGridLayout* m1 = new QGridLayout(page2,3,2,5,5);

    QLabel *l3 = new QLabel(i18n("Favorite Website:") + ' ', page2);
    m1->addWidget(l3,0,0);
    l3->setAlignment( Qt::AlignRight | Qt::AlignVCenter );
    QWhatsThis::add( l3, i18n("Indicate your favorite website") );
    d->homePage = new KLineEdit(page2);
    m1->addWidget(d->homePage,0,1);
    l3->setBuddy(d->homePage);

    QLabel *l8 = new QLabel(i18n("Check Interval:") + ' ', page2);
    m1->addWidget(l8,1,0);
    l8->setAlignment( Qt::AlignRight | Qt::AlignVCenter );
    QWhatsThis::add( l8, i18n("Set IMAP check interval in minutes. "
                              "0 min disables interval checking. ") );
    d->checkInt = new KIntNumInput(page2);
    d->checkInt->setRange(0,60,1,true);
    d->checkInt->setSuffix(' ' + i18n("min"));
    m1->addWidget(d->checkInt,1,1);
    l8->setBuddy(d->checkInt);

    QSpacerItem* spacer1 = new QSpacerItem( 20, 20, QSizePolicy::Minimum,
                                           QSizePolicy::Expanding );
    m1->addItem( spacer1, 2, 1 );

    tabWidget->addTab(page2,i18n("Misc."));

    mainLayout->addWidget(this);

    //------------------------------------------------/

    readSettings();

    if(!Global::cryptoConnectionSupported())
    {
        tlsRadioI->setEnabled(false);
        sslRadioI->setEnabled(false);
        d->safeImap->setButton(0);
    }
}

SetupAccount::~SetupAccount()
{
    delete d;
}

void SetupAccount::applySettings()
{
    KConfig* config = kapp->config();
    config->setGroup("General");
    config->writeEntry("imapServer", d->imapServer->text());
    config->writeEntry("userName", d->userName->text());
    config->writeEntry("safeImap", d->safeImap->selectedId());
    QString hp = d->homePage->text();
    if (!hp.startsWith("http://") && !hp.isEmpty())
        hp = "http://" + hp;
    config->writeEntry("homePage", hp);
    config->writeEntry("checkInt", d->checkInt->value());
    config->sync();

    Wallet* wallet = Wallet::openWallet(Wallet::NetworkWallet(), this->winId());
    if (wallet && wallet->isOpen())
    {
        if (!wallet->hasFolder("mailody"))
            wallet->createFolder( "mailody" );

        wallet->setFolder( "mailody" );
        wallet->writePassword("account1", d->password->password());
    }
}

void SetupAccount::readSettings()
{
    KConfig* config = kapp->config();
    KUser* currentUser = new KUser();
    KEMailSettings esetting;

    config->setGroup("General");
    d->imapServer->setText(config->readEntry("imapServer",
                           esetting.getSetting(KEMailSettings::InServer)));
    d->userName->setText(config->readEntry("userName",
                         currentUser->loginName()));
    d->homePage->setText(config->readEntry("homePage", "http://www.mailody.net"));
    d->safeImap->setButton(config->readNumEntry("safeImap", 2));
    d->checkInt->setValue(config->readNumEntry("checkInt", 1));

    QString pass,smtpPass;
    Wallet* wallet = Wallet::openWallet(Wallet::NetworkWallet(), this->winId());
    if (!wallet)
    {
        d->password->setEnabled(false);
        KMessageBox::information(0,i18n("Mailody could not access KWallet, "
            "if you want to store the password permanently then you have to "
            "activate it. If you don't "
            "want to use KWallet, check the box below en enjoy the dialogs."),
            i18n("No KWallet"), "warning_kwallet_disabled");
    }
    else if (wallet->isOpen() && wallet->hasFolder("mailody"))
    {
        wallet->setFolder( "mailody" );
        wallet->readPassword("account1", pass);
    }
    d->password->insert(pass);
}

}

//#include "setupaccount.moc"
