/* This file is part of the KDE project

   Copyright (C) 2006-2007 KovoKs <info@kovoks.nl>
   Copyright (C) 2006-2007 Frode M. Døving <frode@lnix.net>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <kmainwindow.h>
#include <kurl.h>
#include <khtml_part.h>

#include "imapmanager.h"
#include "mailboxlistview.h"
#include "headerlistview.h"

class KListViewSearchLine;
class KSqueezedTextLabel;
class KToggleAction;
class KTabWidget;
class KActionMenu;
class QToolButton;

namespace Mailody {

class DB;
class MailBoxListView;
class MailBoxListViewItem;
class ColorQuotes;
class ToolTip;

/**
 * @class MainWindow
 * This is one of the two main interfaces of Mailody. The class is pretty
 * crowded with methods, but mostly internal ones.
 * @author Tom Albers <tomalbers@kde.nl>
 */
class MainWindow : public KMainWindow
{
  Q_OBJECT

  public:
    /**
     * Contructor
     */
      MainWindow();

    /**
     * Destructor
     */
    ~MainWindow();

    protected:
            bool queryClose();

    private:
        void calculateChildMessageCount(MailBoxListViewItem* mailbox,
                                        int offset=0);
        bool addTag( const QString& tag);
        void addTag(HeaderListViewItem* r, const QString& tag, bool=false);
        bool removeTag( const QString& tag);
        void removeTag(HeaderListViewItem* item, const QString& tag, bool=false);
        bool moveMessage(const QString&);
        void moveMessage(HeaderListViewItem* item, const QString& destBox,
                             bool=false);
        void setUserTag(int i);
        QString retrieveMailboxName(QListViewItem* item);
        void startupSetup();
        QString quote(const QString& text, bool stripSig=true);
        void contextMenuHeaders(QListViewItem*, const QPoint &);
        void showMessage();
        void setActionStates();
        void setStatusBarStates();
        void messageMenu(KActionMenu* am);

        QSplitter                           *m_first;
        QSplitter                           *m_second;
        QHBox                               *m_right;

        DB                                  *m_db;
        ImapManager                         *m_imapmanager;
        KTabWidget                          *m_tabWidget;
        QToolButton                         *m_closeButton;

        MailBoxListView                     *m_mailboxList;
        QMap<QString, MailBoxListViewItem*> m_mailboxMap;
        QMap<QPair<QString,int>, HeaderListViewItem*>      m_headerMap;
        QMap<QString, HeaderListViewItem*>  m_threadMap;

        HeaderListView                      *m_headerList;
        KListViewSearchLine                 *m_searchLine;

        ToolTip                             *m_tooltip;

        // Tab Actions
        KAction                             *m_closeAction;
        KToggleAction                       *m_plainTextAction;
        KToggleAction                       *m_sourceAction;
        KToggleAction                       *m_fixedfontAction;
        KToggleAction                       *m_externalImageAction;

        // Mailody actions
        KAction                             *m_checkNowAction;

        // Mailbox actions
        KAction                             *m_prevUnreadAction;
        KAction                             *m_nextUnreadAction;
        KAction                             *m_syncAction;
        KAction                             *m_expungeAction;
        KAction                             *m_selectAllAction;
        KToggleAction                       *m_childSortAction;
        KToggleAction                       *m_hideDeletedAction;

        // Message actions
        KAction                             *m_msgNewAction;
        KActionMenu                         *m_msgNewActionMenu;
        KAction                             *m_msgZoomInAction;
        KAction                             *m_msgZoomOutAction;
        KAction                             *m_msgSaveAction;
        KAction                             *m_msgPrintAction;
        KAction                             *m_msgReplyAction;
        KAction                             *m_msgForwardAction;
        KActionMenu                         *m_msgForwardActionMenu;
        KAction                             *m_msgReEditAction;
        KToggleAction                       *m_msgDelAction;
        KAction                             *m_msgUser0Action;
        KAction                             *m_msgUser1Action;
        KAction                             *m_msgUser2Action;
        KAction                             *m_msgUser3Action;
        KAction                             *m_msgUser4Action;
        KAction                             *m_msgUser5Action;
        KToggleAction                       *m_relatedAction;

        QMap<int,QString>                   m_recentList;
        QString                             m_lastMessage;
        QTimer*                             m_statusTimer;
        QTimer*                             m_checkMailTimer;

        QStringList                         m_addheaderlist_val;

        bool                                m_idlePossible;
        KSqueezedTextLabel*                 m_statusText;

    private slots:

        void slotSyncMailBoxList();
        void slotFillMailBoxList();
        void slotPopulateMailBoxList(const QStringList&);
        void slotDelMailBox(const QString& box);
        void slotAddMailBox(const QString& box);

        void slotSetup();
        void slotNotifications();
        void slotOpenComposer(
                                const QString& address=QString::null,
                                const QString& files=QString::null,
                                const QString& mb="Inbox"
                             );

        void slotNewMessage(const QString& to=QString::null);
        void slotNewMessageMenu();
        void slotNewMessageMenuSelected(int i);
        void slotForwardMessage(const QString& to=QString::null);
        void slotForwardMessageMenu();
        void slotForwardMessageMenuSelected(int i);
        void slotReEditMessage(const QString& to=QString::null);
        void slotReplyMessage();
        void slotSelectMessage();

        void slotNextUnread();
        void slotSyncMailBox();
        void slotExpungeMailBox();
        void slotSelectMailBox(bool clear = true);
        void slotCheckMail();
        void slotStartCheckMailTimer();

        void slotPopulateHeaderList(const QString& mb,
                                    const QStringList& values);
        void slotAddHeaderList(const QString& mailbox,
                               const QStringList& values);
        void slotAddHeaderList_process(int level=1);

        void slotShowMessage();
        void slotMouseClickInHeaders( int button, QListViewItem* item=0L,
                                      const QPoint& pos=QPoint());

        void slotNewTab();
        void slotDeleteTab(QWidget*);
        void slotDeleteTab();
        void slotCurrentTabChanged(QWidget*);
        void slotSelectMB( const QString& );
        void slotUpdateTabTitle(const QString&);
        void slotTabScrollUp();
        void slotTabScrollDown();
        void slotTabScrollPageUp();
        void slotTabScrollPageDown();

        void slotContextMenuTab(QWidget*, const QPoint &);
        void slotContextMenuMailbox(KListView*, QListViewItem*, const QPoint &);
        void slotDropped(QDropEvent*);

        void slotUpdateMessageCount(const QString&, int);
        void slotUpdateUnseenMessageCount(const QString&, int);
        void slotSelectAllMessages();
        void slotAllMessages(const QString&);
        void slotSortOnYoungestChild();
        void slotHideDeleted();

        void slotToggleDelete();
        void slotToggleHTML();
        void slotToggleSource();
        void slotToggleFixedFont();
        void slotToggleExternalImage();
        void slotUser0();
        void slotUser1();
        void slotUser2();
        void slotUser3();
        void slotUser4();
        void slotUser5();

        void slotSearchLineClear();
        void slotSearchLineChange(const QString& newText);
        void searchLineUpdate();
        void slotSearchLineUpdateClear();

        void slotUpdateStatusBar(const QString&);
        void slotUpdateStatusBarRestoreMouse(const QString& text);
        void slotSimpleMessageStatusBar(const QString& text);
        void slotClearStatusBar();
        void slotStatusBarReady();
        void slotStatusBarClicked(int i);
        void slotSave();
        void slotPrint();
        void slotZoomIn();
        void slotZoomOut();
        void slotScrollBottom();
        void slotIsolateItem();
        void slotOpenURLInNewTab(const QString&);
        void slotCapableResult(const QString& something, bool possible);
        void slotQuit();
};

}

#endif
