/*
 * Po wicej informacji zajyj do rozdziau o lib/testclient.c, gdy
 * podstawa dokumentacji na nim si opiera.
 *
 */ 
 
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/select.h>
#include <sys/time.h>
#include <sys/types.h>
#include <signal.h>

/*
 * Inkludujemy nagwek libtlen
 *
 */

#include "libtlen.h"

int main (int argc, char **argv)
{
	/*
	 * Deklarujemy struktur sesji
	 *
	 */ 
	 
	struct tlen_session *sesja;
	struct tlen_event *event;
	struct timeval tv;

	tlen_setdebug(0);

	if (argc==5) { 
	    /*
	     * Inicjujemy sesj
	     *
	     */
	    sesja = tlen_init();
	    /*
	     * Ustawiamy uytkownika i haso z parametru programu
	     *
	     */
	    tlen_set_auth(sesja,argv[1],argv[2]);
	    /*
	     * czenie z hubem ma przebiega jako nieblokowalne
	     *
	     */
	    tlen_set_hub_blocking(sesja,0);
	    /*
	     * Okej, czymy
	     *
	     */
	    tlen_login(sesja);
	} else {
            printf("Usage: %s login password user message\n",argv[0]);
            return 1;
        }
	
	// tutaj jest obserwowany socket
	while ((!sesja->error))
	{
		fd_set rd, wr;
		int retval;

		tv.tv_sec = 60;
		tv.tv_usec = 0;

		FD_ZERO (&rd);
		FD_ZERO (&wr);

		/*
		 * Ustawiamy opcje monitorowania deskryptorw
		 *
		 */
		
		if ((sesja->check & TLEN_CHECK_READ))
			FD_SET (sesja->fd, &rd);
		if ((sesja->check & TLEN_CHECK_WRITE))
			FD_SET (sesja->fd, &wr);

		if ((retval = select (sesja->fd + 1, &rd, &wr, NULL, &tv) == -1))
		{
			perror ("select");
		}
		else if (sesja && (FD_ISSET (sesja->fd, &rd) || FD_ISSET (sesja->fd, &wr)))
		{
			/*
			 * Sprawdzamy co si zmienio na gniedzie
			 *
			 */
			tlen_watch_fd (sesja);
			/*
			 * Ptla obsugi zdarze
			 *
			 */
			while ((event=tlen_getevent(sesja))!=NULL) {
				switch (event->type)
				{
					/*
					 * Poczony! Pobieramy id.
					 *
					 */
					case TLEN_EVENT_NOWGETID:
					{
						tlen_getid(sesja);
						break;
					}
					/*
					 * Logujemy si
					 *
					 */
					case TLEN_EVENT_GOTID:
					{
						tlen_authorize(sesja);
						break;
					}
					/* 
					 * Udao si - pobieramy ksik adresow
					 *
					 */
					case TLEN_EVENT_AUTHORIZED:
					{
						tlen_getroster(sesja);
						break;
					}
					/*
					 * Ups - co nie wyszo. Wychodzimy
					 *
					 */
					case TLEN_EVENT_UNAUTHORIZED:
					{
						exit(0);
						break;
					}
					/*
					 * Ksika adresowa si odebraa (nie obsugujemy poszczeglnych elementw, bo nie ma po co. 
					 * Moemy wic wysa wiadomo (TLEN_MESSAGE, nie TLEN_CHAT), a nastpnie si rozczy
					 *
					 */
					case TLEN_EVENT_ENDROSTER:
					{
						tlen_sendmsg(sesja,argv[3],argv[4],TLEN_MESSAGE);
						tlen_presence_disconnect (sesja);
						tlen_freesession (sesja);				
						break;
					}

				}
				/*
				 * Zwalniamy zdarzenie
				 *
				 */
				tlen_freeevent(event);
			}	/* while(event=tlen_getevent(sesja)) */
		}
	}
	return 0;
}
