/*  tiffep - Ti File Format Engine & Proxy
 *  Copyright (C) 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIFFEP_SHM__
#define __TIFFEP_SHM__

#include "tiffep.h"


#if defined(__LINUX__)
# define SHM_NAME "/tmp"
#elif defined(__WIN32__)
# define SHM_NAME "TiFFEP"
#endif

/*****************************/
/* Shared memory abstraction */
/*****************************/

#if defined(__LINUX__)
  typedef int ShmId;		// Under Unix, we have an 'int'
#elif defined(__WIN32__)
  typedef HANDLE ShmId;		// Under Windows, we have a HANDLE
#endif

struct Shm_
{
  int size;		// segment size
  ShmId id;		// segment id
  void *addr;	// address of segment
};
typedef struct Shm_ TiffepShm;

#if defined(__WIN32__)
#define SHM_RDONLY	FILE_MAP_READ
#define SHM_WRONLY      FILE_MAP_WRITE
#define SHM_RDWR	FILE_MAP_ALL_ACCESS
#elif defined(__LINUX__)
//#define SHM_RDONLY	
#define SHM_WRONLY      0
#define SHM_RDWR        0
#endif


/*************/
/* Functions */
/*************/


/* 
   Create a Shared Memory Segment 
   - name: name of the shm object
   - size: the size of the segment
   - option: not used yet
   - s: a returned shm identifier if successfully created
   Returns 0 if successful.
*/
TIEXPORT
int shm_create(TiffepShm *s, const char* name, int size, int option);


/*
   Attach a Shared Memory Segment
   - s: the identifier returned by the shm_create function
   - option: not used yet
*/
TIEXPORT
int shm_attach(TiffepShm *s, int option);


/*
   Detach a Shared Memory Segment
   - s: the shm identifier
   Return 0 if successful.
*/
TIEXPORT
int shm_detach(TiffepShm *s);

/*
   Destroy a Shared Memory Segment (if no longer used)
   - s: the shm identifier
   Return 0 if successful.
*/
TIEXPORT
int shm_destroy(TiffepShm *s);

/*
  Detect if the shm already exists
*/
TIEXPORT
int shm_is_exist();

#endif

