unit libTI_cables;

interface

const
  DFLT_TIMEOUT = 20;
  DFLT_DELAY = 10;
  LPT3 = $3BC;
  LPT1 = $378;
  LPT2 = $278;
  TTY0 = 'COM1';
  TTY1 = 'COM2';
  TTY2 = 'COM3';
  TTY3 = 'COM4';
  LINK_TGL = 1;
  LINK_SER = 2;
  LINK_PAR = 3;

type

  PByte = ^Byte;
  PWord = ^Word;
  PInteger = ^Integer;

  TInitPort = function(): Integer; stdcall;
  TOpenPort  = function(): Integer; stdcall;
  TPut       = function(data: Byte): Integer; stdcall;
  TGet       = function(data: PByte): Integer; stdcall;
  TProbePort = function(): Integer; stdcall;
  TClosePort = function(): Integer; stdcall;
  TTermPort  = function(): Integer; stdcall;
  TCheckPort = function(status: PInteger): Integer; stdcall;

  TLinkCable = record
    InitPort:  TInitPort;
    OpenPort:  TOpenPort;
    Put:       TPut;
    Get:       TGet;
    ProbePort: TProbePort;
    ClosePort: TClosePort;
    TermPort:  TTermPort;
    CheckPort: TCheckPort;
  end;
  PLinkCable = ^TLinkCable;

function ticable_get_version(): PChar; stdcall; external 'libti_cables.dll';

procedure ticable_set_timeout(timeout_v: integer); stdcall; external 'libti_cables.dll';
function ticable_get_timeout(): integer; stdcall; external 'libti_cables.dll';
procedure ticable_set_delay(delay_v: integer); stdcall; external 'libti_cables.dll';
function ticable_get_delay(): integer; stdcall; external 'libti_cables.dll';
procedure ticable_set_baudrate(br: integer); stdcall; external 'libti_cables.dll';
function ticable_get_baudrate(): integer; stdcall; external 'libti_cables.dll';
procedure ticable_set_io_address(io_addr: longword); stdcall; external 'libti_cables.dll';
function ticable_get_io_address():longword; stdcall; external 'libti_cables.dll';
procedure ticable_set_io_device(dev: PChar); stdcall; external 'libti_cables.dll';
function ticable_get_io_device(): PChar; stdcall; external 'libti_cables.dll';
procedure ticable_set_cable(link_type: integer; lc: PLinkCable); stdcall; external 'libti_cables.dll';

function ticable_get_error(err_num: Integer; error_msg: PChar): Integer; stdcall; external 'libti_cables.dll';

procedure FaireQuelquechose; external 'MALIB.DLL';
//function BoiteMessage(HWnd: Integer; Text, Caption: PChar; Flags: Integer): Integer;
//  stdcall; external 'user32.dll' name 'MessageBoxA';

implementation

end.
