/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/
/*! \file TeApplicationUtils.h
    This contains some utilitary functions to deal with TerraLib databases
*/
#ifndef  __TERRALIB_INTERNAL_APPLICATIONUTILS_H
#define  __TERRALIB_INTERNAL_APPLICATIONUTILS_H

#include "TeThemeApplication.h"
#include "TeVisual.h"
#include "TeDatabase.h"

#include <string>
#include <vector>
#include <set>
using namespace std;

struct ObjectInfo
{
	int	status_;						// collection: c_object_status
	map<string, int> uniqueMap_;	// uniqueId to grid status (collection: grid_status)
};

//! Breaks a collection of strings into a series of IN clauses to be used in query expressions
/*
	\params begin Iterator that p oints to the beginning of the collection
	\params end Iterator that points to the end of the collection
	\param db pointer to the database where the query expression will be applied
	\param addPlicae flat to indicate that the character ' should enclose each string
*/
template <typename Iterator>
vector<string>
generateInClauses(Iterator& begin, Iterator& end, TeDatabase* db, bool addPlicae=true)
{
	int i, chunkSize = 200;
	string inClause;
	vector<string> inClauseVector;

	Iterator temp = begin;
	i = 0;
	while (temp != end)
	{
		if (i%chunkSize == 0)
		{
			if (!inClause.empty())
			{
				inClause[inClause.size() - 1] = ')';
				inClauseVector.push_back(inClause);
				inClause.clear();
			}
			inClause = "(";
		}

		if (addPlicae)
			inClause += "'" + db->escapeSequence(*temp) + "',";
		else
			inClause += db->escapeSequence(*temp) + ",";
		i++;
		++temp;
	}
	if (!inClause.empty())
	{
		inClause[inClause.size() - 1] = ')';
		inClauseVector.push_back(inClause);
	}
	return inClauseVector;
}

//! generate Count legends 
bool generateCountLegends(TeThemeApplication* theme, string table, string field);

void changeObjectStatus(ObjectInfo& info, string& uniqueId, string mode, int pointed = 1);

bool saveObjectStatus(TeThemeApplication *theme, set<string>& objectSet, map<string, ObjectInfo>& objectMap);

string getStringFromStatistic (TeStatisticType st);

TeStatisticType getStatisticFromString(const string& s);

#endif


