#include <TePDIParameters.hpp>

#include <TePDIAgnostic.hpp>

#include <TeRaster.h>

#include <stdlib.h>
#include <iostream>

int main()
{
  PDIAGN_LOGMSG( "Test started." );

  PDIAGN_DEBUG_MODE_CHECK;

  try{
    /* Integer type test */

    TePDIParameters tparam;

    tparam.SetParameter( std::string("param_name_1"), (int)1 );
    tparam.SetParameter( std::string("param_name_2"), (int)2 );

    PDIAGN_TRUE_OR_THROW( tparam.CheckParameter( "param_name_1",
      TePDIParameters::TePDIIntParam ),
      "Parameter checking error for param_name_1" );

    PDIAGN_TRUE_OR_THROW( tparam.CheckParameter( "param_name_2",
      TePDIParameters::TePDIIntParam ),
      "Parameter checking error for param_name_2" );

    PDIAGN_TRUE_OR_THROW( false == tparam.CheckParameter(
      "param_name_unknown", TePDIParameters::TePDIIntParam ),
      "Unknown Parameter checking error" );

    int temp_v1 = 0;
    int temp_v2 = 0;

    PDIAGN_TRUE_OR_THROW( tparam.GetParameter( "param_name_1", temp_v1 ),
      "Invalid param_name_1 GET" );

    PDIAGN_TRUE_OR_THROW( temp_v1 == 1,
      "param_name_1 value checking" );

    PDIAGN_TRUE_OR_THROW( tparam.GetParameter( "param_name_2", temp_v2 ),
      "Invalid param_name_2 GET" );

    PDIAGN_TRUE_OR_THROW( temp_v2 == 2,
      "param_name_2 value checking" );

    /* Vector type test */

    std::vector< int > temp_vector_1;
    temp_vector_1.push_back( 1 );

    tparam.SetParameter( "temp_vector_1", temp_vector_1 );

    std::vector< int > temp_vector_2;

    PDIAGN_TRUE_OR_THROW(
      tparam.GetParameter( "temp_vector_1", temp_vector_2 ),
      "Invalid temp_vector_1 GET" );

    PDIAGN_TRUE_OR_THROW( temp_vector_2.size() != 0,
      "Invalid temp_vector_2.size()" );

    /* Raster type test */

    TePDISharedPtr < TeRaster > rast1( new TeRaster( 0, 0, 0, TeDOUBLE ) );

    tparam.SetParameter( "rast1", rast1 );

    TePDISharedPtr < TeRaster > rast2( new TeRaster( 0, 0, 0, TeDOUBLE ) );

    PDIAGN_TRUE_OR_THROW(
      tparam.GetParameter( "rast1", rast2 ),
      "Invalid rast1 GET" );

    /* Copy operator test */

    TePDIParameters tparam2;

    tparam2 = tparam;

    PDIAGN_TRUE_OR_THROW( tparam2.GetParameter( "param_name_1", temp_v1 ),
      "Invalid param_name_1 GET" );

    PDIAGN_TRUE_OR_THROW(
      tparam2.GetParameter( "temp_vector_1", temp_vector_2 ),
      "Invalid temp_vector_1 GET" );

    PDIAGN_TRUE_OR_THROW(
      tparam2.GetParameter( "rast1", rast2 ),
      "Invalid rast1 GET" );
  }
  catch(...){
    PDIAGN_LOGERR( "Test Failed.");
    return EXIT_FAILURE;
  }

  PDIAGN_LOGMSG( "Test OK." );
  return EXIT_SUCCESS;
}
