#include "TePDILinearFilter.hpp"

#include "TePDIAgnostic.hpp"


TePDILinearFilter::TePDILinearFilter( const TePDIParameters& params )
: TePDIFilter( params )
{
}


TePDILinearFilter::TePDILinearFilter()
{
}


TePDILinearFilter::~TePDILinearFilter()
{
}


bool TePDILinearFilter::CheckParameters( const TePDIParameters& parameters )
{
  /* Checking for general required parameters */

  TePDITypes::TePDIRasterPtrType inRaster;
  if( ! parameters.GetParameter( "input_image", inRaster ) ) {

    PDIAGN_LOGERR( "Missing parameter: input_image" );
    return false;
  }
  if( ! inRaster.isActive() ) {

    PDIAGN_LOGERR( "Invalid parameter: input_image inactive" );
    return false;
  }
  if( inRaster->status() == TeNOTREADY ) {

    PDIAGN_LOGERR( "Invalid parameter: input_image not ready" );
    return false;
  }

  TePDITypes::TePDIRasterPtrType outRaster;
  if( ! parameters.GetParameter( "output_image", outRaster ) ) {

    PDIAGN_LOGERR( "Missing parameter: output_image" );
    return false;
  }
  if( ! outRaster.isActive() ) {

    PDIAGN_LOGERR( "Invalid parameter: output_image inactive" );
    return false;
  }
  if( inRaster->status() == TeREADYTOWRITE ) {

    PDIAGN_LOGERR( "Invalid parameter: output_image not ready" );
    return false;
  }

  /* channels parameter checking */

  std::vector< int > channels;
  if( ! parameters.GetParameter( "channels", channels ) ) {

    PDIAGN_LOGERR( "Missing parameter: channels" );
    return false;
  }
  for( unsigned int index = 0 ; index < channels.size() ; ++index ) {
    if( channels[ index ] >= inRaster->nBands() ) {
      PDIAGN_LOGERR( "Invalid parameter: channels" );
      return false;
    }
  }
  return true;
}


bool TePDILinearFilter::RunImplementation()
{
  PDIAGN_NOT_IMPLEMENTED;

  return false;
}


void TePDILinearFilter::ResetState()
{
  PDIAGN_NOT_IMPLEMENTED;
}

