/*
 * Copyright (c) 1994 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

/* Tcl_LdapDeleteCmd - simple function to delete an entry using LDAP */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <lber.h>
#include <ldap.h>
#include "tcl.h"

extern int ldcnt;
extern LDAP *ldprime[1024];

int Tcl_LdapDeleteCmd (dummy, interp, argc, argv)
     ClientData dummy;
     Tcl_Interp *interp;
     int argc;
     char **argv;
{
    char *dn;
    int rc, connection;

    if (argc < 3) {
	Tcl_AppendResult (interp, "Too few arguments! Usage: ", (char *) NULL);
	Tcl_AppendResult (interp, argv[0], " LdapConn DN-to-delete ", (char *) NULL);
	return TCL_ERROR;
    }

    connection = atoi (argv[1]);
    dn = argv[2];

    if (connection > ldcnt || connection < 0) {
	Tcl_AppendResult (interp, "Invalid connection number!", (char *) NULL);
	return TCL_ERROR;
    }

    if ((rc = ldap_delete_s (ldprime[connection], dn)) != LDAP_SUCCESS) {
	Tcl_AppendResult (interp, "Unable to delete entry!", (char *) NULL);
	return TCL_ERROR;
    } else {
	Tcl_AppendResult (interp, "Entry deleted!", (char *) NULL);
	return TCL_OK;
    }
}
