/*
 * This C file has been generated by smidump 0.2.17.
 * It is intended to be used with the NET-SNMP agent library.
 *
 * This C file is derived from the SNMPv2-MIB module.
 *
 * $Id: snmpv2-mib-agt-stub.c,v 1.4 2001/08/24 10:11:17 strauss Exp $
 */

#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "snmpv2-mib.h"

#include <ucd-snmp/asn1.h>
#include <ucd-snmp/snmp.h>
#include <ucd-snmp/snmp_api.h>
#include <ucd-snmp/snmp_impl.h>
#include <ucd-snmp/snmp_vars.h>

/*
 * Forward declaration of read methods for groups of scalars and tables:
 */

static unsigned char *
read_system_stub(struct variable *, oid *, size_t *, int, size_t *, WriteMethod **);
static unsigned char *
read_sysOREntry_stub(struct variable *, oid *, size_t *, int, size_t *, WriteMethod **);
static unsigned char *
read_snmp_stub(struct variable *, oid *, size_t *, int, size_t *, WriteMethod **);
static unsigned char *
read_snmpSet_stub(struct variable *, oid *, size_t *, int, size_t *, WriteMethod **);

/*
 * Forward declaration of write methods for writable objects:
 */

static int
write_sysContact_stub(int, u_char *, u_char, int, u_char *, oid *, int);
static int
write_sysName_stub(int, u_char *, u_char, int, u_char *, oid *, int);
static int
write_sysLocation_stub(int, u_char *, u_char, int, u_char *, oid *, int);
static int
write_snmpEnableAuthenTraps_stub(int, u_char *, u_char, int, u_char *, oid *, int);
static int
write_snmpSetSerialNo_stub(int, u_char *, u_char, int, u_char *, oid *, int);

/*
 * Definitions of tags that are used internally to read/write
 * the selected object type. These tags should be unique.
 */

#define SYSDESCR                         1
#define SYSOBJECTID                      2
#define SYSUPTIME                        3
#define SYSCONTACT                       4
#define SYSNAME                          5
#define SYSLOCATION                      6
#define SYSSERVICES                      7
#define SYSORLASTCHANGE                  8

static oid system_base[] = {1, 3, 6, 1, 2, 1, 1};

struct variable system_variables[] = {
    { SYSDESCR, ASN_OCTET_STR, RONLY, read_system_stub, 1, {1} },
    { SYSOBJECTID, ASN_OBJECT_ID, RONLY, read_system_stub, 1, {2} },
    { SYSUPTIME, ASN_INTEGER, RONLY, read_system_stub, 1, {3} },
    { SYSCONTACT, ASN_OCTET_STR, RWRITE, read_system_stub, 1, {4} },
    { SYSNAME, ASN_OCTET_STR, RWRITE, read_system_stub, 1, {5} },
    { SYSLOCATION, ASN_OCTET_STR, RWRITE, read_system_stub, 1, {6} },
    { SYSSERVICES, ASN_INTEGER, RONLY, read_system_stub, 1, {7} },
    { SYSORLASTCHANGE, ASN_INTEGER, RONLY, read_system_stub, 1, {8} },
};

#define SYSORID                          2
#define SYSORDESCR                       3
#define SYSORUPTIME                      4

static oid sysOREntry_base[] = {1, 3, 6, 1, 2, 1, 1, 9, 1};

struct variable sysOREntry_variables[] = {
    { SYSORID, ASN_OBJECT_ID, RONLY, read_sysOREntry_stub, 1, {2} },
    { SYSORDESCR, ASN_OCTET_STR, RONLY, read_sysOREntry_stub, 1, {3} },
    { SYSORUPTIME, ASN_INTEGER, RONLY, read_sysOREntry_stub, 1, {4} },
};

#define SNMPINPKTS                       1
#define SNMPOUTPKTS                      2
#define SNMPINBADVERSIONS                3
#define SNMPINBADCOMMUNITYNAMES          4
#define SNMPINBADCOMMUNITYUSES           5
#define SNMPINASNPARSEERRS               6
#define SNMPINTOOBIGS                    8
#define SNMPINNOSUCHNAMES                9
#define SNMPINBADVALUES                  10
#define SNMPINREADONLYS                  11
#define SNMPINGENERRS                    12
#define SNMPINTOTALREQVARS               13
#define SNMPINTOTALSETVARS               14
#define SNMPINGETREQUESTS                15
#define SNMPINGETNEXTS                   16
#define SNMPINSETREQUESTS                17
#define SNMPINGETRESPONSES               18
#define SNMPINTRAPS                      19
#define SNMPOUTTOOBIGS                   20
#define SNMPOUTNOSUCHNAMES               21
#define SNMPOUTBADVALUES                 22
#define SNMPOUTGENERRS                   24
#define SNMPOUTGETREQUESTS               25
#define SNMPOUTGETNEXTS                  26
#define SNMPOUTSETREQUESTS               27
#define SNMPOUTGETRESPONSES              28
#define SNMPOUTTRAPS                     29
#define SNMPENABLEAUTHENTRAPS            30
#define SNMPSILENTDROPS                  31
#define SNMPPROXYDROPS                   32

static oid snmp_base[] = {1, 3, 6, 1, 2, 1, 11};

struct variable snmp_variables[] = {
    { SNMPINPKTS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {1} },
    { SNMPOUTPKTS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {2} },
    { SNMPINBADVERSIONS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {3} },
    { SNMPINBADCOMMUNITYNAMES, ASN_INTEGER, RONLY, read_snmp_stub, 1, {4} },
    { SNMPINBADCOMMUNITYUSES, ASN_INTEGER, RONLY, read_snmp_stub, 1, {5} },
    { SNMPINASNPARSEERRS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {6} },
    { SNMPINTOOBIGS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {8} },
    { SNMPINNOSUCHNAMES, ASN_INTEGER, RONLY, read_snmp_stub, 1, {9} },
    { SNMPINBADVALUES, ASN_INTEGER, RONLY, read_snmp_stub, 1, {10} },
    { SNMPINREADONLYS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {11} },
    { SNMPINGENERRS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {12} },
    { SNMPINTOTALREQVARS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {13} },
    { SNMPINTOTALSETVARS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {14} },
    { SNMPINGETREQUESTS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {15} },
    { SNMPINGETNEXTS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {16} },
    { SNMPINSETREQUESTS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {17} },
    { SNMPINGETRESPONSES, ASN_INTEGER, RONLY, read_snmp_stub, 1, {18} },
    { SNMPINTRAPS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {19} },
    { SNMPOUTTOOBIGS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {20} },
    { SNMPOUTNOSUCHNAMES, ASN_INTEGER, RONLY, read_snmp_stub, 1, {21} },
    { SNMPOUTBADVALUES, ASN_INTEGER, RONLY, read_snmp_stub, 1, {22} },
    { SNMPOUTGENERRS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {24} },
    { SNMPOUTGETREQUESTS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {25} },
    { SNMPOUTGETNEXTS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {26} },
    { SNMPOUTSETREQUESTS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {27} },
    { SNMPOUTGETRESPONSES, ASN_INTEGER, RONLY, read_snmp_stub, 1, {28} },
    { SNMPOUTTRAPS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {29} },
    { SNMPENABLEAUTHENTRAPS, ASN_INTEGER, RWRITE, read_snmp_stub, 1, {30} },
    { SNMPSILENTDROPS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {31} },
    { SNMPPROXYDROPS, ASN_INTEGER, RONLY, read_snmp_stub, 1, {32} },
};


#define SNMPSETSERIALNO                  1

static oid snmpSet_base[] = {1, 3, 6, 1, 6, 3, 1, 1, 6};

struct variable snmpSet_variables[] = {
    { SNMPSETSERIALNO, ASN_INTEGER, RWRITE, read_snmpSet_stub, 1, {1} },
};



/*
 * Registration functions for the various MIB groups.
 */

int register_system()
{
    return register_mib("system",
         system_variables,
         sizeof(struct variable),
         sizeof(system_variables)/sizeof(struct variable),
         system_base,
         sizeof(system_base)/sizeof(oid));
};


int register_sysOREntry()
{
    return register_mib("sysOREntry",
         sysOREntry_variables,
         sizeof(struct variable),
         sizeof(sysOREntry_variables)/sizeof(struct variable),
         sysOREntry_base,
         sizeof(sysOREntry_base)/sizeof(oid));
};


int register_snmp()
{
    return register_mib("snmp",
         snmp_variables,
         sizeof(struct variable),
         sizeof(snmp_variables)/sizeof(struct variable),
         snmp_base,
         sizeof(snmp_base)/sizeof(oid));
};


int register_snmpTrap()
{
    return register_mib("snmpTrap",
         snmpTrap_variables,
         sizeof(struct variable),
         sizeof(snmpTrap_variables)/sizeof(struct variable),
         snmpTrap_base,
         sizeof(snmpTrap_base)/sizeof(oid));
};


int register_snmpSet()
{
    return register_mib("snmpSet",
         snmpSet_variables,
         sizeof(struct variable),
         sizeof(snmpSet_variables)/sizeof(struct variable),
         snmpSet_base,
         sizeof(snmpSet_base)/sizeof(oid));
};


/*
 * Read methods for groups of scalars and tables:
 */

static unsigned char *
read_system_stub(struct variable *vp,
    oid     *name,
    size_t  *length,
    int     exact,
    size_t  *var_len,
    WriteMethod **write_method)
{
    static system_t system;

    /* check whether the instance identifier is valid */

    if (header_generic(vp, name, length, exact, var_len,
                       write_method) == MATCH_FAILED) {
        return NULL;
    }

    /* call the user supplied function to retrieve values */

    read_system(&system);

    /* return the current value of the variable */

    switch (vp->magic) {

    case SYSDESCR:
        *var_len = system._sysDescrLength;
        return (unsigned char *) system.sysDescr;

    case SYSOBJECTID:
        *var_len = system._sysObjectIDLength;
        return (unsigned char *) system.sysObjectID;

    case SYSUPTIME:
        return (unsigned char *) &system.sysUpTime;

    case SYSCONTACT:
        *var_len = system._sysContactLength;
        return (unsigned char *) system.sysContact;

    case SYSNAME:
        *var_len = system._sysNameLength;
        return (unsigned char *) system.sysName;

    case SYSLOCATION:
        *var_len = system._sysLocationLength;
        return (unsigned char *) system.sysLocation;

    case SYSSERVICES:
        return (unsigned char *) &system.sysServices;

    case SYSORLASTCHANGE:
        return (unsigned char *) &system.sysORLastChange;

    default:
         ERROR_MSG("");
    }

    return NULL;
}

static unsigned char *
read_sysOREntry_stub(struct variable *vp,
    oid     *name,
    size_t  *length,
    int     exact,
    size_t  *var_len,
    WriteMethod **write_method)
{
    static sysOREntry_t sysOREntry;

    /* call the user supplied function to retrieve values */

    read_sysOREntry(&sysOREntry);

    /* return the current value of the variable */

    switch (vp->magic) {

    case SYSORID:
        *var_len = sysOREntry._sysORIDLength;
        return (unsigned char *) sysOREntry.sysORID;

    case SYSORDESCR:
        *var_len = sysOREntry._sysORDescrLength;
        return (unsigned char *) sysOREntry.sysORDescr;

    case SYSORUPTIME:
        return (unsigned char *) &sysOREntry.sysORUpTime;

    default:
         ERROR_MSG("");
    }

    return NULL;
}

static unsigned char *
read_snmp_stub(struct variable *vp,
    oid     *name,
    size_t  *length,
    int     exact,
    size_t  *var_len,
    WriteMethod **write_method)
{
    static snmp_t snmp;

    /* check whether the instance identifier is valid */

    if (header_generic(vp, name, length, exact, var_len,
                       write_method) == MATCH_FAILED) {
        return NULL;
    }

    /* call the user supplied function to retrieve values */

    read_snmp(&snmp);

    /* return the current value of the variable */

    switch (vp->magic) {

    case SNMPINPKTS:
        return (unsigned char *) &snmp.snmpInPkts;

    case SNMPOUTPKTS:
        return (unsigned char *) &snmp.snmpOutPkts;

    case SNMPINBADVERSIONS:
        return (unsigned char *) &snmp.snmpInBadVersions;

    case SNMPINBADCOMMUNITYNAMES:
        return (unsigned char *) &snmp.snmpInBadCommunityNames;

    case SNMPINBADCOMMUNITYUSES:
        return (unsigned char *) &snmp.snmpInBadCommunityUses;

    case SNMPINASNPARSEERRS:
        return (unsigned char *) &snmp.snmpInASNParseErrs;

    case SNMPINTOOBIGS:
        return (unsigned char *) &snmp.snmpInTooBigs;

    case SNMPINNOSUCHNAMES:
        return (unsigned char *) &snmp.snmpInNoSuchNames;

    case SNMPINBADVALUES:
        return (unsigned char *) &snmp.snmpInBadValues;

    case SNMPINREADONLYS:
        return (unsigned char *) &snmp.snmpInReadOnlys;

    case SNMPINGENERRS:
        return (unsigned char *) &snmp.snmpInGenErrs;

    case SNMPINTOTALREQVARS:
        return (unsigned char *) &snmp.snmpInTotalReqVars;

    case SNMPINTOTALSETVARS:
        return (unsigned char *) &snmp.snmpInTotalSetVars;

    case SNMPINGETREQUESTS:
        return (unsigned char *) &snmp.snmpInGetRequests;

    case SNMPINGETNEXTS:
        return (unsigned char *) &snmp.snmpInGetNexts;

    case SNMPINSETREQUESTS:
        return (unsigned char *) &snmp.snmpInSetRequests;

    case SNMPINGETRESPONSES:
        return (unsigned char *) &snmp.snmpInGetResponses;

    case SNMPINTRAPS:
        return (unsigned char *) &snmp.snmpInTraps;

    case SNMPOUTTOOBIGS:
        return (unsigned char *) &snmp.snmpOutTooBigs;

    case SNMPOUTNOSUCHNAMES:
        return (unsigned char *) &snmp.snmpOutNoSuchNames;

    case SNMPOUTBADVALUES:
        return (unsigned char *) &snmp.snmpOutBadValues;

    case SNMPOUTGENERRS:
        return (unsigned char *) &snmp.snmpOutGenErrs;

    case SNMPOUTGETREQUESTS:
        return (unsigned char *) &snmp.snmpOutGetRequests;

    case SNMPOUTGETNEXTS:
        return (unsigned char *) &snmp.snmpOutGetNexts;

    case SNMPOUTSETREQUESTS:
        return (unsigned char *) &snmp.snmpOutSetRequests;

    case SNMPOUTGETRESPONSES:
        return (unsigned char *) &snmp.snmpOutGetResponses;

    case SNMPOUTTRAPS:
        return (unsigned char *) &snmp.snmpOutTraps;

    case SNMPENABLEAUTHENTRAPS:
        return (unsigned char *) &snmp.snmpEnableAuthenTraps;

    case SNMPSILENTDROPS:
        return (unsigned char *) &snmp.snmpSilentDrops;

    case SNMPPROXYDROPS:
        return (unsigned char *) &snmp.snmpProxyDrops;

    default:
         ERROR_MSG("");
    }

    return NULL;
}

static unsigned char *
read_snmpSet_stub(struct variable *vp,
    oid     *name,
    size_t  *length,
    int     exact,
    size_t  *var_len,
    WriteMethod **write_method)
{
    static snmpSet_t snmpSet;

    /* check whether the instance identifier is valid */

    if (header_generic(vp, name, length, exact, var_len,
                       write_method) == MATCH_FAILED) {
        return NULL;
    }

    /* call the user supplied function to retrieve values */

    read_snmpSet(&snmpSet);

    /* return the current value of the variable */

    switch (vp->magic) {

    case SNMPSETSERIALNO:
        return (unsigned char *) &snmpSet.snmpSetSerialNo;

    default:
         ERROR_MSG("");
    }

    return NULL;
}


/*
 * Forward declaration of write methods for writable objects:
 */

static int
write_sysContact_stub(int action,
    u_char   *var_val,
    u_char   var_val_type,
    int      var_val_len,
    u_char   *statP,
    oid      *name,
    int      name_len)
{
    return SNMP_ERR_NOERROR;
}

static int
write_sysName_stub(int action,
    u_char   *var_val,
    u_char   var_val_type,
    int      var_val_len,
    u_char   *statP,
    oid      *name,
    int      name_len)
{
    return SNMP_ERR_NOERROR;
}

static int
write_sysLocation_stub(int action,
    u_char   *var_val,
    u_char   var_val_type,
    int      var_val_len,
    u_char   *statP,
    oid      *name,
    int      name_len)
{
    return SNMP_ERR_NOERROR;
}

static int
write_snmpEnableAuthenTraps_stub(int action,
    u_char   *var_val,
    u_char   var_val_type,
    int      var_val_len,
    u_char   *statP,
    oid      *name,
    int      name_len)
{
    return SNMP_ERR_NOERROR;
}

static int
write_snmpSetSerialNo_stub(int action,
    u_char   *var_val,
    u_char   var_val_type,
    int      var_val_len,
    u_char   *statP,
    oid      *name,
    int      name_len)
{
    return SNMP_ERR_NOERROR;
}


