/*

   SMB Authentication module for Pike
   Version 0.1
   Copyright (C) Bill Welliver 1999

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "global.h"

#include "error.h"
#include "array.h"
#include "svalue.h"
#include "stralloc.h"
#include "dynamic_buffer.h"
#include "pike_types.h"
#include "constants.h"
#include "interpret.h"
#include "pike_memory.h"
#include "pike_macros.h" 

/** Forward declarations of functions implementing Pike functions **/

static void f_smb_auth( INT32 args );




/* Initialize and start module */

void pike_module_init( void )
{

  add_function( "auth", f_smb_auth,
      "function(string,string,string,string,string:mixed)", 0 );
}


/* Restore and exit module */

void pike_module_exit( void )
{
}


/** Functions implementing Pike functions **/


static void f_smb_auth( INT32 args ) {

char * username;
char * password;
char * server;
char * backup;
char * domain;
int i;

 get_all_args("auth", args, "%s%s%s%s%s", &username, &password, &server, 
&backup, &domain);
 i= Valid_User(username, password, server, backup, domain);
printf("Valid_User returned %d.\n", i);
 pop_n_elems(args);
 push_int(i);
}

