/*
 * This is the calculator tag module for roxen.
 * Written Wed Nov 11 1999 by James Tyson
 * Distributed under the GNU GPL (http://www.gnu.org)
 * My personal site: http://fuck.nuckle.net/
 */

#include <module.h>
inherit "module";
inherit "roxenlib";

// Register the module
array register_module() {
	return	({ MODULE_PARSER, "Calculator tag",
	  "I decided that RXML was missing good arithmetic operators and wrote this module.<br>" +
	  "See &lt;CALC HELP&gt; for more information.", 0, 0 });
	}

// Configuration stuff
void create() {
	}

// Map the tags to their functions
mapping query_tag_callers() { return ([ "calc":tag_calc ]); }

// Define the calc tag
string tag_calc(string tag,mapping args,object request_id,object file,mapping defines) {
	if (args->help) {
		return("This tag takes arguments in the following format:<br>" +
		        "&lt;CALC VALUE1 OPERATOR VALUE2&gt; where operator can be one of:<br>" +
		        "<blockquote>PLUS or +<br>" +
		        "MINUS or -<br>" +
		        "MULTIPLY or *<br>" +
		        "DEVIDE or /</blockquote>" +
		        "VALUE1 and VALUE2 are the first and second values, ie; the following<br>" +
		        "tag (&lt;CALC VALUE1=\"30\" OPERATOR=\"DEVIDE\" VALUE2=\"5\"&gt; will return<br>" +
		        "The ouput 6.<br>" +
						"<br><b>NOTE:</b> This module only handles integers - no floating point ops here please");
		}
	if (!args->value1 || !args->value2 || !args->operator) {
		return("ERROR: You must supply an operator, value1 and value2");
		}
	int value1;
	int value2;
	sscanf(args->value1,"%d",value1);
	sscanf(args->value2,"%d",value2);
	if ((args->operator == "PLUS") || (args->operator == "plus") || (args->operator == "+")) {
		return(sprintf("%d",value1 + value2));
		}
	if ((args->operator == "MINUS") ||(args->operator == "minus") || (args->operator == "-")) {
		return(sprintf("%d",value1 - value2));
		}
	if ((args->operator == "MULTIPLY") || (args->operator == "multiply") || (args->operator == "*")) {
		return(sprintf("%d",value1 * value2));
		}
	if ((args->operator == "DIVIDE") || (args->operator == "divide") || (args->operator == "/")) {
		if (value2 == 0) {
			return("ERROR: Cannot devide by two.");
			}
		return(sprintf("%d",value1 / value2));
		}
	return("ERROR: I did nothing");
	}
