/* 
 * All content copyright Terracotta, Inc., unless otherwise indicated. All rights reserved. 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not 
 * use this file except in compliance with the License. You may obtain a copy 
 * of the License at 
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0 
 *   
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations 
 * under the License.
 * 
 */
 package org.terracotta.quartz.tests;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;

public class SimpleJob implements Job {
  public static final CyclicBarrier localBarrier = new CyclicBarrier(2);

  public void execute(JobExecutionContext context) throws JobExecutionException {
    Integer awaitTime = (Integer)context.getJobDetail().getJobDataMap().get("await-time");
    if (awaitTime == null) {
      awaitTime = 10;
    }

    System.err.println("Hi there");
    try {
      localBarrier.await(awaitTime, TimeUnit.SECONDS);
    } catch (Exception e) {
      throw new JobExecutionException(e);
    }
  }
}
