/* rookMobility.t.cc
 */
#include "osl/mobility/rookMobility.h"
#include "osl/record/csaString.h"
#include <iostream>

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class RookMobilityTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(RookMobilityTest);
  CPPUNIT_TEST(testVertical);
  CPPUNIT_TEST(testHorizontal);
  CPPUNIT_TEST_SUITE_END();
public:
  void testVertical();
  void testHorizontal();
};

CPPUNIT_TEST_SUITE_REGISTRATION(RookMobilityTest);

using namespace osl;
using namespace osl::mobility;

void RookMobilityTest::testVertical()
{
  {
    SimpleState sState=
      CsaString(
		"P1+NY+TO *  *  *  * -OU-KE-KY\n"
		"P2 *  *  *  *  * -GI-KI *  *\n"
		"P3 * +RY *  * +UM * -KI-FU-FU\n"
		"P4 *  * +FU-FU *  *  *  *  *\n"
		"P5 *  * -KE * +FU *  * +FU *\n"
		"P6+KE *  * +FU+GI-FU *  * +FU\n"
		"P7 *  * -UM *  *  *  *  *  *\n"
		"P8 *  *  *  *  *  *  *  *  * \n"
		"P9 * +OU * -GI *  *  *  * -NG\n"
		"P+00HI00KI00KE00KY00FU00FU00FU00FU00FU00FU\n"
		"P-00KI00KY00FU00FU\n"
		"P-00AL\n"
		"+\n"
		).getInitialState();
    NumEffectState state(sState);
    // 83 飛車 
    Piece p=state.getPieceAt(Position(8,3));
    CPPUNIT_ASSERT_EQUAL(6,RookMobility::countVerticalAll(BLACK,state,p));
    CPPUNIT_ASSERT_EQUAL(3,RookMobility::countVerticalSafe(BLACK,state,p));
    int countAll=0,countSafe=0;
    RookMobility::countVerticalBoth(BLACK,state,p,countAll,countSafe);
    CPPUNIT_ASSERT_EQUAL(6,countAll);
    CPPUNIT_ASSERT_EQUAL(3,countSafe);
  }
  {
    SimpleState sState=
      CsaString(
		"P1+NY+RY *  *  *  * -KE-OU-KY\n"
		"P2 *  *  *  *  * -GI-KI *  *\n"
		"P3 * +TO *  * +UM * -KI-FU-FU\n"
		"P4 *  * +FU-FU *  *  *  *  *\n"
		"P5 *  * -KE * +FU *  * +FU *\n"
		"P6+KE *  * +FU+GI-FU *  * +FU\n"
		"P7 *  * -UM *  *  *  *  *  *\n"
		"P8 *  *  *  *  *  *  *  *  * \n"
		"P9 * +OU * -GI *  *  *  * -NG\n"
		"P+00HI00KI00KE00KY00FU00FU00FU00FU00FU00FU\n"
		"P-00KI00KY00FU00FU\n"
		"P-00AL\n"
		"+\n"
		).getInitialState();
    NumEffectState state(sState);
    // 81 飛車 
    Piece p=state.getPieceAt(Position(8,1));
    CPPUNIT_ASSERT_EQUAL(1,RookMobility::countVerticalAll(BLACK,state,p));
    CPPUNIT_ASSERT_EQUAL(1,RookMobility::countVerticalSafe(BLACK,state,p));
    int countAll=0,countSafe=0;
    RookMobility::countVerticalBoth(BLACK,state,p,countAll,countSafe);
    CPPUNIT_ASSERT_EQUAL(1,countAll);
    CPPUNIT_ASSERT_EQUAL(1,countSafe);
  }
}

void RookMobilityTest::testHorizontal()
{
  {
    SimpleState sState=
      CsaString(
		"P1+NY+TO *  *  *  * -OU-KE-KY\n"
		"P2 *  *  * -FU * -GI-KI *  *\n"
		"P3 * +RY *  * +UM * -KI-FU-FU\n"
		"P4 *  * +FU *  *  *  *  *  *\n"
		"P5 *  * -KE * +FU *  * +FU *\n"
		"P6+KE *  * +FU+GI-FU *  * +FU\n"
		"P7 *  * -UM *  *  *  *  *  *\n"
		"P8 *  *  *  *  *  *  *  *  * \n"
		"P9 * +OU * -GI *  *  *  * -NG\n"
		"P+00HI00KI00KE00KY00FU00FU00FU00FU00FU00FU\n"
		"P-00KI00KY00FU00FU\n"
		"P-00AL\n"
		"+\n"
		).getInitialState();
    NumEffectState state(sState);
    // 83 飛車 
    Piece p=state.getPieceAt(Position(8,3));
    CPPUNIT_ASSERT_EQUAL(3,RookMobility::countHorizontalAll(BLACK,state,p));
    CPPUNIT_ASSERT_EQUAL(2,RookMobility::countHorizontalSafe(BLACK,state,p));
    int countAll=0,countSafe=0;
    RookMobility::countHorizontalBoth(BLACK,state,p,countAll,countSafe);
    CPPUNIT_ASSERT_EQUAL(3,countAll);
    CPPUNIT_ASSERT_EQUAL(2,countSafe);
  }
  {
    SimpleState sState=
      CsaString(
		"P1+NY *  *  *  *  * -KE-OU-KY\n"
		"P2+RY *  *  *  * -GI-KI *  *\n"
		"P3 * +TO *  * +UM * -KI-FU-FU\n"
		"P4 *  * +FU-FU *  *  *  *  *\n"
		"P5 *  * -KE * +FU *  * +FU *\n"
		"P6+KE *  * +FU+GI-FU *  * +FU\n"
		"P7 *  * -UM *  *  *  *  *  *\n"
		"P8 *  *  *  *  *  *  *  *  * \n"
		"P9 * +OU * -GI *  *  *  * -NG\n"
		"P+00HI00KI00KE00KY00FU00FU00FU00FU00FU00FU\n"
		"P-00KI00KY00FU00FU\n"
		"P-00AL\n"
		"+\n"
		).getInitialState();
    NumEffectState state(sState);
    // 92 飛車 
    Piece p=state.getPieceAt(Position(9,2));
    CPPUNIT_ASSERT_EQUAL(5,RookMobility::countHorizontalAll(BLACK,state,p));
    CPPUNIT_ASSERT_EQUAL(4,RookMobility::countHorizontalSafe(BLACK,state,p));
    int countAll=0,countSafe=0;
    RookMobility::countHorizontalBoth(BLACK,state,p,countAll,countSafe);
    CPPUNIT_ASSERT_EQUAL(5,countAll);
    CPPUNIT_ASSERT_EQUAL(4,countSafe);
  }
}


/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
