/* oracleAdjust.t.cc
 */
#include "osl/checkmate/oracleAdjust.h"
#include "osl/record/csaString.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <iostream>

class OracleAdjustTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(OracleAdjustTest);
  CPPUNIT_TEST(testPromote);
  CPPUNIT_TEST(testSelection);
  CPPUNIT_TEST_SUITE_END();
public:
  void testPromote();
  void testSelection();
};
CPPUNIT_TEST_SUITE_REGISTRATION(OracleAdjustTest);

using namespace osl;
using namespace osl::checkmate;

void OracleAdjustTest::testPromote()
{
  {
    NumEffectState state(CsaString(
			   "P1-KY-KE+UM *  *  *  *  * -KY\n"
			   "P2 * -HI *  *  *  * -KI-OU * \n"
			   "P3 *  *  * -GI *  * -KE-FU * \n"
			   "P4 *  *  *  * -FU * +FU * -FU\n"
			   "P5-FU *  * +FU *  *  * +FU * \n"
			   "P6 *  *  * -RY+FU * -FU * +FU\n"
			   "P7+FU+GI+KI *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  * +KY\n"
			   "P9+KY * +OU *  *  *  * +KE * \n"
			   "P+00KA00KI00GI00GI00KE00FU00FU00FU00FU00FU00FU00FU\n"
			   "P-00KI\n"
			   "-\n").getInitialState());
    const Move oracle(Position(7,5),Position(7,7),PROOK,GOLD,true,WHITE);
    const Move adjusted = OracleAdjust::attack(state, oracle);
    const Move expected(Position(6,6),Position(7,7),PROOK,GOLD,false,WHITE);
    CPPUNIT_ASSERT_EQUAL(expected, adjusted);
  }
}

void OracleAdjustTest::testSelection()
{
  {
    NumEffectState state(CsaString(
			   "P1-KY * +UM * +RY *  * -KE * \n"
			   "P2 *  *  *  * -HI *  *  *  * \n"
			   "P3 * -GI-OU *  *  *  * -KI-KY\n"
			   "P4-FU-FU-FU-FU * +UM * -FU-FU\n"
			   "P5 *  *  * -KE * +FU *  *  * \n"
			   "P6+FU+FU+FU *  *  *  *  * +FU\n"
			   "P7 *  * +GI+KI *  * +KE *  * \n"
			   "P8+KY+GI+KI *  *  *  *  *  * \n"
			   "P9+OU+KE *  *  * -TO *  * +KY\n"
			   "P+00KI00FU00FU00FU00FU\n"
			   "P-00GI00FU00FU\n"
			   "+\n"
			   ).getInitialState());
    const Move oracle(Position(3,5),Position(6,2),PBISHOP,PTYPE_EMPTY,false,BLACK);
    const Move adjusted = OracleAdjust::attack(state, oracle);
    // 7,1 の方を動かすと無限ループ
    const Move expected(Position(4,4),Position(6,2),PBISHOP,PTYPE_EMPTY,false,BLACK);
    CPPUNIT_ASSERT_EQUAL(expected, adjusted);
  }
}


/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
