#include "osl/effect/boardBitMask.h"
#include "osl/ptype.h"
#include "osl/ptypeTable.h"
#include <iostream>

namespace osl
{
namespace effect
{

  std::ostream& operator<<(std::ostream& os,BoardBitMask const& boardBitMask){
    os << "[";
    for(int i=15;i>=0;i--){
      unsigned char uc=boardBitMask.bMask[i];
      for(int j=7;j>=0;j--){
	if((uc&(1<<j))!=0) os << "1";
	else os<<"0";
      }
      os<<" ";
    }
    return os << "]";
  }
  

  void BoardBitMaskTable::initMaskOfPosition(){
    for(int i=0;i<Position::SIZE;i++){
      maskOfPosition[i].clearAll();
    }
    for(int y=1;y<=9;y++)
      for(int x=1;x<=9;x++){
	Position pos(x,y);
	maskOfPosition[pos.index()].setBit(BoardBitMask::positionToOffset(pos));
      }
  }

  static void setBetweenMask(BoardBitMask& mask,Position from,Position to,
			     Ptype ptype){
    const EffectContent effect=Ptype_Table.getEffect(newPtypeO(BLACK,ptype),Offset32(to,from));
    if(!effect.hasBlockableEffect()) return;
    const Offset offset=effect.offset();
    mask.clearAll();
    for(Position pos=from+offset;pos!=to;pos+=offset){
      mask.setBit(pos);
    }
  }
  void BoardBitMaskTable::initBetweenMask(){
    for(int j=0;j<Position::SIZE;j++){
      for(int i=0;i<Position::SIZE;i++){
	rookBetweenMask[i][j].setAll();
	lanceBetweenMask[i][j].setAll();
	bishopBetweenMask[i][j].setAll();
      }
    }
    for(int y1=1;y1<=9;y1++)
      for(int x1=1;x1<=9;x1++){
	Position from(x1,y1);
	for(int y2=1;y2<=9;y2++)
	  for(int x2=1;x2<=9;x2++){
	    Position to(x2,y2);
	    /**
	     * 利きがあったら対応するビットを立てる
	     */
	    setBetweenMask(lanceBetweenMask[from.index()][to.index()],from,to,LANCE);
	    setBetweenMask(bishopBetweenMask[from.index()][to.index()],from,to,BISHOP);
	    setBetweenMask(rookBetweenMask[from.index()][to.index()],from,to,ROOK);
	  }
      }
  }

  BoardBitMaskTable::BoardBitMaskTable(){
    initMaskOfPosition();
    initBetweenMask();
  }
} // namespace effect
} // namespace osl
