/* noEffectFilter.h
 */
#ifndef _NO_EFFECT_FILTER_H
#define _NO_EFFECT_FILTER_H

#include "osl/player.h"
#include "osl/move_action/concept.h"
namespace osl
{
  namespace move_action
  {
    /**
     * 利きのないところへ動くためのフィルタ
     */
    template<Player P,class OrigAction>
    class NoEffectFilter
    {
      BOOST_CLASS_REQUIRE(OrigAction,osl::move_action,Concept);
      const NumEffectState& state;
      OrigAction & action;
      Position removed;
    public:
      NoEffectFilter(const NumEffectState& s, OrigAction & action,Position pos) : state(s), action(action),removed(pos) {}
      void simpleMove(Position from,Position to,Ptype ptype, bool isPromote,Player /* p */,Move m){
	if(!state.template hasEffectByWithRemove<PlayerTraits<P>::opponent>(to,removed))
	  action.simpleMove(from,to,ptype,isPromote,P,m);
      }
      void unknownMove(Position from,Position to,Piece p1,Ptype ptype,bool isPromote,Player /* p */,Move m){
	if(!state.template hasEffectByWithRemove<PlayerTraits<P>::opponent>(to,removed)){
	  action.unknownMove(from,to,p1,ptype,isPromote,P,m);
	}
      }
      void dropMove(Position to,Ptype ptype,Player /* p */,Move m){
	/** ここは呼ばれないはず */
	if(!state.template hasEffectByWithRemove<PlayerTraits<P>::opponent>(to,removed))
	  action.dropMove(to,ptype,P,m);
      }
      // old interfaces
      void simpleMove(Position from,Position to,Ptype ptype, 
		      bool isPromote,Player p)
      {
	simpleMove(from,to,ptype,isPromote,p,
		   Move(from,to,ptype,PTYPE_EMPTY,isPromote,p));
      }
      void unknownMove(Position from,Position to,Piece captured,
		       Ptype ptype,bool isPromote,Player p)
      {
	unknownMove(from,to,captured,ptype,isPromote,p,
		    Move(from,to,ptype,captured.ptype(),isPromote,p));
      }
      void dropMove(Position to,Ptype ptype,Player p)
      {
	dropMove(to,ptype,p,
		 Move(to,ptype,p));
      }
    };

  } // namespace move_action
} // namespace osl


#endif /* _NO_EFFECT_FILTER_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
