/* storePtypeOPosition.h
 */
#ifndef _STORE_PTYPEO_POSITION_H
#define _STORE_PTYPEO_POSITION_H
#include "osl/container/ptypeOPositionVector.h"
namespace osl
{
  namespace effect_action
  {
    /**
     * PtypeOPositionVector に格納
     */
    struct StorePtypeOPosition
    {
      container::PtypeOPositionVector *out;
      Position target;
      StorePtypeOPosition(container::PtypeOPositionVector *s, Position t) 
	: out(s), target(t)
      {
      }
      template<Player P,Ptype Type>
      void doActionPtype(Piece p)
      {
	store(p);
      }
      template<Player P>
      void doAction(Piece p, Position)
      {
	store(p);
      }
    
      void store(Piece p)
      {
	const PtypeO ptypeO = p.ptypeO();
	out->push_back(std::make_pair(ptypeO, p.position()));
      }
    };
  } // namespace effect_action
} // namespace osl
#endif // _STORE_PTYPEO_POSITION_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
