#include "osl/move_classifier/trapRook.h"
#include "osl/move_classifier/moveAdaptor.h"
#include "osl/record/csaString.h"
#include "osl/record/record.h"
#include "osl/record/csaRecord.h"
#include "osl/apply_move/applyMove.h"
#include "osl/oslConfig.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <fstream>
using namespace osl;
using namespace osl::move_classifier;

class TrapRookTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(TrapRookTest);
  CPPUNIT_TEST(testPawnDrop);
  CPPUNIT_TEST(testFindInRecord);
  CPPUNIT_TEST_SUITE_END();
public:
  void testPawnDrop();
  void testFindInRecord();
};

CPPUNIT_TEST_SUITE_REGISTRATION(TrapRookTest);

void TrapRookTest::testFindInRecord()
{
  extern bool isShortTest;
  if (isShortTest)
    return;
  std::ifstream ifs(OslConfig::testCsaFile("FILES"));
  CPPUNIT_ASSERT(ifs);
  std::string file_name;
  for (int i=0; i<1000 && (ifs >> file_name); i++){
    if (file_name == "") 
      break;
    file_name = OslConfig::testCsaFile(file_name);
    const Record record=CsaFile(file_name).getRecord();
    NumEffectState state(record.getInitialState());
    const vector<osl::Move> moves=record.getMoves();
    for (unsigned int i=0;i<moves.size();i++)
    {
      if (PlayerMoveAdaptor<TrapRook>::isMember(state, moves[i]))
      {
#if 0
	// testLong の邪魔
	std::cerr << state << moves[i] << "\n";
#endif
      }
      ApplyMoveOfTurn::doMove(state, moves[i]);
    }
  }
}

void TrapRookTest::testPawnDrop()
{
  {
    NumEffectState state(CsaString(
			   "P1-KY *  *  *  *  * -GI-OU-KY\n"
			   "P2 *  *  *  *  * -KA-KI-GI * \n"
			   "P3 *  * -HI *  * -KI-KE * -FU\n"
			   "P4-FU *  *  * -FU-FU-FU+HI * \n"
			   "P5 * -FU-FU *  *  *  *  * +FU\n"
			   "P6+FU *  * +GI+FU+FU+FU *  * \n"
			   "P7+KE+FU+KI *  * +GI *  *  * \n"
			   "P8 *  *  * +KA * +KI+OU *  * \n"
			   "P9+KY *  *  *  *  *  *  * +KY\n"
			   "P+00KE00KE00FU\n"
			   "P-00FU00FU00FU00FU\n"
			   "-\n").getInitialState());
    CPPUNIT_ASSERT(TrapRook<WHITE>::isMember
		   (state, PAWN, Position::STAND(), Position(2,5)));
    CPPUNIT_ASSERT(! TrapRook<WHITE>::isMember
		   (state, LANCE, Position::STAND(), Position(2,5)));
    CPPUNIT_ASSERT(! TrapRook<WHITE>::isMember
		   (state, LANCE, Position::STAND(), Position(2,6)));
    CPPUNIT_ASSERT(! TrapRook<WHITE>::isMember
		   (state, LANCE, Position::STAND(), Position(3,5)));
  }
  {
    NumEffectState state(CsaString(
			   "P1-KY *  *  *  *  * -GI-OU-KY\n"
			   "P2 *  *  *  *  * -KA-KI-GI * \n"
			   "P3 *  * -HI *  * -KI-KE *  * \n"
			   "P4-FU *  *  * -FU-FU * +HI-FU\n"
			   "P5 * -FU-FU *  *  *  *  * +FU\n"
			   "P6+FU *  * +GI+FU+FU+FU *  * \n"
			   "P7+KE+FU+KI *  * +GI *  *  * \n"
			   "P8 *  *  * +KA * +KI+OU *  * \n"
			   "P9+KY *  *  *  *  *  *  * +KY\n"
			   "P+00KE00KE00FU\n"
			   "P-00FU00FU00FU00FU00FU\n"
			   "-\n").getInitialState());
    CPPUNIT_ASSERT(TrapRook<WHITE>::isMember
		   (state, PAWN, Position::STAND(), Position(2,5)));
  }
  {
    NumEffectState state(CsaString(
			   "P1-KY *  *  *  *  * -GI-OU-KY\n"
			   "P2 *  *  *  *  * -KA-KI-GI * \n"
			   "P3 *  * -HI * -KI * -KE *  * \n"
			   "P4-FU *  *  * -FU-FU * +HI-FU\n"
			   "P5 * -FU-FU *  *  *  *  * +FU\n"
			   "P6+FU *  * +GI+FU+FU+FU *  * \n"
			   "P7+KE+FU+KI *  * +GI *  *  * \n"
			   "P8 *  *  * +KA * +KI+OU *  * \n"
			   "P9+KY *  *  *  *  *  *  * +KY\n"
			   "P+00KE00KE00FU\n"
			   "P-00FU00FU00FU00FU00FU\n"
			   "-\n").getInitialState());
    CPPUNIT_ASSERT(! TrapRook<WHITE>::isMember
		   (state, PAWN, Position::STAND(), Position(2,5)));
  }
  {
    NumEffectState state(CsaString(
			   "P1-KY *  *  *  *  * -GI-OU-KY\n"
			   "P2 *  *  *  *  * -KA-KI-GI * \n"
			   "P3 *  * -HI * -KI * -KE *  * \n"
			   "P4-FU *  *  * -FU-FU-FU+HI-FU\n"
			   "P5 * -FU-FU *  *  *  *  * +FU\n"
			   "P6+FU *  * +GI+FU+FU+FU *  * \n"
			   "P7+KE+FU+KI *  * +GI *  *  * \n"
			   "P8 *  *  * +KA * +KI+OU *  * \n"
			   "P9+KY *  *  *  *  *  *  * +KY\n"
			   "P+00KE00KE00FU\n"
			   "P-00FU00FU00FU00FU\n"
			   "-\n").getInitialState());
    CPPUNIT_ASSERT(! TrapRook<WHITE>::isMember
		   (state, PAWN, Position::STAND(), Position(2,5)));
  }
  {
    NumEffectState state(CsaString(
			   "P1-KY *  *  *  *  * -GI-OU-KY\n"
			   "P2 *  *  *  *  * -KA-KI-GI * \n"
			   "P3 *  * -HI *  * -KI-KE *  * \n"
			   "P4-FU *  *  * -FU-FU-FU+HI+FU\n"
			   "P5 * -FU-FU *  *  *  *  * -FU\n"
			   "P6+FU *  * +GI+FU+FU+FU *  * \n"
			   "P7+KE+FU+KI *  * +GI *  *  * \n"
			   "P8 *  *  * +KA * +KI+OU *  * \n"
			   "P9+KY *  *  *  *  *  *  * +KY\n"
			   "P+00KE00KE00FU\n"
			   "P-00FU00FU00FU00FU\n"
			   "-\n").getInitialState());
    CPPUNIT_ASSERT(TrapRook<WHITE>::isMember
		   (state, PAWN, Position::STAND(), Position(2,5)));
  }
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
