/* ctime.cc
 */
#include "osl/misc/ctime.h"

const char *osl::ctime_r(const time_t *timep, char *buf)
{
#ifdef _MSC_VER
  return "ctime not implemented";
#elif defined __MINGW32__
  /* TODO
   * This ctime() implementation is not good but it would be OK if you do
   * not debug on MINGW. osl::ctime_r is used for debugging.
   */
  return ::ctime(timep);
#else
  return ::ctime_r(timep, buf);
#endif
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
