#include "osl/hash/hashKey.h"
#include <iomanip>
#include <cstdlib>
#include <iostream>
#include <sstream>

namespace osl
{
  BOOST_STATIC_ASSERT(sizeof(HashKey) >= sizeof(int)*5);
} // namespace osl

#ifndef MINIMAL
std::ostream& osl::hash::operator<<(std::ostream& os,const osl::hash::HashKey& h)
{
  os << h.pieceStand();
  const BoardKey& board_key = h.boardKey();
  for (size_t i=0; i<board_key.size(); ++i)
  {
    os << ':' 
       << std::setfill('0') << std::setbase(16) << std::setw(8)
       << board_key[i];
  }
  return os << ':' << std::setbase(10);
}

void osl::hash::HashKey::dumpContents(std::ostream& os) const
{
  os << pieceStand().getFlags();
  for (size_t i=0; i<size(); ++i) {
    os << ' ' << operator[](i);
  }
}

void osl::hash::HashKey::dumpContentsCerr() const
{
  dumpContents(std::cerr);
}

const osl::hash::HashKey osl::hash::HashKey::readFromDump(const std::string& str)
{
  std::istringstream is(str);
  return readFromDump(is);
}

const osl::hash::HashKey osl::hash::HashKey::readFromDump(std::istream& is)
{
  HashKey key;
  int stand;
  is >> stand;
  key.piece_stand = PieceStand(stand);
  for (size_t i=0; i<key.size(); ++i) {
    is >> key[i];
  }
  return key;
}
#endif

osl::hash::HashKey::HashKey(const SimpleState& state)
{
  for(int num=0;num<40;num++){
    Piece p=state.getPieceOf(num);
    Hash_Gen_Table.addHashKey(*this, p.position(),p.ptypeO());
  }
  setPlayer(state.getTurn());
}

const osl::hash::HashKey osl::hash::HashKey::
newHashWithMove(Move move) const
{
  return newMakeMove(move);
}

const osl::hash::HashKey osl::hash::HashKey::
newMakeMove(Move move) const
{
  HashKey ret(*this);
  if (! move.isPass())
  {
    assert(move.isValid());
    Position from=move.from();
    Position to=move.to();
    Ptype capturePtype=move.capturePtype();
    PtypeO ptypeO=move.ptypeO();
    PtypeO oldPtypeO=move.oldPtypeO();
    if (capturePtype!=PTYPE_EMPTY)
    {
      PtypeO capturePtypeO=newPtypeO(alt(move.player()),capturePtype);
      PtypeO capturedPtypeO=captured(capturePtypeO);

      Hash_Gen_Table.subHashKey(ret,to,capturePtypeO);
      Hash_Gen_Table.addHashKey(ret,Position::STAND(),capturedPtypeO);
    }
    Hash_Gen_Table.subHashKey(ret,from,oldPtypeO);
    Hash_Gen_Table.addHashKey(ret,to,ptypeO);
  }
  ret.changeTurn();
  return ret;
}

const osl::hash::HashKey osl::hash::HashKey::
newUnmakeMove(Move move) const
{
  HashKey ret(*this);
  if (! move.isPass())
  {
    assert(move.isValid());
    Position from=move.from();
    Position to=move.to();
    Ptype capturePtype=move.capturePtype();
    PtypeO ptypeO=move.ptypeO();
    PtypeO oldPtypeO=move.oldPtypeO();
    if (capturePtype!=PTYPE_EMPTY)
    {
      PtypeO capturePtypeO=newPtypeO(alt(move.player()),capturePtype);
      PtypeO capturedPtypeO=captured(capturePtypeO);

      Hash_Gen_Table.addHashKey(ret,to,capturePtypeO);
      Hash_Gen_Table.subHashKey(ret,Position::STAND(),capturedPtypeO);
    }
    Hash_Gen_Table.addHashKey(ret,from,oldPtypeO);
    Hash_Gen_Table.subHashKey(ret,to,ptypeO);
  }
  ret.changeTurn();
  return ret;
}
  

osl::hash::HashGenTable::HashGenTable()
{
  for(int j=0;j<PTYPEO_SIZE;j++)
  {
    const PtypeO pjo = (PtypeO)(j+PTYPEO_MIN);
    for(int i=0;i<Position::SIZE;i++)
    {
      if (Position::nth(i) == Position::STAND())
      {
	const Ptype pj = getPtype(pjo);
	if (isBasic(pj) && (getOwner(pjo) == BLACK))
	{
	  PieceStand stand;
	  stand.add(pj);
	  hashKey[i][j].setPieceStand(stand);
	}
      }
      else
      {
	hashKey[i][j].setRandom();
      }
    }
  }
}


// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
