//start of MsdosDate.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * MsdosDate.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util;

//import classes and interfaces
import java.util.Date;
import java.lang.Cloneable;

//import exceptions
import java.lang.IllegalArgumentException;

/**
 * MS-DOS`̎ԏDate̔hNXB<br>
 * f[^ 4bytelłAMS-DOS Intel  x86nCPU
 * 삵Ƃ LittleEndianŊi[B<br>
 * tH[}bg͈ȉ̂ƂB<br>
 * <pre>
 * +---------------+---------------++---------------+---------------+
 * | t-byte | t-byte || -byte | -byte |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-++-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * |7|6|5|4|3|2|1|0|7|6|5|4|3|2|1|0||7|6|5|4|3|2|1|0|7|6|5|4|3|2|1|0|
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-++-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * |   N-7bit   |-4bit| -5bit ||-5bit|  -6bit  | b-5bit |
 * +-------------+-------+---------++---------+-----------+---------+
 * </pre>
 * EN 1980`2107N  0`127 ŕ\BWindows̃VXeAPI
 *   ꕔ 2099N܂łT|[gȂƂ񂪂B<br>
 * E 1`12  1`12ŕ\B0`11łȂƂɒӁB<br>
 * E 1`31  1`31ŕ\B0`30łȂƂɒӁB<br>
 * EԂ 0`23  0`23ŕ\B<br>
 * E 0`59  0`59ŕ\B<br>
 * Eb 0`58b  0`29ŕ\Bb̏̓rbgȂ
 *    ŏPʂ 1błȂ 2błB<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: MsdosDate.java,v $
 * Revision 1.1  2002/12/05 00:00:00  dangan
 * [maintenance]
 *     javadoc Rg̃Xy~XCB
 *     \[X
 *
 * Revision 1.0  2002/07/24 00:00:00  dangan
 * add to version control
 * [bug fix]
 *     setTime()  ftiměExł2bȏ̐xŋL^ĂB
 * [maintenance]
 *     ^u̔p~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1 $
 */
public class MsdosDate extends Date
                       implements Cloneable {


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  public MsdosDate( Date date )
    //  public MsdosDate( int time )
    //------------------------------------------------------------------
    /**
     * date Ŏ鎞Ԃ\ MsdosDate \zB <br>
     * MS-DOS `̎ԏŕ\Ȃׂx̏
     * AŏԒPʂ java.util.Date  1~błȂ
     * MS-DOS `̎ԏ ̍ŏPʂł 2bƂȂB
     * 
     * @param date V\z MsdosDate ̊ɂȂ鎞ԏ
     *              DateIuWFNg
     * 
     * @exception IllegalArgumentException
     *             date  MS-DOSԌ`ňȂ͈͂̎Ԃ
     *             Ăꍇ
     */
    public MsdosDate( Date date ){
        super( ( date.getTime() / 2000L ) * 2000L  );
        this.checkRange();
    }

    /**
     * MS-DOS `̎ԏ񂩂 V MsdosDate \z
     * B
     * 
     * @param time MS-DOS `̎ԏ
     */
    public MsdosDate( int time ){
        super( ( ( time >> 25 ) & 0x7F ) + 80,
               ( ( time >> 21 ) & 0x0F ) - 1,
               ( time >> 16 ) & 0x1F,
               ( time >> 11 ) & 0x1F,
               ( time >> 5 )  & 0x3F,
               ( time << 1 )  & 0x3F );                                         //deprecated

        this.checkRange();
    }


    //------------------------------------------------------------------
    //  method of java.lang.Cloneable
    //------------------------------------------------------------------
    //  public Object clone()
    //------------------------------------------------------------------
    /**
     * ̃IuWFNg̃Rs[ԂB
     * 
     * @return MsdosDateIuWFNg̕
     */
    public Object clone(){
        return new MsdosDate( this );
    }


    //------------------------------------------------------------------
    //  method of java.util.Date
    //------------------------------------------------------------------
    //  access method
    //------------------------------------------------------------------
    //  set method with range check
    //------------------------------------------------------------------
    //  public void setYear( int year )
    //  public void setTime( long time )
    //------------------------------------------------------------------
    /**
     *  MsdosDate ̎N year Ŏw肳ꂽl1900𑫂
     * ̂ɐݒ肷B<br>
     * ̃\bh͔͈̓`FbNŝ߂ɑ݂B<br>
     *
     * @deprecated
     * @param year 1900𑫂ƂŐ\悤 N̒l
     * 
     * @exception IllegalArgumentException
     *             year  MS-DOSԌ`ňȂ͈͂̎Ԃ
     *             Ăꍇ
     */
    public void setYear( int year ){
        if( year < 80 || 207 < year ){
            throw new IllegalArgumentException( "out of MS-DOS time format range." );
        }else{
            super.setYear( year );                                              //deprecated
        }
    }

    /**
     *  MsdosDate ̎Ԃ 1970N11 00:00:00 GMT
     * time ~bo߂ɐݒ肷B<br>
     * MS-DOS `̎ԏŕ\Ȃׂx̏
     * AŏԒPʂ java.util.Date  1~błȂ
     * MS-DOS `̎ԏ ̍ŏPʂł 2bƂȂB
     * 
     * @param time 1970N11 00:00:00GMT ̌o߃~b
     * 
     * @exception IllegalArgumentException
     *             time  MS-DOSԌ`ňȂ͈͂̎Ԃ
     *             Ăꍇ
     */
    public void setTime( long time ){
        int year = ( new Date( time ) ).getYear();
        if( year < 80 || 207 < year ){
            throw new IllegalArgumentException( "out of MS-DOS time format range." );
        }else{
            super.setTime( ( time / 2000L ) * 2000L );
        }
    }


    //------------------------------------------------------------------
    //  original method
    //------------------------------------------------------------------
    //  access method of MS-DOS time format
    //------------------------------------------------------------------
    //  public void setMsdosTime( int time )
    //  public int getMsdosTime()
    //------------------------------------------------------------------
    /**
     *  MsdosDate  MS-DOS Ԍ`̎ԏݒ肷B
     * 
     * @param time MS-DOS Ԍ`̎ԏ
     */
    public void setMsdosTime( int time ){
        Date date = new Date( ( ( time >> 25 ) & 0x7F ) + 80,
                              ( ( time >> 21 ) & 0x0F ) - 1,
                              ( time >> 16 ) & 0x1F,
                              ( time >> 11 ) & 0x1F,
                              ( time >> 5 )  & 0x3F,
                              ( time << 1 )  & 0x3F );                          //deprecated

        this.setTime( date.getTime() );
    }

    /**
     *  MsdosDateԏ MS-DOS Ԍ`œB
     * 
     * @return MS-DOSԌ`̒l
     */
    public int getMsdosTime(){
        return ( ( super.getYear() - 80 ) << 25 )                               //deprecated
               | ( ( super.getMonth() + 1 ) << 21 )                             //deprecated
               | ( super.getDate()    << 16 )                                   //deprecated
               | ( super.getHours()   << 11 )                                   //deprecated
               | ( super.getMinutes() <<  5 )                                   //deprecated
               | ( super.getSeconds() >>  1 );                                  //deprecated
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  private void checkRange()
    //------------------------------------------------------------------
    /**
     *  MsdosDate  MS-DOSԌ`ŕ\鎞Ԃ͈͓̔
     * 邩𔻒肷B
     * 
     * @exception IllegalArgumentException
     *              MsdosDate  MS-DOSԌ`ňȂ
     *             ͈͂̎ԂĂꍇ
     */
    private void checkRange(){
        int year = this.getYear();
        if( year < 80 || 207 < year )
            throw new IllegalArgumentException( "out of MS-DOS time format range." );
    }

}
//end of MsdosDate.java
