// ****************************************************************************
//  Project:        libguytools
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         System information
// ****************************************************************************

#ifndef __TOOLSYSINFO_H__
#define __TOOLSYSINFO_H__

// ------------------------------
//    Constants and Structures
// ------------------------------

const int TOOLSYSINFO_MACADDRLEN_VAL = 6;
const int TOOLSYSINFO_MACADDRLEN_STR = 2*TOOLSYSINFO_MACADDRLEN_VAL;

typedef struct
{
   unsigned char AddrVal [TOOLSYSINFO_MACADDRLEN_VAL  ];
   char          AddrStr [TOOLSYSINFO_MACADDRLEN_STR+1];
} t_ToolSysInfoMacAddr, *t_pToolSysInfoMacAddr;

// ------------------------------
//          Functions
// ------------------------------

APIRET ToolSysInfoGetMacAddr (t_pToolSysInfoMacAddr pMacAddr);
APIRET ToolSysInfoUname      (QString &Uname);

APIRET ToolSysInfoInit   (void);
APIRET ToolSysInfoDeInit (void);


// ------------------------------
//          Error codes
// ------------------------------

enum
{
   TOOLSYSINFO_ALREADY_INITIALISED = ERROR_BASE_TOOL_SYSINFO + 1,
   TOOLSYSINFO_ERROR_SOCKET,
   TOOLSYSINFO_ERROR_NO_ADDR,
   TOOLSYSINFO_ERROR_UNAME
};

#endif

