/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: ScrollingPanel.java,v 1.2 2004/12/12 05:29:27 pietschy Exp $
 */
package org.pietschy.command.demo;

import javax.swing.*;
import java.awt.*;

/**
 * Created by IntelliJ IDEA.
 * User: andrewp
 * Date: 13/04/2004
 * Time: 15:38:07
 * To change this template use Options | File Templates.
 */
public class ScrollingPanel
extends JPanel
implements Scrollable
{
   public ScrollingPanel(LayoutManager layout, boolean isDoubleBuffered)
   {
      super(layout, isDoubleBuffered);
   }

   public ScrollingPanel(LayoutManager layout)
   {
      super(layout);
   }

   public ScrollingPanel(boolean isDoubleBuffered)
   {
      super(isDoubleBuffered);
   }

   public ScrollingPanel()
   {
   }

   public Dimension getPreferredScrollableViewportSize()
   {
      return getPreferredSize();
   }


   public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction)
   {
      switch (orientation)
      {
         case SwingConstants.VERTICAL:
            return visibleRect.height / 10;
         case SwingConstants.HORIZONTAL:
            return visibleRect.width / 10;
         default:
            throw new IllegalArgumentException("Invalid orientation: " + orientation);
      }
   }


   public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction)
   {
      switch (orientation)
      {
         case SwingConstants.VERTICAL:
            return visibleRect.height;
         case SwingConstants.HORIZONTAL:
            return visibleRect.width;
         default:
            throw new IllegalArgumentException("Invalid orientation: " + orientation);
      }
   }

   public boolean getScrollableTracksViewportWidth()
   {
      return true;
   }

   public boolean getScrollableTracksViewportHeight()
   {
      // if my parent is taller than me then we track..
      if (getParent() instanceof JViewport)
      {
         return ((getParent()).getHeight() > getPreferredSize().height);
      }

      // otherwise we scroll.
      return false;
   }
}
