/* GNOME Transcript
 * Copyright (C) 1999 the Free Software Foundation
 * Authors: Matias Mutchinick
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <glib.h>
#include "gtrans_ifase_conn.h"


GList *
gtrans_ifase_table_designer_attr_names(GTransIFaseConn *conn)
{
	g_return_val_if_fail(conn != NULL,NULL);
	
	return conn->TableDesignerAttrNames();
}


GList *
gtrans_ifase_table_designer_attr_vals(GTransIFaseConn *conn)
{
	g_return_val_if_fail(conn != NULL,NULL);
	
	return conn->TableDesignerAttrVals();
}



GList *
gtrans_ifase_table_designer_field_types(GTransIFaseConn *conn)
{
	g_return_val_if_fail(conn != NULL,NULL);
	
	return conn->TableDesignerFieldTypes();
}


GList *
gtrans_ifase_table_designer_type_masks(GTransIFaseConn *conn)
{
	g_return_val_if_fail(conn != NULL,NULL);
	
	return conn->TableDesignerTypeMasks();
}



gchar *
gtrans_ifase_table_designer_create_table(GTransIFaseConn *conn,
					 gchar           *name,
					 GList           *rows)
{
       	g_return_val_if_fail(conn != NULL,
			     g_strdup("Fatal Error: NULL connection"));
	
	return conn->TableDesignerCreateTable(conn,name,rows);
}



