# $Id: libgnurdf.spec.in,v 1.3 2001/09/20 23:14:35 chipx86 Exp $

%define name    libgnurdf
%define ver     0.3.0
%define RELEASE 1
%define rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define prefix  /usr
%{expand:%%define share %(if [ -d %{prefix}/share/man ]; then echo /share ; else echo %%{nil} ; fi)}
%ifos linux
%define CONFIG_FLAGS --prefix=%prefix --infodir='%{prefix}%{share}/info' --mandir='%{prefix}%{share}/man'
%else
%define CONFIG_FLAGS --prefix=%prefix
%endif

Summary:       A library for parsing and processing RDF files.
Name:          %name
Version:       %ver
Release:       %rel
Copyright:     LGPL
Group:         System Environment/Libraries
Source:        ftp://ftp.gnupdate.org/pub/gnupdate/tarballs/%{name}-%{ver}.tar.gz
URL:           http://www.gnupdate.org/
Prefix:        %prefix
BuildRoot:     /var/tmp/%{name}-%{version}-root
Packager:      Christian Hammond <chipx86@portaldesign.net>

%description
The libgnurdf (GNUpdate RDF) library provides a simple interface for parsing
and generating RDF, the Resource Description Format.


%package       devel
Summary:       Headers for developing programs that use libgnurdf.
Group:         Development/Libraries
Requires:      %name = %{PACKAGE_VERSION}

%description   devel
This package contains the header files that programmers would use to develop
programs that use the libgnurdf library.

%prep
%setup

%build
if [ ! -z "`echo -n ${RPM_OPT_FLAGS} | grep pentium`"]; then
	if [ ! -z `which egcs` ]; then
		CC="egcs"
	else
		if [ ! -z `which pgcc` ]; then
			CC="pgcs"
		fi
	fi
	CFLAGS="${RPM_OPT_FLAGS}"
else
	CFLAGS="${RPM_OPT_FLAGS}"
fi

#if [ ! -f configure ]; then
	CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh %{CONFIG_FLAGS}
#else
#	CFLAGS="$RPM_OPT_FLAGS" ./configure %{CONFIG_FLAGS}
#fi

make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install
gzip -n -9f $RPM_BUILD_ROOT%{prefix}%{share}/info/libgnurdf.info*

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%post devel
/sbin/install-info %{prefix}%{share}/info/libgnurdf.info.gz %{prefix}%{share}/info/dir

%preun devel
if [ $1 = 0 ]; then
	/sbin/install-info --delete %{prefix}%{share}/info/libgnurdf.info.gz %{prefix}%{share}/info/dir
fi

%files
%defattr(-, root, root)

%{prefix}/lib/lib*.so.*

%doc AUTHORS
%doc COPYING
%doc ChangeLog
%doc NEWS
%doc README
%doc TODO

%files devel
%defattr(-, root, root)

%doc docs/api/html
%{prefix}/bin/*
%{prefix}/lib/lib*.so
%{prefix}/lib/*.a
%{prefix}/lib/*.la
%{prefix}/include/*
%{prefix}/share/aclocal/*
%{prefix}%{share}/man/man1/*
%{prefix}%{share}/man/man3/*
%{prefix}%{share}/info/libgnurdf.info*

##########################################################################

%changelog
* Sun Sep 9 2001 Christian Hammond <chipx86@portaldesign.net>
- Bumped the version up to v0.3.0.

* Thu Jul 26 2001 Christian Hammond <chipx86@portaldesign.net>
- Bumped the version up to v0.2.3.

* Mon Jul 2 2001  Christian Hammond <chipx86@portaldesign.net>
- Bumped the version up to v0.2.2.

* Fri Jun 1 2001  Christian Hammond <chipx86@portaldesign.net>
- Fixed this up with better documentation.
- Bumped the version up to v0.2.1.

* Sat Aug 5 2000  Christian Hammond <chipx86@portaldesign.net>
- Created the first version of this libgnurdf.spec
