#!/bin/bash

export PATH=`pwd`/install/bin:/usr/bin:/bin

echo "gnatls="`which gnatls 2>/dev/null | grep -v "no gnatls"`
echo "arm-eabi-gnatls="`which arm-eabi-gnatls`

expect() {
   prj=$1;
   rm -f auto.cgpr;
   echo "==== '$j' '' '' ====="
   ./main $prj
   grep batch auto.cgpr
   grep Target auto.cgpr

   echo "==== '$j' 'zfp' 'arm-eabi' ====="
   ./main $prj zfp arm-eabi
   grep batch auto.cgpr
   grep Target auto.cgpr

   echo "==== '$j' '' 'arm-eabi' ====="
   ./main $prj '' arm-eabi
   grep batch auto.cgpr
   grep Target auto.cgpr
}

for j in d?.gpr; do
  expect $j
done
