//    GMPAda, binding to the Ada Language for the GNU MultiPrecision library.
//    Copyright (C) 2007 Nicolas Boulenguez <nicolas.boulenguez@free.fr>
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.

#include <stdio.h>
#include <stdlib.h>
#include <gmp.h>
#include <mpfr.h>
#include <error.h>

int main (int argc, char* argv[])
{
  const __mpz_struct z;
  
  if (sizeof(z._mp_alloc) != sizeof(int)        ||
      sizeof(z._mp_size)  != sizeof(int)        ||
      sizeof(z._mp_d)     != sizeof(mp_limb_t*) ||
      sizeof(z._mp_alloc)+sizeof(z._mp_size)+sizeof(z._mp_d) != sizeof(mpz_t))
    {
      error (1, 0, "\n\
An incompatible change of mpz_t has been detected in gmp.h.\n\
Please report this to the Ada binding author.\n");
    }
  printf ("--  Generated by the C program %s.c.\n", argv[0]);
  printf ("--  Do not edit this file directly.\n");
  printf ("--  The values provided here may vary on your system.\n");
  printf ("\n");
  printf ("package GMP.Constants is\n");
  printf ("   Gmp_Version : constant String := \"%s\";\n", gmp_version);
  printf ("   Mp_Bits_Per_Limb : constant := %i;\n", mp_bits_per_limb);
  printf ("   Gnu_Mp_Version : constant := %i;\n", __GNU_MP_VERSION);
  printf ("   Gnu_Mp_Version_Minor : constant := %i;\n", __GNU_MP_VERSION_MINOR);
  printf ("   Gnu_Mp_Version_Patchlevel : constant := %i;\n", __GNU_MP_VERSION_PATCHLEVEL);
  printf ("   Mp_Exp_T_Size : constant := %i;\n", 8*sizeof(mp_exp_t));
  printf ("   Mp_Size_T_Size : constant := %i;\n", 8*sizeof(mp_size_t));
  printf ("   Mp_Limb_T_Size : constant := %i;\n", 8*sizeof(mp_limb_t));
  printf ("   Mpz_Alloc_Start : constant := %i;\n", (char*)&z._mp_alloc - (char*)&z);
  printf ("   Mpz_Alloc_Length : constant := %i;\n", 8 * sizeof (z._mp_alloc));
  printf ("   Mpz_Size_Start : constant := %i;\n", (char*)&z._mp_size  - (char*)&z);
  printf ("   Mpz_Size_Length : constant := %i;\n", 8 * sizeof (z._mp_size));
  printf ("   Mpz_D_Start : constant := %i;\n", (char*)&z._mp_d     - (char*)&z);
  printf ("   Mpz_D_Length : constant := %i;\n", 8 * sizeof (z._mp_d));
  printf ("   Sizeof_Mpq_T : constant := %i;\n", sizeof(mpq_t));
  printf ("   Sizeof_Mpf_T : constant := %i;\n", sizeof(mpf_t));
  printf ("   Sizeof_Gmp_Randstate_T : constant := %i;\n", sizeof(gmp_randstate_t));
  printf ("   Sizeof_Mpfr_T : constant := %i;\n", sizeof(mpfr_t));
  printf ("   Mp_Prec_T_Size : constant := %i;\n", 8*sizeof(mp_prec_t));
  printf ("   Mpfr_Prec_Min : constant := %i;\n", MPFR_PREC_MIN);
  printf ("   Mpfr_Prec_Max : constant := %lu;\n", MPFR_PREC_MAX);
  printf ("   Mp_Rnd_T_Size : constant := %i;\n", 8*sizeof(mp_rnd_t));
  printf ("   Gmp_Rndn : constant := %i;\n", GMP_RNDN);
  printf ("   Gmp_Rndz : constant := %i;\n", GMP_RNDZ);
  printf ("   Gmp_Rndu : constant := %i;\n", GMP_RNDU);
  printf ("   Gmp_Rndd : constant := %i;\n", GMP_RNDD);
  printf ("end GMP.Constants;\n");
  exit (EXIT_SUCCESS);
}
