/*
******************************************************************************

   Demo of the LibGGIMisc extension.

   Copyright (c) 2001 Brian S. Julin		bri@calyx.com
   Copyright (C) 1998 Andreas Beck              becka@ggi-project.org
   Copyright (C) 1997 Uwe Maurer                uwe_maurer@t-online.de
   
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   The above copyright notice applies to all files in this package, unless 
   explicitly stated otherwise in the file itself or in a file named COPYING 
   in the same directory as the file.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.



******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>

#include <ggi/ggi.h>
#include <ggi/misc.h>

int main(void)
{
	ggi_visual_t vis;
	ggi_color col;
        ggi_mode mode;
        int temp, inc, incy, width, height;
	sint32 x,y;
	int cx, cy;
	char *str;

	/* Initialize LibGGI */
	if (ggiInit() != 0) {
		fprintf(stderr, "Unable to initialize LibGGI\n");
		exit(1);
	}
	
	/* Initialize LibGGIMisc extension */
	if (ggiMiscInit() != 0) {
		ggiPanic("Unable to initialize LibGGIMisc extension\n");
	}

	/* Open the default visual */
	if ((vis = ggiOpen(NULL)) == NULL) {
		ggiPanic("Unable to open default visual\n");
	}
	
	/* Turn on asynchronous mode (which should always be used) */
	ggiSetFlags(vis, GGIFLAG_ASYNC);
	
	/* Set the default mode */
	if (ggiSetSimpleMode(vis, GGI_AUTO, GGI_AUTO, GGI_AUTO, GT_AUTO) < 0) {
		ggiPanic("Unable to set default mode\n");
	}
	
	/* Attach the LibGGIMisc extension to the visual */
	if (ggiMiscAttach(vis) < 0) {
		ggiPanic("Unable to attach LibGGIMisc extension to visual\n");
	}

	/* Try the API functions */

	/*-* Edit and uncomment the calls to test */

	/* Set foreground color to white */
        col.r = 0xffff;
        col.g = 0xffff;
        col.b = 0xffff;
        ggiSetGCForeground(vis, ggiMapColor(vis, &col));

        col.r = 0x8888;
        col.g = 0;
        col.b = 0;
        ggiSetGCBackground(vis, ggiMapColor(vis, &col));

        /* Check what mode we actually got */
        ggiGetMode(vis, &mode);
        width = mode.visible.x;
        height = mode.visible.y;
        
        /* Draw a bunch of lines... */
        inc = height/66;
        for (temp = 0; temp <= (height-inc); temp += inc) {
	  ggiDrawLine(vis, 0, temp, width-1, height-temp);
        }

        /* ...and flush the screen */
        ggiFlush(vis);

	/* Now test the splitline feature */
        for (temp = 0; temp < height; temp++) { 
	  ggiSetSplitline(vis, temp);
	  ggiFlush(vis);
	  if (ggiKbhit(vis)) {
	    int c = ggiGetc(vis);
	    if (c == 'q' || c == 'Q' || c == GIIUC_Escape) break;
	  }
	  ggUSleep(10000);
        }

	x = y = cx = cy = 0;
	ggiGetCharSize(vis, &inc, &incy);
	inc *= 36;
	str = calloc(46, sizeof(char));
        while (cx < width - inc) {
	  char *strx, *stry;
	  if (ggiGetRayPos(vis, &x, &y)) {
	    printf("GetRayPos Failed.  Won't run WaitRayPos tests.\n");
	    break;
	  }
	  switch(x) {
	  case GGI_RP_BORDER:
	    strx = "GGI_RP_BORDER";
	    break;
	  case GGI_RP_BLANK:
	    strx = " GGI_RP_BLANK";
	    break;
	  case GGI_RP_SYNC:
	    strx = "  GGI_RP_SYNC";
	    break;
	  default:
	    strx = NULL;
	  }
	  switch(y) {
	  case GGI_RP_BORDER:
	    stry = "GGI_RP_BORDER";
	    break;
	  case GGI_RP_BLANK:
	    stry = " GGI_RP_BLANK";
	    break;
	  case GGI_RP_SYNC:
	    stry = "  GGI_RP_SYNC";
	    break;
	  default:
	    stry = NULL;
	  }
	  if (strx != NULL) {
	    if (stry != NULL) snprintf(str, 45, "RayPos %s, %s", strx, stry);
	    else snprintf(str, 45, "RayPos %s, %13d", strx, y);
	  }
	  else if (stry != NULL) snprintf(str, 45, "RayPos %13d, %s", x, stry);
	  else snprintf(str, 45, "RayPos %13d, %13d", x, y);
	  ggiPuts(vis, cx, cy, str);
	  cy += incy;
	  if (cy > height - incy) {
	    cy = 0; 
	    cx += inc;
	  }
	  ggUSleep(100);
        }
	free(str);

	/* Detach the LibGGIMisc extension from visual */
	ggiMiscDetach(vis);

	/* Close visual */
	ggiClose(vis);

	/* Deinitialize LibGGIMisc extension */
	ggiMiscExit();

	/* Deinitialize LibGGI */
	ggiExit();

	return 0;
}
