/* abstractcollection.c generated by valac, the Vala compiler
 * generated from abstractcollection.vala, do not modify */

/* abstractcollection.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define GEE_TYPE_READ_ONLY_COLLECTION (gee_read_only_collection_get_type ())
#define GEE_READ_ONLY_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollection))
#define GEE_READ_ONLY_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollectionClass))
#define GEE_IS_READ_ONLY_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_READ_ONLY_COLLECTION))
#define GEE_IS_READ_ONLY_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_READ_ONLY_COLLECTION))
#define GEE_READ_ONLY_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollectionClass))

typedef struct _GeeReadOnlyCollection GeeReadOnlyCollection;
typedef struct _GeeReadOnlyCollectionClass GeeReadOnlyCollectionClass;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeAbstractCollectionPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeCollection* _read_only_view;
};


static gpointer gee_abstract_collection_parent_class = NULL;
static GeeIterableIface* gee_abstract_collection_gee_iterable_parent_iface = NULL;
static GeeCollectionIface* gee_abstract_collection_gee_collection_parent_iface = NULL;

GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
#define GEE_ABSTRACT_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionPrivate))
enum  {
	GEE_ABSTRACT_COLLECTION_DUMMY_PROPERTY,
	GEE_ABSTRACT_COLLECTION_SIZE,
	GEE_ABSTRACT_COLLECTION_IS_EMPTY,
	GEE_ABSTRACT_COLLECTION_ELEMENT_TYPE,
	GEE_ABSTRACT_COLLECTION_READ_ONLY_VIEW,
	GEE_ABSTRACT_COLLECTION_G_TYPE,
	GEE_ABSTRACT_COLLECTION_G_DUP_FUNC,
	GEE_ABSTRACT_COLLECTION_G_DESTROY_FUNC
};
gboolean gee_abstract_collection_contains (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_abstract_collection_real_contains (GeeAbstractCollection* self, gconstpointer item);
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_abstract_collection_real_add (GeeAbstractCollection* self, gconstpointer item);
gboolean gee_abstract_collection_remove (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_abstract_collection_real_remove (GeeAbstractCollection* self, gconstpointer item);
void gee_abstract_collection_clear (GeeAbstractCollection* self);
static void gee_abstract_collection_real_clear (GeeAbstractCollection* self);
static gboolean* gee_abstract_collection_to_bool_array (GeeCollection* coll, int* result_length1);
static gchar* gee_abstract_collection_to_char_array (GeeCollection* coll, int* result_length1);
static guchar* gee_abstract_collection_to_uchar_array (GeeCollection* coll, int* result_length1);
static gint* gee_abstract_collection_to_int_array (GeeCollection* coll, int* result_length1);
static guint* gee_abstract_collection_to_uint_array (GeeCollection* coll, int* result_length1);
static gint64* gee_abstract_collection_to_int64_array (GeeCollection* coll, int* result_length1);
static guint64* gee_abstract_collection_to_uint64_array (GeeCollection* coll, int* result_length1);
static glong* gee_abstract_collection_to_long_array (GeeCollection* coll, int* result_length1);
static gulong* gee_abstract_collection_to_ulong_array (GeeCollection* coll, int* result_length1);
static float* gee_abstract_collection_to_float_array (GeeCollection* coll, int* result_length1);
static double* gee_abstract_collection_to_double_array (GeeCollection* coll, int* result_length1);
gint gee_collection_get_size (GeeCollection* self);
GeeIterator* gee_abstract_collection_iterator (GeeAbstractCollection* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
gpointer* gee_abstract_collection_to_array (GeeAbstractCollection* self, int* result_length1);
static gpointer* gee_abstract_collection_real_to_array (GeeAbstractCollection* self, int* result_length1);
GeeIterator* gee_iterable_iterator (GeeIterable* self);
gboolean gee_collection_get_is_empty (GeeCollection* self);
gboolean gee_abstract_collection_add_all (GeeAbstractCollection* self, GeeCollection* collection);
static gboolean gee_abstract_collection_real_add_all (GeeAbstractCollection* self, GeeCollection* collection);
gboolean gee_abstract_collection_contains_all (GeeAbstractCollection* self, GeeCollection* collection);
static gboolean gee_abstract_collection_real_contains_all (GeeAbstractCollection* self, GeeCollection* collection);
gboolean gee_abstract_collection_remove_all (GeeAbstractCollection* self, GeeCollection* collection);
static gboolean gee_abstract_collection_real_remove_all (GeeAbstractCollection* self, GeeCollection* collection);
gboolean gee_collection_contains (GeeCollection* self, gconstpointer item);
gboolean gee_abstract_collection_retain_all (GeeAbstractCollection* self, GeeCollection* collection);
static gboolean gee_abstract_collection_real_retain_all (GeeAbstractCollection* self, GeeCollection* collection);
static GeeIterator* gee_abstract_collection_real_iterator (GeeAbstractCollection* self);
GeeAbstractCollection* gee_abstract_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
gboolean gee_abstract_collection_get_is_empty (GeeAbstractCollection* self);
GeeReadOnlyCollection* gee_read_only_collection_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeCollection* collection);
GeeReadOnlyCollection* gee_read_only_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeCollection* collection);
GType gee_read_only_collection_get_type (void) G_GNUC_CONST;
GeeCollection* gee_abstract_collection_get_read_only_view (GeeAbstractCollection* self);
static void gee_abstract_collection_finalize (GObject* obj);
GType gee_iterable_get_element_type (GeeIterable* self);
static void gee_abstract_collection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_abstract_collection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



/**
 * {@inheritDoc}
 */
#line 50 "abstractcollection.vala"
static gboolean gee_abstract_collection_real_contains (GeeAbstractCollection* self, gconstpointer item) {
#line 219 "abstractcollection.c"
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_contains'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


#line 50 "abstractcollection.vala"
gboolean gee_abstract_collection_contains (GeeAbstractCollection* self, gconstpointer item) {
#line 50 "abstractcollection.vala"
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->contains (self, item);
#line 230 "abstractcollection.c"
}


/**
 * {@inheritDoc}
 */
#line 55 "abstractcollection.vala"
static gboolean gee_abstract_collection_real_add (GeeAbstractCollection* self, gconstpointer item) {
#line 239 "abstractcollection.c"
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_add'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


#line 55 "abstractcollection.vala"
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item) {
#line 55 "abstractcollection.vala"
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->add (self, item);
#line 250 "abstractcollection.c"
}


/**
 * {@inheritDoc}
 */
#line 60 "abstractcollection.vala"
static gboolean gee_abstract_collection_real_remove (GeeAbstractCollection* self, gconstpointer item) {
#line 259 "abstractcollection.c"
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_remove'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


#line 60 "abstractcollection.vala"
gboolean gee_abstract_collection_remove (GeeAbstractCollection* self, gconstpointer item) {
#line 60 "abstractcollection.vala"
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->remove (self, item);
#line 270 "abstractcollection.c"
}


/**
 * {@inheritDoc}
 */
#line 65 "abstractcollection.vala"
static void gee_abstract_collection_real_clear (GeeAbstractCollection* self) {
#line 279 "abstractcollection.c"
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_clear'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


#line 65 "abstractcollection.vala"
void gee_abstract_collection_clear (GeeAbstractCollection* self) {
#line 65 "abstractcollection.vala"
	GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->clear (self);
#line 290 "abstractcollection.c"
}


/**
 * {@inheritDoc}
 */
#line 70 "abstractcollection.vala"
static gpointer* gee_abstract_collection_real_to_array (GeeAbstractCollection* self, int* result_length1) {
#line 299 "abstractcollection.c"
	gpointer* result = NULL;
	GType t;
#line 70 "abstractcollection.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 71 "abstractcollection.vala"
	t = self->priv->g_type;
#line 72 "abstractcollection.vala"
	if (t == G_TYPE_BOOLEAN) {
#line 308 "abstractcollection.c"
		gint _tmp0_;
		gpointer* _tmp1_;
		result = (_tmp1_ = (gpointer*) gee_abstract_collection_to_bool_array (GEE_COLLECTION (self), &_tmp0_), *result_length1 = _tmp0_, _tmp1_);
#line 73 "abstractcollection.vala"
		return result;
#line 314 "abstractcollection.c"
	} else {
#line 74 "abstractcollection.vala"
		if (t == G_TYPE_CHAR) {
#line 318 "abstractcollection.c"
			gint _tmp2_;
			gpointer* _tmp3_;
			result = (_tmp3_ = (gpointer*) gee_abstract_collection_to_char_array (GEE_COLLECTION (self), &_tmp2_), *result_length1 = _tmp2_, _tmp3_);
#line 75 "abstractcollection.vala"
			return result;
#line 324 "abstractcollection.c"
		} else {
#line 76 "abstractcollection.vala"
			if (t == G_TYPE_UCHAR) {
#line 328 "abstractcollection.c"
				gint _tmp4_;
				gpointer* _tmp5_;
				result = (_tmp5_ = (gpointer*) gee_abstract_collection_to_uchar_array (GEE_COLLECTION (self), &_tmp4_), *result_length1 = _tmp4_, _tmp5_);
#line 77 "abstractcollection.vala"
				return result;
#line 334 "abstractcollection.c"
			} else {
#line 78 "abstractcollection.vala"
				if (t == G_TYPE_INT) {
#line 338 "abstractcollection.c"
					gint _tmp6_;
					gpointer* _tmp7_;
					result = (_tmp7_ = (gpointer*) gee_abstract_collection_to_int_array (GEE_COLLECTION (self), &_tmp6_), *result_length1 = _tmp6_, _tmp7_);
#line 79 "abstractcollection.vala"
					return result;
#line 344 "abstractcollection.c"
				} else {
#line 80 "abstractcollection.vala"
					if (t == G_TYPE_UINT) {
#line 348 "abstractcollection.c"
						gint _tmp8_;
						gpointer* _tmp9_;
						result = (_tmp9_ = (gpointer*) gee_abstract_collection_to_uint_array (GEE_COLLECTION (self), &_tmp8_), *result_length1 = _tmp8_, _tmp9_);
#line 81 "abstractcollection.vala"
						return result;
#line 354 "abstractcollection.c"
					} else {
#line 82 "abstractcollection.vala"
						if (t == G_TYPE_INT64) {
#line 358 "abstractcollection.c"
							gint _tmp10_;
							gpointer* _tmp11_;
							result = (_tmp11_ = (gpointer*) gee_abstract_collection_to_int64_array (GEE_COLLECTION (self), &_tmp10_), *result_length1 = _tmp10_, _tmp11_);
#line 83 "abstractcollection.vala"
							return result;
#line 364 "abstractcollection.c"
						} else {
#line 84 "abstractcollection.vala"
							if (t == G_TYPE_UINT64) {
#line 368 "abstractcollection.c"
								gint _tmp12_;
								gpointer* _tmp13_;
								result = (_tmp13_ = (gpointer*) gee_abstract_collection_to_uint64_array (GEE_COLLECTION (self), &_tmp12_), *result_length1 = _tmp12_, _tmp13_);
#line 85 "abstractcollection.vala"
								return result;
#line 374 "abstractcollection.c"
							} else {
#line 86 "abstractcollection.vala"
								if (t == G_TYPE_LONG) {
#line 378 "abstractcollection.c"
									gint _tmp14_;
									gpointer* _tmp15_;
									result = (_tmp15_ = (gpointer*) gee_abstract_collection_to_long_array (GEE_COLLECTION (self), &_tmp14_), *result_length1 = _tmp14_, _tmp15_);
#line 87 "abstractcollection.vala"
									return result;
#line 384 "abstractcollection.c"
								} else {
#line 88 "abstractcollection.vala"
									if (t == G_TYPE_ULONG) {
#line 388 "abstractcollection.c"
										gint _tmp16_;
										gpointer* _tmp17_;
										result = (_tmp17_ = (gpointer*) gee_abstract_collection_to_ulong_array (GEE_COLLECTION (self), &_tmp16_), *result_length1 = _tmp16_, _tmp17_);
#line 89 "abstractcollection.vala"
										return result;
#line 394 "abstractcollection.c"
									} else {
#line 90 "abstractcollection.vala"
										if (t == G_TYPE_FLOAT) {
#line 398 "abstractcollection.c"
											gint _tmp18_;
											gpointer* _tmp19_;
											result = (_tmp19_ = (gpointer*) gee_abstract_collection_to_float_array (GEE_COLLECTION (self), &_tmp18_), *result_length1 = _tmp18_, _tmp19_);
#line 91 "abstractcollection.vala"
											return result;
#line 404 "abstractcollection.c"
										} else {
#line 92 "abstractcollection.vala"
											if (t == G_TYPE_DOUBLE) {
#line 408 "abstractcollection.c"
												gint _tmp20_;
												gpointer* _tmp21_;
												result = (_tmp21_ = (gpointer*) gee_abstract_collection_to_double_array (GEE_COLLECTION (self), &_tmp20_), *result_length1 = _tmp20_, _tmp21_);
#line 93 "abstractcollection.vala"
												return result;
#line 414 "abstractcollection.c"
											} else {
												gpointer* _tmp23_;
												gint _array_size_;
												gint array_length1;
												gint _tmp22_;
												gpointer* array;
												gint index;
												gpointer* _tmp27_;
												array = (_tmp23_ = g_new0 (gpointer, _tmp22_ = gee_collection_get_size ((GeeCollection*) self)), array_length1 = _tmp22_, _array_size_ = array_length1, _tmp23_);
#line 96 "abstractcollection.vala"
												index = 0;
#line 426 "abstractcollection.c"
												{
													GeeIterator* _element_it;
#line 97 "abstractcollection.vala"
													_element_it = gee_abstract_collection_iterator (self);
#line 97 "abstractcollection.vala"
													while (TRUE) {
#line 433 "abstractcollection.c"
														gpointer element;
														gpointer _tmp26_;
														gpointer *_tmp25_;
														gconstpointer _tmp24_;
#line 97 "abstractcollection.vala"
														if (!gee_iterator_next (_element_it)) {
#line 97 "abstractcollection.vala"
															break;
#line 442 "abstractcollection.c"
														}
#line 97 "abstractcollection.vala"
														element = gee_iterator_get (_element_it);
#line 98 "abstractcollection.vala"
														_tmp25_ = &array[index++];
#line 98 "abstractcollection.vala"
														(*_tmp25_) = (_tmp26_ = (_tmp24_ = element, ((_tmp24_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp24_) : self->priv->g_dup_func ((gpointer) _tmp24_)), (((*_tmp25_) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp25_) = (self->priv->g_destroy_func ((*_tmp25_)), NULL)), _tmp26_);
#line 450 "abstractcollection.c"
														((element == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (element = (self->priv->g_destroy_func (element), NULL));
													}
													_g_object_unref0 (_element_it);
												}
												result = (_tmp27_ = array, *result_length1 = array_length1, _tmp27_);
#line 100 "abstractcollection.vala"
												return result;
#line 458 "abstractcollection.c"
												array = (_vala_array_free (array, array_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


#line 70 "abstractcollection.vala"
gpointer* gee_abstract_collection_to_array (GeeAbstractCollection* self, int* result_length1) {
#line 70 "abstractcollection.vala"
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->to_array (self, result_length1);
#line 478 "abstractcollection.c"
}


#line 104 "abstractcollection.vala"
static gboolean* gee_abstract_collection_to_bool_array (GeeCollection* coll, int* result_length1) {
#line 484 "abstractcollection.c"
	gboolean* result = NULL;
	gboolean* _tmp1_;
	gint _array_size_;
	gint array_length1;
	gint _tmp0_;
	gboolean* array;
	gint index;
	gboolean* _tmp2_;
#line 104 "abstractcollection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 495 "abstractcollection.c"
	array = (_tmp1_ = g_new0 (gboolean, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
#line 106 "abstractcollection.vala"
	index = 0;
#line 499 "abstractcollection.c"
	{
		GeeIterator* _element_it;
#line 107 "abstractcollection.vala"
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
#line 107 "abstractcollection.vala"
		while (TRUE) {
#line 506 "abstractcollection.c"
			gboolean element;
#line 107 "abstractcollection.vala"
			if (!gee_iterator_next (_element_it)) {
#line 107 "abstractcollection.vala"
				break;
#line 512 "abstractcollection.c"
			}
#line 107 "abstractcollection.vala"
			element = GPOINTER_TO_INT (gee_iterator_get (_element_it));
#line 108 "abstractcollection.vala"
			array[index++] = element;
#line 518 "abstractcollection.c"
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp2_ = array, *result_length1 = array_length1, _tmp2_);
#line 110 "abstractcollection.vala"
	return result;
#line 525 "abstractcollection.c"
	array = (g_free (array), NULL);
}


#line 113 "abstractcollection.vala"
static gchar* gee_abstract_collection_to_char_array (GeeCollection* coll, int* result_length1) {
#line 532 "abstractcollection.c"
	gchar* result = NULL;
	gchar* _tmp1_;
	gint _array_size_;
	gint array_length1;
	gint _tmp0_;
	gchar* array;
	gint index;
	gchar* _tmp2_;
#line 113 "abstractcollection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 543 "abstractcollection.c"
	array = (_tmp1_ = g_new0 (gchar, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
#line 115 "abstractcollection.vala"
	index = 0;
#line 547 "abstractcollection.c"
	{
		GeeIterator* _element_it;
#line 116 "abstractcollection.vala"
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
#line 116 "abstractcollection.vala"
		while (TRUE) {
#line 554 "abstractcollection.c"
			gchar element;
#line 116 "abstractcollection.vala"
			if (!gee_iterator_next (_element_it)) {
#line 116 "abstractcollection.vala"
				break;
#line 560 "abstractcollection.c"
			}
#line 116 "abstractcollection.vala"
			element = GPOINTER_TO_INT (gee_iterator_get (_element_it));
#line 117 "abstractcollection.vala"
			array[index++] = element;
#line 566 "abstractcollection.c"
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp2_ = array, *result_length1 = array_length1, _tmp2_);
#line 119 "abstractcollection.vala"
	return result;
#line 573 "abstractcollection.c"
	array = (g_free (array), NULL);
}


#line 122 "abstractcollection.vala"
static guchar* gee_abstract_collection_to_uchar_array (GeeCollection* coll, int* result_length1) {
#line 580 "abstractcollection.c"
	guchar* result = NULL;
	guchar* _tmp1_;
	gint _array_size_;
	gint array_length1;
	gint _tmp0_;
	guchar* array;
	gint index;
	guchar* _tmp2_;
#line 122 "abstractcollection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 591 "abstractcollection.c"
	array = (_tmp1_ = g_new0 (guchar, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
#line 124 "abstractcollection.vala"
	index = 0;
#line 595 "abstractcollection.c"
	{
		GeeIterator* _element_it;
#line 125 "abstractcollection.vala"
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
#line 125 "abstractcollection.vala"
		while (TRUE) {
#line 602 "abstractcollection.c"
			guchar element;
#line 125 "abstractcollection.vala"
			if (!gee_iterator_next (_element_it)) {
#line 125 "abstractcollection.vala"
				break;
#line 608 "abstractcollection.c"
			}
#line 125 "abstractcollection.vala"
			element = GPOINTER_TO_UINT (gee_iterator_get (_element_it));
#line 126 "abstractcollection.vala"
			array[index++] = element;
#line 614 "abstractcollection.c"
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp2_ = array, *result_length1 = array_length1, _tmp2_);
#line 128 "abstractcollection.vala"
	return result;
#line 621 "abstractcollection.c"
	array = (g_free (array), NULL);
}


#line 131 "abstractcollection.vala"
static gint* gee_abstract_collection_to_int_array (GeeCollection* coll, int* result_length1) {
#line 628 "abstractcollection.c"
	gint* result = NULL;
	gint* _tmp1_;
	gint _array_size_;
	gint array_length1;
	gint _tmp0_;
	gint* array;
	gint index;
	gint* _tmp2_;
#line 131 "abstractcollection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 639 "abstractcollection.c"
	array = (_tmp1_ = g_new0 (gint, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
#line 133 "abstractcollection.vala"
	index = 0;
#line 643 "abstractcollection.c"
	{
		GeeIterator* _element_it;
#line 134 "abstractcollection.vala"
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
#line 134 "abstractcollection.vala"
		while (TRUE) {
#line 650 "abstractcollection.c"
			gint element;
#line 134 "abstractcollection.vala"
			if (!gee_iterator_next (_element_it)) {
#line 134 "abstractcollection.vala"
				break;
#line 656 "abstractcollection.c"
			}
#line 134 "abstractcollection.vala"
			element = GPOINTER_TO_INT (gee_iterator_get (_element_it));
#line 135 "abstractcollection.vala"
			array[index++] = element;
#line 662 "abstractcollection.c"
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp2_ = array, *result_length1 = array_length1, _tmp2_);
#line 137 "abstractcollection.vala"
	return result;
#line 669 "abstractcollection.c"
	array = (g_free (array), NULL);
}


#line 140 "abstractcollection.vala"
static guint* gee_abstract_collection_to_uint_array (GeeCollection* coll, int* result_length1) {
#line 676 "abstractcollection.c"
	guint* result = NULL;
	guint* _tmp1_;
	gint _array_size_;
	gint array_length1;
	gint _tmp0_;
	guint* array;
	gint index;
	guint* _tmp2_;
#line 140 "abstractcollection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 687 "abstractcollection.c"
	array = (_tmp1_ = g_new0 (guint, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
#line 142 "abstractcollection.vala"
	index = 0;
#line 691 "abstractcollection.c"
	{
		GeeIterator* _element_it;
#line 143 "abstractcollection.vala"
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
#line 143 "abstractcollection.vala"
		while (TRUE) {
#line 698 "abstractcollection.c"
			guint element;
#line 143 "abstractcollection.vala"
			if (!gee_iterator_next (_element_it)) {
#line 143 "abstractcollection.vala"
				break;
#line 704 "abstractcollection.c"
			}
#line 143 "abstractcollection.vala"
			element = GPOINTER_TO_UINT (gee_iterator_get (_element_it));
#line 144 "abstractcollection.vala"
			array[index++] = element;
#line 710 "abstractcollection.c"
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp2_ = array, *result_length1 = array_length1, _tmp2_);
#line 146 "abstractcollection.vala"
	return result;
#line 717 "abstractcollection.c"
	array = (g_free (array), NULL);
}


#line 149 "abstractcollection.vala"
static gint64* gee_abstract_collection_to_int64_array (GeeCollection* coll, int* result_length1) {
#line 724 "abstractcollection.c"
	gint64* result = NULL;
	gint64* _tmp1_;
	gint _array_size_;
	gint array_length1;
	gint _tmp0_;
	gint64* array;
	gint index;
	gint64* _tmp4_;
#line 149 "abstractcollection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 735 "abstractcollection.c"
	array = (_tmp1_ = g_new0 (gint64, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
#line 151 "abstractcollection.vala"
	index = 0;
#line 739 "abstractcollection.c"
	{
		GeeIterator* _element_it;
#line 152 "abstractcollection.vala"
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
#line 152 "abstractcollection.vala"
		while (TRUE) {
#line 746 "abstractcollection.c"
			gint64* _tmp2_;
			gint64 _tmp3_;
			gint64 element;
#line 152 "abstractcollection.vala"
			if (!gee_iterator_next (_element_it)) {
#line 152 "abstractcollection.vala"
				break;
#line 754 "abstractcollection.c"
			}
#line 152 "abstractcollection.vala"
			element = (_tmp3_ = *(_tmp2_ = (gint64*) gee_iterator_get (_element_it)), _g_free0 (_tmp2_), _tmp3_);
#line 153 "abstractcollection.vala"
			array[index++] = element;
#line 760 "abstractcollection.c"
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp4_ = array, *result_length1 = array_length1, _tmp4_);
#line 155 "abstractcollection.vala"
	return result;
#line 767 "abstractcollection.c"
	array = (g_free (array), NULL);
}


#line 158 "abstractcollection.vala"
static guint64* gee_abstract_collection_to_uint64_array (GeeCollection* coll, int* result_length1) {
#line 774 "abstractcollection.c"
	guint64* result = NULL;
	guint64* _tmp1_;
	gint _array_size_;
	gint array_length1;
	gint _tmp0_;
	guint64* array;
	gint index;
	guint64* _tmp4_;
#line 158 "abstractcollection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 785 "abstractcollection.c"
	array = (_tmp1_ = g_new0 (guint64, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
#line 160 "abstractcollection.vala"
	index = 0;
#line 789 "abstractcollection.c"
	{
		GeeIterator* _element_it;
#line 161 "abstractcollection.vala"
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
#line 161 "abstractcollection.vala"
		while (TRUE) {
#line 796 "abstractcollection.c"
			guint64* _tmp2_;
			guint64 _tmp3_;
			guint64 element;
#line 161 "abstractcollection.vala"
			if (!gee_iterator_next (_element_it)) {
#line 161 "abstractcollection.vala"
				break;
#line 804 "abstractcollection.c"
			}
#line 161 "abstractcollection.vala"
			element = (_tmp3_ = *(_tmp2_ = (guint64*) gee_iterator_get (_element_it)), _g_free0 (_tmp2_), _tmp3_);
#line 162 "abstractcollection.vala"
			array[index++] = element;
#line 810 "abstractcollection.c"
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp4_ = array, *result_length1 = array_length1, _tmp4_);
#line 164 "abstractcollection.vala"
	return result;
#line 817 "abstractcollection.c"
	array = (g_free (array), NULL);
}


#line 167 "abstractcollection.vala"
static glong* gee_abstract_collection_to_long_array (GeeCollection* coll, int* result_length1) {
#line 824 "abstractcollection.c"
	glong* result = NULL;
	glong* _tmp1_;
	gint _array_size_;
	gint array_length1;
	gint _tmp0_;
	glong* array;
	gint index;
	glong* _tmp2_;
#line 167 "abstractcollection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 835 "abstractcollection.c"
	array = (_tmp1_ = g_new0 (glong, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
#line 169 "abstractcollection.vala"
	index = 0;
#line 839 "abstractcollection.c"
	{
		GeeIterator* _element_it;
#line 170 "abstractcollection.vala"
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
#line 170 "abstractcollection.vala"
		while (TRUE) {
#line 846 "abstractcollection.c"
			glong element;
#line 170 "abstractcollection.vala"
			if (!gee_iterator_next (_element_it)) {
#line 170 "abstractcollection.vala"
				break;
#line 852 "abstractcollection.c"
			}
#line 170 "abstractcollection.vala"
			element = GPOINTER_TO_INT (gee_iterator_get (_element_it));
#line 171 "abstractcollection.vala"
			array[index++] = element;
#line 858 "abstractcollection.c"
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp2_ = array, *result_length1 = array_length1, _tmp2_);
#line 173 "abstractcollection.vala"
	return result;
#line 865 "abstractcollection.c"
	array = (g_free (array), NULL);
}


#line 176 "abstractcollection.vala"
static gulong* gee_abstract_collection_to_ulong_array (GeeCollection* coll, int* result_length1) {
#line 872 "abstractcollection.c"
	gulong* result = NULL;
	gulong* _tmp1_;
	gint _array_size_;
	gint array_length1;
	gint _tmp0_;
	gulong* array;
	gint index;
	gulong* _tmp2_;
#line 176 "abstractcollection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 883 "abstractcollection.c"
	array = (_tmp1_ = g_new0 (gulong, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
#line 178 "abstractcollection.vala"
	index = 0;
#line 887 "abstractcollection.c"
	{
		GeeIterator* _element_it;
#line 179 "abstractcollection.vala"
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
#line 179 "abstractcollection.vala"
		while (TRUE) {
#line 894 "abstractcollection.c"
			gulong element;
#line 179 "abstractcollection.vala"
			if (!gee_iterator_next (_element_it)) {
#line 179 "abstractcollection.vala"
				break;
#line 900 "abstractcollection.c"
			}
#line 179 "abstractcollection.vala"
			element = GPOINTER_TO_UINT (gee_iterator_get (_element_it));
#line 180 "abstractcollection.vala"
			array[index++] = element;
#line 906 "abstractcollection.c"
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp2_ = array, *result_length1 = array_length1, _tmp2_);
#line 182 "abstractcollection.vala"
	return result;
#line 913 "abstractcollection.c"
	array = (g_free (array), NULL);
}


#line 185 "abstractcollection.vala"
static float* gee_abstract_collection_to_float_array (GeeCollection* coll, int* result_length1) {
#line 920 "abstractcollection.c"
	float* result = NULL;
	float* _tmp1_;
	gint _array_size_;
	gint array_length1;
	gint _tmp0_;
	float* array;
	gint index;
	float* _tmp4_;
#line 185 "abstractcollection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 931 "abstractcollection.c"
	array = (_tmp1_ = g_new0 (float, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
#line 187 "abstractcollection.vala"
	index = 0;
#line 935 "abstractcollection.c"
	{
		GeeIterator* _element_it;
#line 188 "abstractcollection.vala"
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
#line 188 "abstractcollection.vala"
		while (TRUE) {
#line 942 "abstractcollection.c"
			float* _tmp2_;
			float _tmp3_;
			float element;
#line 188 "abstractcollection.vala"
			if (!gee_iterator_next (_element_it)) {
#line 188 "abstractcollection.vala"
				break;
#line 950 "abstractcollection.c"
			}
#line 188 "abstractcollection.vala"
			element = (_tmp3_ = *(_tmp2_ = (float*) gee_iterator_get (_element_it)), _g_free0 (_tmp2_), _tmp3_);
#line 189 "abstractcollection.vala"
			array[index++] = element;
#line 956 "abstractcollection.c"
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp4_ = array, *result_length1 = array_length1, _tmp4_);
#line 191 "abstractcollection.vala"
	return result;
#line 963 "abstractcollection.c"
	array = (g_free (array), NULL);
}


#line 194 "abstractcollection.vala"
static double* gee_abstract_collection_to_double_array (GeeCollection* coll, int* result_length1) {
#line 970 "abstractcollection.c"
	double* result = NULL;
	double* _tmp1_;
	gint _array_size_;
	gint array_length1;
	gint _tmp0_;
	double* array;
	gint index;
	double* _tmp4_;
#line 194 "abstractcollection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 981 "abstractcollection.c"
	array = (_tmp1_ = g_new0 (double, _tmp0_ = gee_collection_get_size (coll)), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
#line 196 "abstractcollection.vala"
	index = 0;
#line 985 "abstractcollection.c"
	{
		GeeIterator* _element_it;
#line 197 "abstractcollection.vala"
		_element_it = gee_iterable_iterator ((GeeIterable*) coll);
#line 197 "abstractcollection.vala"
		while (TRUE) {
#line 992 "abstractcollection.c"
			double* _tmp2_;
			double _tmp3_;
			double element;
#line 197 "abstractcollection.vala"
			if (!gee_iterator_next (_element_it)) {
#line 197 "abstractcollection.vala"
				break;
#line 1000 "abstractcollection.c"
			}
#line 197 "abstractcollection.vala"
			element = (_tmp3_ = *(_tmp2_ = (double*) gee_iterator_get (_element_it)), _g_free0 (_tmp2_), _tmp3_);
#line 198 "abstractcollection.vala"
			array[index++] = element;
#line 1006 "abstractcollection.c"
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp4_ = array, *result_length1 = array_length1, _tmp4_);
#line 200 "abstractcollection.vala"
	return result;
#line 1013 "abstractcollection.c"
	array = (g_free (array), NULL);
}


/**
 * {@inheritDoc}
 */
#line 206 "abstractcollection.vala"
static gboolean gee_abstract_collection_real_add_all (GeeAbstractCollection* self, GeeCollection* collection) {
#line 1023 "abstractcollection.c"
	gboolean result = FALSE;
	gboolean changed;
#line 206 "abstractcollection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 206 "abstractcollection.vala"
	g_return_val_if_fail (collection != NULL, FALSE);
#line 207 "abstractcollection.vala"
	if (gee_collection_get_is_empty (collection)) {
#line 1032 "abstractcollection.c"
		result = FALSE;
#line 208 "abstractcollection.vala"
		return result;
#line 1036 "abstractcollection.c"
	}
#line 211 "abstractcollection.vala"
	changed = FALSE;
#line 1040 "abstractcollection.c"
	{
		GeeIterator* _item_it;
#line 212 "abstractcollection.vala"
		_item_it = gee_iterable_iterator ((GeeIterable*) collection);
#line 212 "abstractcollection.vala"
		while (TRUE) {
#line 1047 "abstractcollection.c"
			gpointer item;
#line 212 "abstractcollection.vala"
			if (!gee_iterator_next (_item_it)) {
#line 212 "abstractcollection.vala"
				break;
#line 1053 "abstractcollection.c"
			}
#line 212 "abstractcollection.vala"
			item = gee_iterator_get (_item_it);
#line 213 "abstractcollection.vala"
			changed = changed | gee_abstract_collection_add (self, item);
#line 1059 "abstractcollection.c"
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	result = changed;
#line 215 "abstractcollection.vala"
	return result;
#line 1067 "abstractcollection.c"
}


#line 206 "abstractcollection.vala"
gboolean gee_abstract_collection_add_all (GeeAbstractCollection* self, GeeCollection* collection) {
#line 206 "abstractcollection.vala"
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->add_all (self, collection);
#line 1075 "abstractcollection.c"
}


/**
 * {@inheritDoc}
 */
#line 221 "abstractcollection.vala"
static gboolean gee_abstract_collection_real_contains_all (GeeAbstractCollection* self, GeeCollection* collection) {
#line 1084 "abstractcollection.c"
	gboolean result = FALSE;
#line 221 "abstractcollection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 221 "abstractcollection.vala"
	g_return_val_if_fail (collection != NULL, FALSE);
#line 222 "abstractcollection.vala"
	if (gee_collection_get_size (collection) > gee_collection_get_size ((GeeCollection*) self)) {
#line 1092 "abstractcollection.c"
		result = FALSE;
#line 223 "abstractcollection.vala"
		return result;
#line 1096 "abstractcollection.c"
	}
	{
		GeeIterator* _item_it;
#line 226 "abstractcollection.vala"
		_item_it = gee_iterable_iterator ((GeeIterable*) collection);
#line 226 "abstractcollection.vala"
		while (TRUE) {
#line 1104 "abstractcollection.c"
			gpointer item;
#line 226 "abstractcollection.vala"
			if (!gee_iterator_next (_item_it)) {
#line 226 "abstractcollection.vala"
				break;
#line 1110 "abstractcollection.c"
			}
#line 226 "abstractcollection.vala"
			item = gee_iterator_get (_item_it);
#line 227 "abstractcollection.vala"
			if (!gee_abstract_collection_contains (self, item)) {
#line 1116 "abstractcollection.c"
				result = FALSE;
				((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
				_g_object_unref0 (_item_it);
#line 228 "abstractcollection.vala"
				return result;
#line 1122 "abstractcollection.c"
			}
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	result = TRUE;
#line 231 "abstractcollection.vala"
	return result;
#line 1131 "abstractcollection.c"
}


#line 221 "abstractcollection.vala"
gboolean gee_abstract_collection_contains_all (GeeAbstractCollection* self, GeeCollection* collection) {
#line 221 "abstractcollection.vala"
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->contains_all (self, collection);
#line 1139 "abstractcollection.c"
}


/**
 * {@inheritDoc}
 */
#line 237 "abstractcollection.vala"
static gboolean gee_abstract_collection_real_remove_all (GeeAbstractCollection* self, GeeCollection* collection) {
#line 1148 "abstractcollection.c"
	gboolean result = FALSE;
	gboolean changed;
#line 237 "abstractcollection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 237 "abstractcollection.vala"
	g_return_val_if_fail (collection != NULL, FALSE);
#line 238 "abstractcollection.vala"
	changed = FALSE;
#line 1157 "abstractcollection.c"
	{
		GeeIterator* _item_it;
#line 239 "abstractcollection.vala"
		_item_it = gee_iterable_iterator ((GeeIterable*) collection);
#line 239 "abstractcollection.vala"
		while (TRUE) {
#line 1164 "abstractcollection.c"
			gpointer item;
#line 239 "abstractcollection.vala"
			if (!gee_iterator_next (_item_it)) {
#line 239 "abstractcollection.vala"
				break;
#line 1170 "abstractcollection.c"
			}
#line 239 "abstractcollection.vala"
			item = gee_iterator_get (_item_it);
#line 240 "abstractcollection.vala"
			changed = changed | gee_abstract_collection_remove (self, item);
#line 1176 "abstractcollection.c"
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	result = changed;
#line 242 "abstractcollection.vala"
	return result;
#line 1184 "abstractcollection.c"
}


#line 237 "abstractcollection.vala"
gboolean gee_abstract_collection_remove_all (GeeAbstractCollection* self, GeeCollection* collection) {
#line 237 "abstractcollection.vala"
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->remove_all (self, collection);
#line 1192 "abstractcollection.c"
}


/**
 * {@inheritDoc}
 */
#line 248 "abstractcollection.vala"
static gboolean gee_abstract_collection_real_retain_all (GeeAbstractCollection* self, GeeCollection* collection) {
#line 1201 "abstractcollection.c"
	gboolean result = FALSE;
	gboolean changed;
	gpointer* _tmp1_;
	gint _items_size_;
	gint items_length1;
	gint _tmp0_;
	gpointer* items;
	gint size_of_items;
#line 248 "abstractcollection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 248 "abstractcollection.vala"
	g_return_val_if_fail (collection != NULL, FALSE);
#line 249 "abstractcollection.vala"
	changed = FALSE;
#line 1216 "abstractcollection.c"
	items = (_tmp1_ = gee_abstract_collection_to_array (self, &_tmp0_), items_length1 = _tmp0_, _items_size_ = items_length1, _tmp1_);
#line 251 "abstractcollection.vala"
	size_of_items = gee_collection_get_size ((GeeCollection*) self);
#line 1220 "abstractcollection.c"
	{
		gint index;
#line 252 "abstractcollection.vala"
		index = 0;
#line 1225 "abstractcollection.c"
		{
			gboolean _tmp2_;
#line 252 "abstractcollection.vala"
			_tmp2_ = TRUE;
#line 252 "abstractcollection.vala"
			while (TRUE) {
#line 252 "abstractcollection.vala"
				if (!_tmp2_) {
#line 252 "abstractcollection.vala"
					index++;
#line 1236 "abstractcollection.c"
				}
#line 252 "abstractcollection.vala"
				_tmp2_ = FALSE;
#line 252 "abstractcollection.vala"
				if (!(index < size_of_items)) {
#line 252 "abstractcollection.vala"
					break;
#line 1244 "abstractcollection.c"
				}
#line 253 "abstractcollection.vala"
				if (!gee_collection_contains (collection, items[index])) {
#line 254 "abstractcollection.vala"
					changed = changed | gee_abstract_collection_remove (self, items[index]);
#line 1250 "abstractcollection.c"
				}
			}
		}
	}
	result = changed;
	items = (_vala_array_free (items, items_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
#line 257 "abstractcollection.vala"
	return result;
#line 1259 "abstractcollection.c"
}


#line 248 "abstractcollection.vala"
gboolean gee_abstract_collection_retain_all (GeeAbstractCollection* self, GeeCollection* collection) {
#line 248 "abstractcollection.vala"
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->retain_all (self, collection);
#line 1267 "abstractcollection.c"
}


/**
 * {@inheritDoc}
 */
#line 270 "abstractcollection.vala"
static GeeIterator* gee_abstract_collection_real_iterator (GeeAbstractCollection* self) {
#line 1276 "abstractcollection.c"
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_iterator'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


#line 270 "abstractcollection.vala"
GeeIterator* gee_abstract_collection_iterator (GeeAbstractCollection* self) {
#line 270 "abstractcollection.vala"
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->iterator (self);
#line 1287 "abstractcollection.c"
}


#line 33 "abstractcollection.vala"
GeeAbstractCollection* gee_abstract_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
#line 1293 "abstractcollection.c"
	GeeAbstractCollection * self;
#line 33 "abstractcollection.vala"
	self = (GeeAbstractCollection*) g_object_new (object_type, NULL);
#line 33 "abstractcollection.vala"
	self->priv->g_type = g_type;
#line 33 "abstractcollection.vala"
	self->priv->g_dup_func = g_dup_func;
#line 33 "abstractcollection.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 1303 "abstractcollection.c"
	return self;
}


gint gee_abstract_collection_get_size (GeeAbstractCollection* self) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->get_size (self);
}


gboolean gee_abstract_collection_get_is_empty (GeeAbstractCollection* self) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->get_is_empty (self);
}


static gboolean gee_abstract_collection_real_get_is_empty (GeeAbstractCollection* base) {
	gboolean result;
	GeeAbstractCollection* self;
	self = base;
	result = gee_collection_get_size ((GeeCollection*) self) == 0;
#line 44 "abstractcollection.vala"
	return result;
#line 1325 "abstractcollection.c"
}


static GType gee_abstract_collection_real_get_element_type (GeeIterable* base) {
	GType result;
	GeeAbstractCollection* self;
	self = (GeeAbstractCollection*) base;
	result = self->priv->g_type;
#line 264 "abstractcollection.vala"
	return result;
#line 1336 "abstractcollection.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GeeCollection* gee_abstract_collection_get_read_only_view (GeeAbstractCollection* self) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->get_read_only_view (self);
}


static GeeCollection* gee_abstract_collection_real_get_read_only_view (GeeAbstractCollection* base) {
	GeeCollection* result;
	GeeAbstractCollection* self;
	GeeCollection* instance;
	self = base;
#line 279 "abstractcollection.vala"
	instance = _g_object_ref0 (self->priv->_read_only_view);
#line 280 "abstractcollection.vala"
	if (self->priv->_read_only_view == NULL) {
#line 1359 "abstractcollection.c"
		GeeCollection* _tmp0_;
#line 281 "abstractcollection.vala"
		instance = (_tmp0_ = (GeeCollection*) gee_read_only_collection_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, (GeeCollection*) self), _g_object_unref0 (instance), _tmp0_);
#line 282 "abstractcollection.vala"
		self->priv->_read_only_view = instance;
#line 283 "abstractcollection.vala"
		g_object_add_weak_pointer ((GObject*) instance, (void**) (&self->priv->_read_only_view));
#line 1367 "abstractcollection.c"
	}
	result = instance;
#line 285 "abstractcollection.vala"
	return result;
#line 1372 "abstractcollection.c"
}


static void gee_abstract_collection_class_init (GeeAbstractCollectionClass * klass) {
	gee_abstract_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeAbstractCollectionPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_abstract_collection_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_abstract_collection_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_abstract_collection_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_abstract_collection_real_clear;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->to_array = gee_abstract_collection_real_to_array;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add_all = gee_abstract_collection_real_add_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains_all = gee_abstract_collection_real_contains_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove_all = gee_abstract_collection_real_remove_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->retain_all = gee_abstract_collection_real_retain_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_abstract_collection_real_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_is_empty = gee_abstract_collection_real_get_is_empty;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only_view = gee_abstract_collection_real_get_read_only_view;
	G_OBJECT_CLASS (klass)->get_property = gee_abstract_collection_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_abstract_collection_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_abstract_collection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_SIZE, "size");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_IS_EMPTY, "is-empty");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_ELEMENT_TYPE, "element-type");
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_READ_ONLY_VIEW, "read-only-view");
}


static void gee_abstract_collection_gee_iterable_interface_init (GeeIterableIface * iface) {
	gee_abstract_collection_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = (GeeIterator* (*)(GeeIterable*)) gee_abstract_collection_iterator;
	iface->get_element_type = gee_abstract_collection_real_get_element_type;
}


static void gee_abstract_collection_gee_collection_interface_init (GeeCollectionIface * iface) {
	gee_abstract_collection_gee_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->contains = (gboolean (*)(GeeCollection* ,gconstpointer)) gee_abstract_collection_contains;
	iface->add = (gboolean (*)(GeeCollection* ,gconstpointer)) gee_abstract_collection_add;
	iface->remove = (gboolean (*)(GeeCollection* ,gconstpointer)) gee_abstract_collection_remove;
	iface->clear = (void (*)(GeeCollection*)) gee_abstract_collection_clear;
	iface->to_array = (gpointer* (*)(GeeCollection* ,int*)) gee_abstract_collection_to_array;
	iface->add_all = (gboolean (*)(GeeCollection* ,GeeCollection*)) gee_abstract_collection_add_all;
	iface->contains_all = (gboolean (*)(GeeCollection* ,GeeCollection*)) gee_abstract_collection_contains_all;
	iface->remove_all = (gboolean (*)(GeeCollection* ,GeeCollection*)) gee_abstract_collection_remove_all;
	iface->retain_all = (gboolean (*)(GeeCollection* ,GeeCollection*)) gee_abstract_collection_retain_all;
	iface->get_size = (gint (*) (GeeCollection *)) gee_abstract_collection_get_size;
	iface->get_is_empty = (gboolean (*) (GeeCollection *)) gee_abstract_collection_get_is_empty;
	iface->get_read_only_view = (GeeCollection* (*) (GeeCollection *)) gee_abstract_collection_get_read_only_view;
}


static void gee_abstract_collection_instance_init (GeeAbstractCollection * self) {
	self->priv = GEE_ABSTRACT_COLLECTION_GET_PRIVATE (self);
}


static void gee_abstract_collection_finalize (GObject* obj) {
	GeeAbstractCollection * self;
	self = GEE_ABSTRACT_COLLECTION (obj);
	G_OBJECT_CLASS (gee_abstract_collection_parent_class)->finalize (obj);
}


/**
 * Skeletal implementation of the {@link Collection} interface.
 *
 * Contains common code shared by all collection implementations.
 *
 * @see AbstractList
 * @see AbstractSet
 * @see AbstractMultiSet
 */
GType gee_abstract_collection_get_type (void) {
	static volatile gsize gee_abstract_collection_type_id__volatile = 0;
	if (g_once_init_enter (&gee_abstract_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeAbstractCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_abstract_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeAbstractCollection), 0, (GInstanceInitFunc) gee_abstract_collection_instance_init, NULL };
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) gee_abstract_collection_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_collection_info = { (GInterfaceInitFunc) gee_abstract_collection_gee_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_abstract_collection_type_id;
		gee_abstract_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeAbstractCollection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (gee_abstract_collection_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_type_add_interface_static (gee_abstract_collection_type_id, GEE_TYPE_COLLECTION, &gee_collection_info);
		g_once_init_leave (&gee_abstract_collection_type_id__volatile, gee_abstract_collection_type_id);
	}
	return gee_abstract_collection_type_id__volatile;
}


static void gee_abstract_collection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeAbstractCollection * self;
	self = GEE_ABSTRACT_COLLECTION (object);
	switch (property_id) {
		case GEE_ABSTRACT_COLLECTION_IS_EMPTY:
		g_value_set_boolean (value, gee_abstract_collection_get_is_empty (self));
		break;
		case GEE_ABSTRACT_COLLECTION_ELEMENT_TYPE:
		g_value_set_gtype (value, gee_iterable_get_element_type ((GeeIterable*) self));
		break;
		case GEE_ABSTRACT_COLLECTION_READ_ONLY_VIEW:
		g_value_take_object (value, gee_abstract_collection_get_read_only_view (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_abstract_collection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeAbstractCollection * self;
	self = GEE_ABSTRACT_COLLECTION (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_ABSTRACT_COLLECTION_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_ABSTRACT_COLLECTION_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ABSTRACT_COLLECTION_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




