/* gEDA - GPL Electronic Design Automation
 * libgeda - gEDA's library
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


/* DO NOT read or edit this file ! Use ../noweb/s_cue.nw instead */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <ctype.h>

#ifndef HAVE_VSNPRINTF
#include <stdarg.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>

#include <guile/gh.h>

#include "defines.h"
#include "struct.h"
#include "defines.h"
#include "globals.h"

#include "o_types.h"

#include "../include/colors.h"
#include "../include/prototype.h"

void s_cue_postscript_fillbox(TOPLEVEL * w_current, FILE * fp, int x,
			      int y)
{
  int offset;
  int offset2;

  /* hard coded values */
  offset = 7 * 6;
  offset2 = 7;

  if (w_current->print_color) {
    f_print_set_color(fp, w_current->net_endpoint_color);
  }

  fprintf(fp, "newpath\n");
  fprintf(fp, "%d mils %d mils moveto\n", x - offset, y - offset);
  fprintf(fp, "%d %d fbox\n", offset2, offset2);
}


void s_cue_postscript_fillcircle(TOPLEVEL * w_current, FILE * fp, int x,
				 int y)
{
  int offset2;

  offset2 = 7;

  fprintf(fp, "newpath\n");
  fprintf(fp, "%d mils %d mils\n", x, y);
  fprintf(fp, "%d\n", offset2 / 2);
  fprintf(fp, "0 360 arc\n");
  fprintf(fp, "fill\n");
}



#ifdef HAS_LIBGDGEDA
void s_cue_image_fillbox(TOPLEVEL * w_current, OBJECT * object,
			 int world_x, int world_y)
{
  int endpoint_color;
  int offset, offset2;
  int x, y;

  if (w_current->image_color == TRUE) {
    endpoint_color = o_image_geda2gd_color(w_current->net_endpoint_color);
  } else {
    endpoint_color = image_black;
  }

  WORLDtoSCREEN(w_current, world_x, world_y, &x, &y);

  offset = SCREENabs(w_current, 30);
  offset2 = offset * 2;

  gdImageFilledRectangle(current_im_ptr,
			 x - offset, y - offset, x - offset + offset2,
			 y - offset + offset2, endpoint_color);

}


void s_cue_image_fillcircle(TOPLEVEL * w_current, int world_x, int world_y)
{
  int endpoint_color;
  int offset, offset2;
  int i;
  int x, y;

  if (w_current->image_color == TRUE) {
    endpoint_color = o_image_geda2gd_color(w_current->net_endpoint_color);
  } else {
    endpoint_color = image_black;
  }

  WORLDtoSCREEN(w_current, world_x, world_y, &x, &y);

  offset = SCREENabs(w_current, 30);
  offset2 = offset * 2;

  gdImageArc(current_im_ptr, x, y,
	     offset2 * 1.25, offset2 * 1.25, 0, 360, endpoint_color);

  for (i = 0; i < offset2 * 1.25; i++) {
    gdImageArc(current_im_ptr, x, y, i, i, 0, 360, endpoint_color);
  }

}


#endif

void s_cue_output_all(TOPLEVEL * w_current, OBJECT * head, FILE * fp,
		      int type)
{
  OBJECT *o_current;

  o_current = head;
  while (o_current != NULL) {
    switch (o_current->type) {
    case (OBJ_NET):
    case (OBJ_BUS):
    case (OBJ_PIN):
      s_cue_output_single(w_current, o_current, fp, type);
      break;

    case (OBJ_COMPLEX):
      s_cue_output_all(w_current, o_current->complex->prim_objs, fp, type);
      break;

    }

    o_current = o_current->next;
  }
}


void
s_cue_output_lowlevel(TOPLEVEL * w_current, OBJECT * object, int whichone,
		      FILE * fp, int output_type)
{
  int x, y;
  GList *cl_current;
  CONN *conn;
  int type, count = 0;
  int done = FALSE;
  int size, x2size;

  x = object->line->x[whichone];
  y = object->line->y[whichone];

  type = CONN_ENDPOINT;

  cl_current = object->conn_list;
  while (cl_current != NULL && !done) {
    conn = (CONN *) cl_current->data;

    if (conn->x == x && conn->y == y) {
      switch (conn->type) {

      case (CONN_ENDPOINT):
	count++;
	break;

      case (CONN_MIDPOINT):
	type = CONN_MIDPOINT;
	done = TRUE;
	count = 0;
	break;
      }
    }

    cl_current = cl_current->next;
  }

#if DEBUG
  printf("type: %d count: %d\n", type, count);
#endif

  switch (type) {

  case (CONN_ENDPOINT):
    if (object->type == OBJ_NET) {	/* only nets have these cues */
      if (count < 1) {		/* Didn't find anything connected there */
	if (output_type == POSTSCRIPT) {
	  s_cue_postscript_fillbox(w_current, fp, x, y);
#ifdef HAS_LIBGDGEDA
	} else if (output_type == PNG) {
	  s_cue_image_fillbox(w_current, object, x, y);
#endif
	}


      } else if (count >= 2) {
	if (output_type == POSTSCRIPT) {
	  s_cue_postscript_fillcircle(w_current, fp, x, y);
#ifdef HAS_LIBGDGEDA
	} else if (output_type == PNG) {
	  s_cue_image_fillcircle(w_current, x, y);
#endif
	}
      }
    }
    break;

  case (CONN_MIDPOINT):
    if (output_type == POSTSCRIPT) {
      s_cue_postscript_fillcircle(w_current, fp, x, y);
#ifdef HAS_LIBGDGEDA
    } else if (output_type == PNG) {
      s_cue_image_fillcircle(w_current, x, y);
#endif
    }
  }

}


void
s_cue_output_lowlevel_midpoints(TOPLEVEL * w_current, OBJECT * object,
				FILE * fp, int output_type)
{
  int x, y, screen_x, screen_y;
  GList *cl_current;
  CONN *conn;
  int size;

  cl_current = object->conn_list;
  while (cl_current != NULL) {
    conn = (CONN *) cl_current->data;

    switch (conn->type) {
    case (CONN_MIDPOINT):

      x = conn->x;
      y = conn->y;
      if (output_type == POSTSCRIPT) {
	s_cue_postscript_fillcircle(w_current, fp, x, y);
#ifdef HAS_LIBGDGEDA
      } else if (output_type == PNG) {
	s_cue_image_fillcircle(w_current, x, y);
#endif
      }
      break;
    }


    cl_current = cl_current->next;
  }
}


void s_cue_output_single(TOPLEVEL * w_current, OBJECT * object, FILE * fp,
			 int type)
{
  if (!object) {
    return;
  }

  if (object->type != OBJ_NET && object->type != OBJ_PIN &&
      object->type != OBJ_BUS) {
    return;
  }

  s_cue_output_lowlevel(w_current, object, 0, fp, type);
  s_cue_output_lowlevel(w_current, object, 1, fp, type);
  s_cue_output_lowlevel_midpoints(w_current, object, fp, type);
}
