/***************************************************************************
  dbmusicglobals.h  -  description
  -------------------
begin                : Wed Dec 19 2001
copyright            : (C) 2001 by Will DeRousse
email                : badhack@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/**
 * This file is the central location for all includes, global structs and variables,
 * and for processing the compiling environment.
 * Put includes in this file instead of individual headers to maintain consistency.
 * @short Central location for includes and global decs.
 * @author Will DeRousse <badhack@users.sourceforge.net>
 */

#ifndef DBMUSICGLOBALS_H
#define DBMUSICGLOBALS_H

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

// low level server codes
#define	DB_EMPTY_QUERY		-99
#define	DB_FATAL_ERROR		-98
#define	DB_UNKNOWN_ERROR	-97
#define	DB_NULL_QUERY		-96
#define	DB_CONNECTION_BAD	-95
#define DB_BAD_RESPONSE 	-83
#define DB_NONFATAL_ERROR 	-82
#define	DB_TUPLES_OK		1
#define	DB_COMMAND_OK		2
#define EVERYTHING_OK 		99

#define ARTIST_DELETE_FAIL	-89
#define ARTIST_ADD_FAIL		-87
#define ARTIST_UPDATE_FAIL	-86
#define ARTIST_GET_FAIL		-84
#define ARTIST_SUM_FAIL		-67
#define TITLE_DELETE_FAIL	-88
#define TITLE_ADD_FAIL		-80
#define TITLE_UPDATE_FAIL	-79
#define TITLE_GET_FAIL		-71
#define TITLE_SUM_FAIL		-66
#define TRACK_DELETE_FAIL	-83
#define TRACK_ADD_FAIL		-74
#define TRACK_UPDATE_FAIL	-72
#define TRACK_GET_FAIL		-70
#define TRACK_SUM_FAIL		-65
#define CATEGORY_ADD_FAIL	-78
#define CATEGORY_DELETE_FAIL	-77
#define CATEGORY_UPDATE_FAIL	-76
#define CATEGORY_SUM_FAIL	-64
#define CATEGORY_GET_FAIL	-63
#define FILE_OPEN_FAIL 		-94
#define VACUUM_FAIL		-93
#define TABLE_FORMAT_FAIL	-92
#define NO_MEMORY		-90
#define NO_TUPLES		-85
#define WORK_FAIL		-81
#define COUNT_FAIL		-82
#define VERSION_GET_FAIL	-69

/**
 * Default values
 */
#define DATA_BASE "dbmusic.dump"
#define DB_VERSION "0.92"

#define KBOXSET 0
#define KFORMAT 1
#define KGENRE 2
#define KLABEL 3
#define KMETHOD 4
#define KTYPE 5
#define KBTE 6

#define REPORT_ALL 1
#define REPORT_YES 2
#define REPORT_NO 3
#define ASC 1
#define DES 2

#define ARTIST 0
#define TITLE 1
#define TRACK 2

/*
 *SUSE 7.2 fix (maybe others who knows)
 */
#define HAVE_CXX_STRING_HEADER 1

/**
 *  Library Includes
 */
#include <qmap.h>
#include <qlistview.h>

/**
 * Global struct prototypes
 */

/**
 * Struct for holding artist information.
 * @param aid DB AID index
 * @param notes Artist specific notes.
 * @param first First title/year of conception
 * @param last Demise/Last release
 * @param homepage Homepage
 * @param name Name of artist
 * @param follow Do you still collect the artist?
 */
struct ArtistInfo {
	QString aid,notes,first,last,homepage,name;
	bool follow;
};


/** colorInfo
 * Struct for holding color information of type QString in form #RRGGBB.
 *
 * @param artist For artists/artist information.
 * @param background For background color.
 * @param misc   For Headers, misc "other"/"leftover" useage. May be expanded upon in the future.
 * @param title  For titles/title information.
 * @param totals For totals, sums, etc.
 * @param track  For tracks/track information.
 * @param text  For text color.
 */
struct colorInfo {
	QString artist, background, misc, title, totals, track, text;
};

/**
 * Struct for holding database connection information
 *
 * Used to hold data for making database connections
 * @param db_name Name of the database
 * @param db_location web address/IP
 * @param db_passwd passwd for user (blank if none)
 * @param db_port port database is receiving connections on
 * @param db_user username used to connect to db (if blank then what you are logged in as)
 * @param pg_version The version of the PostgreSQL server (if set)
 */
struct DbInfo {
	QString db_name, db_location, db_passwd, db_port, db_user;
	QString pg_version;
};

/**
 * Struct to hold which columns to display in the main title view.
 * @param collected Title collected or not
 * @param length Length of Title
 * @param nod Number of Media
 * @param notracks Number of Tracks
 * @param fid Format
 * @param gid Genre
 * @param lid Label
 * @param mid Method
 * @param tid Type
 * @param yearstart Year Start
 * @param yearend Year End
 * @param rating Rating of the Music
 * @param quality Quality of Recording
 */
struct enabledTitleColumns {
	bool collected,length,nod,notracks,fid,gid,lid,mid,tid,yearstart,yearend,rating,quality;
};

/**
 * Struct for holding report options. Used when generating reports
 * custom tailored to the users selection.
 *
 * @param date_range_enabled Used to set if the report will be restricted by a date range.
 * @param sort_time If sort by number is enabled.
 * @param report_type All, Collected, or Not Collected
 * @param sort_order Ascending or Descending
 * @param end End year (inclusive) for date range
 * @param start Start year (inclusive) for date range
 * @param charset Locale charset
 * @param rfont Report font
 */
struct reportInfo {
	bool date_range_enabled, sort_time;
	int report_type, sort_order;
	QString end, start, charset;
	QFont rfont;
};

/**
 * Struct for holding title information.
 * @param name Name of title
 * @param cdid DB CDID Index
 * @param format Format name
 * @param genre Genre name
 * @param label Label name
 * @param method Method name
 * @param type Type name
 * @param boxset Boxset name
 * @param yearstart Yearstart
 * @param yearend Yearend
 * @param nod Number of media
 * @param notracks Number of tracks
 * @param length Length of title
 * @param notes Title specific notes
 * @param picpath Path to the pic
 * @param collected Is this title in your collection?
 * @param rating How much do you like the release?
 * @param quality How good is the recording?
 */
struct TitleInfo {
	QString name,cdid,format,genre,label,method,type,boxset,yearstart,yearend,nod,notracks,length,notes,picpath,rating,quality;
	bool collected;
};

/**
 * Struct for holding track information.
 * @param trackid Track ID
 * @param name Track Name
 * @param length Track Length (xx:xx:xx)
 */
struct TrackInfo {
	QString trackid,name,length;
};


/**
 * QMap containing two qstrings to hold table name and index.
 *
 * Used to cache data from the db to minimize transactions.
 * This is just a generic QString hash.
 */
typedef QMap<QString,QString> StringHashQMap;

/**
 * QMap containg a pointer to a QListViewItem Key and an associated text data value.
 *
 * Used to hold pointers for building the title view in the main window.
 * By keeping track of the pointers, we can build nested structures of QString names.
 */
typedef QMap<QString,QListViewItem*> BoxSetMap;

#endif

