/***************************************************************************
                          category.cpp  -  description
                             -------------------
    begin                : Sun Dec 23 2001
    copyright            : (C) 2001 by root
    email                : root@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dbmusic.h"
/* Put here so it's not automatically included by dbinit.h */
#include "dbmusicvalidator.h"


/** Adds a category to the database.
 *
 *@param int Category type.
 *@param QString Name
 */
int dbMusic::addCategory(const int &t, const QString &s)
{
	if (s.isEmpty())
		return CATEGORY_ADD_FAIL;
	sqlstring="INSERT INTO ";

	switch (t)
	{
		case KBOXSET:
			if (boxset->find(s)!=boxset->end())
				return EVERYTHING_OK;
			sqlstring.append("boxset");
			break;
		case KFORMAT:
			if (formatmap->find(s)!=formatmap->end())
				return EVERYTHING_OK;
			sqlstring.append("format");
			break;
		case KGENRE:
			if (genremap->find(s)!=genremap->end())
				return EVERYTHING_OK;
			sqlstring.append("genre");
			break;
		case KLABEL:
			if (labelmap->find(s)!=labelmap->end())
				return EVERYTHING_OK;
			sqlstring.append("label");
			break;
		case KMETHOD:
			if (methodmap->find(s)!=methodmap->end())
				return EVERYTHING_OK;
			sqlstring.append("method");
			break;
		case KTYPE:
			if (typemap->find(s)!=typemap->end())
				return EVERYTHING_OK;
			sqlstring.append("type");
			break;
		case KBTE:
			sqlstring.append("explore");
			break;
		default:
			return NO_TUPLES;
	};

	sqlstring.append(" (name) VALUES ('");
	sqlstring.append(validateQString(s));
	sqlstring.append("')");

	cerr << "addCategory: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck() < 0)
		return CATEGORY_ADD_FAIL;

	fillQMap(t);
	fillReverseQMap(t);

	return EVERYTHING_OK;
}
/** Deletes a specific category entry from the database.
 *
 *@param int Category type
 *@param QString Name
 */
int dbMusic::deleteCategory(const int &t, const QString &s)
{
	if (s.isEmpty())
		return CATEGORY_DELETE_FAIL;
	QString z;
	switch (t)
	{
		case KBOXSET:
			sqlstring="DELETE FROM boxset WHERE grpid=";
			sqlstring.append(boxset->find(s).data());
			break;
		case KFORMAT:
			sqlstring="DELETE FROM format WHERE fid=";
			sqlstring.append(formatmap->find(s).data());
			break;
		case KGENRE:
			sqlstring="DELETE FROM genre WHERE gid=";
			sqlstring.append(genremap->find(s).data());
			break;
		case KLABEL:
			sqlstring="DELETE FROM label WHERE lid=";
			sqlstring.append(labelmap->find(s).data());
			break;
		case KMETHOD:
			sqlstring="DELETE FROM method WHERE mid=";
			sqlstring.append(methodmap->find(s).data());
			break;
		case KTYPE:
			sqlstring="DELETE FROM type WHERE tid=";
			sqlstring.append(typemap->find(s).data());
			break;
		case KBTE:
			z="SELECT eid FROM explore WHERE name='";
			z.append(validateQString(s));
			z.append("'");
			cerr << "deleteCategory: " << sqlstring << endl;
			stat=Exec(z.local8Bit().data());
			if (execCheck() < 0)
				return CATEGORY_GET_FAIL;
			z=GetValue(0,0);
			sqlstring="DELETE FROM explore WHERE eid=";
			sqlstring.append(z);
			break;
		default:
			return NO_TUPLES;
	};
	cerr << "deleteCategory: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck() < 0)
		return CATEGORY_DELETE_FAIL;

	switch (t)
	{
		case KBOXSET:
			boxset->remove(s);
			break;
		case KFORMAT:
			formatmap->remove(s);
			break;
		case KGENRE:
			genremap->remove(s);
			break;
		case KLABEL:
			labelmap->remove(s);
			break;
		case KMETHOD:
			methodmap->remove(s);
			break;
		case KTYPE:
			typemap->remove(s);
			break;
		case KBTE:
			break;
		default:
			return NO_TUPLES;
	};


	fillReverseQMap(t);

	return EVERYTHING_OK;
}
/** Updates a specific category entry.
 *
 *@param int Category type
 *@param QString new value
 *@param QString old value
 */
int dbMusic::updateCategory(const int &t, const QString &snew, const QString &old)
{
	if (snew.isEmpty())
		return CATEGORY_UPDATE_FAIL;
	if (old.isEmpty())
		return CATEGORY_UPDATE_FAIL;
	QString dat;

	switch (t)
	{
		case KBOXSET:
			dat=boxset->find(old).data();
			sqlstring="UPDATE boxset SET name='";
			sqlstring.append(validateQString(snew));
			sqlstring.append("' WHERE grpid=");
			break;
		case KFORMAT:
			dat=formatmap->find(old).data();
			sqlstring="UPDATE format SET name='";
			sqlstring.append(validateQString(snew));
			sqlstring.append("' WHERE fid=");
			break;
		case KGENRE:
			dat=genremap->find(old).data();
			sqlstring="UPDATE genre SET name='";
			sqlstring.append(validateQString(snew));
			sqlstring.append("' WHERE gid=");
			break;
		case KLABEL:
			dat=labelmap->find(old).data();
			sqlstring="UPDATE label SET name='";
			sqlstring.append(validateQString(snew));
			sqlstring.append("' WHERE lid=");
			break;
		case KMETHOD:
			dat=methodmap->find(old).data();
			sqlstring="UPDATE method SET name='";
			sqlstring.append(validateQString(snew));
			sqlstring.append("' WHERE mid=");
			break;
		case KTYPE:
			dat=typemap->find(old).data();
			sqlstring="UPDATE type SET name='";
			sqlstring.append(validateQString(snew));
			sqlstring.append("' WHERE tid=");
			break;
		case KBTE:
			dat="SELECT eid FROM explore WHERE name='";
			dat.append(validateQString(old));
			dat.append("'");
			cerr << "getCategory: " << sqlstring << endl;
			stat=Exec(dat.local8Bit().data());
			if (execCheck() < 0)
				return CATEGORY_ADD_FAIL;
			dat=GetValue(0,0);
			sqlstring="UPDATE explore SET name='";
			sqlstring.append(validateQString(snew));
			sqlstring.append("' WHERE eid=");
			break;
		default:
			return NO_TUPLES;
	};
	sqlstring.append(dat);

	cerr << "updateCategory:" << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck() < 0)
		return CATEGORY_UPDATE_FAIL;

	switch (t)
	{
		case KBOXSET:
			boxset->remove(old);
			boxset->insert(snew,dat);
			break;
		case KFORMAT:
			formatmap->remove(old);
			formatmap->insert(snew,dat);
			break;
		case KGENRE:
			genremap->remove(old);
			genremap->insert(snew,dat);
			break;
		case KLABEL:
			labelmap->remove(old);
			labelmap->insert(snew,dat);
			break;
		case KMETHOD:
			methodmap->remove(old);
			methodmap->insert(snew,dat);
			break;
		case KTYPE:
			typemap->remove(old);
			typemap->insert(snew,dat);
			break;
		case KBTE:
			break;
		default:
			return CATEGORY_UPDATE_FAIL;
	};

	fillReverseQMap(t);

	return EVERYTHING_OK;
}
