/***************************************************************************
 $RCSfile: readerclient.h,v $
 -------------------
 cvs         : $Id: readerclient.h,v 1.7 2003/05/08 12:26:36 aquamaniac Exp $
 begin       : Sat Jan 11 2003
 copyright   : (C) 2003 by Martin Preuss
 email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef READERCLIENT_H
#define READERCLIENT_H "$Id"


#include <ctclient.h>

#ifdef __cplusplus
extern "C" {
#endif


struct READERCLIENT_READERDESCRSTRUCT {
  unsigned int flags;
  char name[64];
  char type[64];
};
typedef struct READERCLIENT_READERDESCRSTRUCT READERCLIENT_READERDESCR;

READERCLIENT_READERDESCR *ReaderClient_ReaderDescr_new();
void ReaderClient_ReaderDescr_free(READERCLIENT_READERDESCR *rd);


CHIPCARD_API ERRORCODE
  ReaderClient_RequestPing(CTCLIENTDATA *cd,
			   int *requestid,
			   int serviceid);
CHIPCARD_API ERRORCODE
  ReaderClient_CheckPing(CTCLIENTDATA *cd,
			 int requestid);

CHIPCARD_API ERRORCODE
  ReaderClient_RequestAllocReader(CTCLIENTDATA *cd,
				  int *requestid,
				  int serviceid,
				  int tid);
CHIPCARD_API ERRORCODE
  ReaderClient_CheckAllocReader(CTCLIENTDATA *cd,
				int requestid,
				int *tid,
				int *serviceId,
				READERCLIENT_READERDESCR **rd);

CHIPCARD_API ERRORCODE
  ReaderClient_RequestReleaseReader(CTCLIENTDATA *cd,
				    int *requestid,
				    int serviceid,
				    int tid);
CHIPCARD_API ERRORCODE
  ReaderClient_CheckReleaseReader(CTCLIENTDATA *cd,
				  int requestid);

CHIPCARD_API ERRORCODE
  ReaderClient_RequestConnectReader(CTCLIENTDATA *cd,
				    int *requestid,
				    int serviceid,
				    int tid,
				    int cardId,
				    int waitForIt);

CHIPCARD_API ERRORCODE
  ReaderClient_CheckConnectReader(CTCLIENTDATA *cd,
				  int requestid,
				  int *result,
				  char *atrbuffer,
				  int *atrbufferlength);
CHIPCARD_API ERRORCODE
  ReaderClient_RequestDisconnectReader(CTCLIENTDATA *cd,
				       int *requestid,
				       int serviceid,
				       int tid);
CHIPCARD_API ERRORCODE
  ReaderClient_CheckDisconnectReader(CTCLIENTDATA *cd,
				     int requestid,
				     int *result);
CHIPCARD_API ERRORCODE
  ReaderClient_RequestCommandReader(CTCLIENTDATA *cd,
				    int *requestid,
				    int serviceid,
				    int tid,
				    const char *sendBuffer,
				    int sendBufferLength);
CHIPCARD_API ERRORCODE
  ReaderClient_CheckCommandReader(CTCLIENTDATA *cd,
				  int requestid,
				  int *result,
				  char *recvBuffer,
				  int *recvBufferLength);

CHIPCARD_API ERRORCODE
  ReaderClient_RequestFindReader(CTCLIENTDATA *cd,
				 int *requestid,
				 int serviceid,
				 const char *readerType,
				 unsigned int readerFlags,
				 unsigned int readerFlagsMask);
CHIPCARD_API ERRORCODE
  ReaderClient_CheckFindReader(CTCLIENTDATA *cd,
			       int requestid,
			       int *readerbuffer,
			       int *readerBufferLength);

CHIPCARD_API ERRORCODE
  ReaderClient_RequestStatReader(CTCLIENTDATA *cd,
				 int *requestid,
				 int serviceid,
				 int tid);
CHIPCARD_API ERRORCODE
  ReaderClient_CheckStatReader(CTCLIENTDATA *cd,
			       int requestid,
			       int *result,
			       unsigned int *status,
			       char *atrbuffer,
			       int *atrlen);


CHIPCARD_API ERRORCODE
  ReaderClient_RequestWaitReader(CTCLIENTDATA *cd,
				 int *requestid,
				 int serviceid,
				 int mustChange,
				 const char *readerType,
				 unsigned int readerFlags,
				 unsigned int readerFlagsMask,
				 unsigned int status,
				 unsigned int statusMask,
				  unsigned int statusDelta);


CHIPCARD_API ERRORCODE
  ReaderClient_CheckWaitReader(CTCLIENTDATA *cd,
			       int requestid,
			       int *tid,
			       unsigned int *status,
			       unsigned int *readerflags,
			       unsigned int *cardId);

CHIPCARD_API ERRORCODE
  ReaderClient_RequestStopWaitReader(CTCLIENTDATA *cd,
				     int *requestid,
				     int serviceid,
				     int prevRequest);
CHIPCARD_API ERRORCODE
  ReaderClient_CheckStopWaitReader(CTCLIENTDATA *cd,
				   int requestid,
				   int *result);

CHIPCARD_API ERRORCODE
  ReaderClient_RequestStopOpenReader(CTCLIENTDATA *cd,
				     int *requestid,
				     int serviceid,
				     int prevRequest);
CHIPCARD_API ERRORCODE
  ReaderClient_CheckStopOpenReader(CTCLIENTDATA *cd,
				   int requestid,
				   int *result);

#ifdef __cplusplus
}
#endif

#endif

